/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.room.Ignore;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.Range;

public class AllocatedSceneRange
extends Range {
    @Expose
    private int firstScene;
    @Expose
    private int lastScene;
    public static final Parcelable.Creator<AllocatedSceneRange> CREATOR = new Parcelable.Creator<AllocatedSceneRange>(){

        public AllocatedSceneRange createFromParcel(Parcel in) {
            return new AllocatedSceneRange(in);
        }

        public AllocatedSceneRange[] newArray(int size) {
            return new AllocatedSceneRange[size];
        }
    };

    @Override
    public final int getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public final int getUpperBound() {
        return this.upperBound;
    }

    public List<Range> minus(Range left, Range right) {
        return null;
    }

    public AllocatedSceneRange(int firstScene, int lastScene) {
        this.lowerBound = 1;
        this.upperBound = 65535;
        if (firstScene < this.lowerBound || firstScene > this.upperBound) {
            throw new IllegalArgumentException("firstScene value must range from 0x0000 to 0xFFFF");
        }
        if (lastScene < this.lowerBound || lastScene > this.upperBound) {
            throw new IllegalArgumentException("lastScene value must range from 0x0000 to 0xFFFF");
        }
        this.firstScene = firstScene;
        this.lastScene = lastScene;
    }

    @Ignore
    AllocatedSceneRange() {
    }

    protected AllocatedSceneRange(Parcel in) {
        this.lowerBound = in.readInt();
        this.upperBound = in.readInt();
        this.firstScene = in.readInt();
        this.lastScene = in.readInt();
    }

    public int getLastScene() {
        return this.lastScene;
    }

    public void setLastScene(int lastScene) {
        this.lastScene = lastScene;
    }

    public int getFirstScene() {
        return this.firstScene;
    }

    public void setFirstScene(int firstScene) {
        this.firstScene = firstScene;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.lowerBound);
        dest.writeInt(this.upperBound);
        dest.writeInt(this.firstScene);
        dest.writeInt(this.lastScene);
    }

    @Override
    public int range() {
        return this.lastScene - this.firstScene;
    }

    @Override
    public boolean overlaps(@NonNull Range otherRange) {
        if (otherRange instanceof AllocatedSceneRange) {
            AllocatedSceneRange otherSceneRange = (AllocatedSceneRange)otherRange;
            return this.overlaps(this.firstScene, this.lastScene, otherSceneRange.getFirstScene(), otherSceneRange.getLastScene());
        }
        return false;
    }

    @NonNull
    public static List<AllocatedSceneRange> minus(@NonNull List<AllocatedSceneRange> ranges, @NonNull AllocatedSceneRange other) {
        List<AllocatedSceneRange> results = new ArrayList<AllocatedSceneRange>();
        for (AllocatedSceneRange range : ranges) {
            results.addAll(range.minus(other));
            results = AllocatedSceneRange.mergeSceneRanges(results);
        }
        return results;
    }

    private List<AllocatedSceneRange> minus(AllocatedSceneRange other) {
        ArrayList<AllocatedSceneRange> results = new ArrayList<AllocatedSceneRange>();
        if (other.firstScene > this.firstScene) {
            AllocatedSceneRange leftSlice = new AllocatedSceneRange(this.firstScene, Math.min(this.lastScene, other.firstScene - 1));
            results.add(leftSlice);
        }
        if (other.lastScene < this.lastScene) {
            AllocatedSceneRange rightSlice = new AllocatedSceneRange(Math.max(other.lastScene + 1, this.firstScene), this.lastScene);
            results.add(rightSlice);
        }
        return results;
    }

    @Override
    public boolean equals(Object o) {
        AllocatedSceneRange range = (AllocatedSceneRange)o;
        return this.firstScene == range.firstScene && this.lastScene == range.lastScene;
    }

    @Override
    public int hashCode() {
        int result = this.firstScene;
        result = 31 * result + this.lastScene;
        return result;
    }
}

