/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.nio.ByteBuffer;
import java.util.Arrays;
import no.nordicsemi.android.mesh.InternalProvisioningCallbacks;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.MeshProvisioningStatusCallbacks;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningState;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedMeshNode;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class ProvisioningRandomConfirmationState
extends ProvisioningState {
    private final String TAG = ProvisioningRandomConfirmationState.class.getSimpleName();
    private final UnprovisionedMeshNode node;
    private final MeshProvisioningStatusCallbacks mStatusCallbacks;
    private final InternalProvisioningCallbacks provisioningCallbacks;
    private final InternalTransportCallbacks mInternalTransportCallbacks;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ProvisioningRandomConfirmationState(@NonNull UnprovisionedMeshNode node, @NonNull InternalProvisioningCallbacks internalProvisioningCallbacks, @NonNull InternalTransportCallbacks internalTransportCallbacks, @NonNull MeshProvisioningStatusCallbacks provisioningStatusCallbacks) {
        this.node = node;
        this.provisioningCallbacks = internalProvisioningCallbacks;
        this.mInternalTransportCallbacks = internalTransportCallbacks;
        this.mStatusCallbacks = provisioningStatusCallbacks;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_RANDOM;
    }

    @Override
    public void executeSend() {
        byte[] provisionerRandomConfirmationPDU = this.createProvisionerRandomPDU();
        this.mStatusCallbacks.onProvisioningStateChanged(this.node, ProvisioningState.States.PROVISIONING_CONFIRMATION_SENT, provisionerRandomConfirmationPDU);
        this.mInternalTransportCallbacks.sendProvisioningPdu(this.node, provisionerRandomConfirmationPDU);
    }

    @Override
    public boolean parseData(@NonNull byte[] data) {
        this.mStatusCallbacks.onProvisioningStateChanged(this.node, ProvisioningState.States.PROVISIONING_RANDOM_RECEIVED, data);
        this.parseProvisioneeRandom(data);
        return this.provisioneeMatches();
    }

    private byte[] createProvisionerRandomPDU() {
        byte[] provisionerRandom = this.node.getProvisionerRandom();
        ByteBuffer buffer = ByteBuffer.allocate(provisionerRandom.length + 2);
        buffer.put(new byte[]{3, 6});
        buffer.put(provisionerRandom);
        byte[] data = buffer.array();
        Log.v((String)this.TAG, (String)("Provisioner random PDU: " + MeshParserUtils.bytesToHex(data, false)));
        return data;
    }

    private boolean provisioneeMatches() {
        byte[] provisioneeRandom = this.node.getProvisioneeRandom();
        byte[] confirmationInputs = this.provisioningCallbacks.generateConfirmationInputs(this.node.getProvisionerPublicKeyXY(), this.node.getProvisioneePublicKeyXY());
        Log.v((String)this.TAG, (String)("Confirmation inputs: " + MeshParserUtils.bytesToHex(confirmationInputs, false)));
        byte[] confirmationSalt = SecureUtils.calculateSalt(confirmationInputs);
        Log.v((String)this.TAG, (String)("Confirmation salt: " + MeshParserUtils.bytesToHex(confirmationSalt, false)));
        byte[] ecdhSecret = this.node.getSharedECDHSecret();
        byte[] confirmationKey = SecureUtils.calculateK1(ecdhSecret, confirmationSalt, SecureUtils.PRCK);
        Log.v((String)this.TAG, (String)("Confirmation key: " + MeshParserUtils.bytesToHex(confirmationKey, false)));
        byte[] authenticationValue = this.node.getAuthenticationValue();
        Log.v((String)this.TAG, (String)("Authentication value: " + MeshParserUtils.bytesToHex(authenticationValue, false)));
        ByteBuffer buffer = ByteBuffer.allocate(provisioneeRandom.length + authenticationValue.length);
        buffer.put(provisioneeRandom);
        buffer.put(authenticationValue);
        byte[] confirmationData = buffer.array();
        byte[] confirmationValue = SecureUtils.calculateCMAC(confirmationData, confirmationKey);
        return Arrays.equals(confirmationValue, this.node.getProvisioneeConfirmation());
    }

    private void parseProvisioneeRandom(byte[] provisioneeRandomPDU) {
        ByteBuffer buffer = ByteBuffer.allocate(provisioneeRandomPDU.length - 2);
        buffer.put(provisioneeRandomPDU, 2, buffer.limit());
        this.node.setProvisioneeRandom(buffer.array());
    }
}

