/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class Humidity
extends DevicePropertyCharacteristic<Float> {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Humidity(@NonNull byte[] data, int offset) {
        super(data, offset);
        this.value = Float.valueOf((float)MeshParserUtils.unsignedBytesToInt(data[offset], data[offset + 1]) / 100.0f);
        if (((Float)this.value).floatValue() == 65535.0f || ((Float)this.value).floatValue() < 0.0f || ((Float)this.value).floatValue() > 100.0f) {
            this.value = null;
        }
    }

    public Humidity(float humidity) {
        this.value = Float.valueOf(humidity);
    }

    @NonNull
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public byte[] getBytes() {
        return ByteBuffer.allocate(this.getLength()).order(ByteOrder.LITTLE_ENDIAN).putShort(((Float)this.value).shortValue()).array();
    }
}

