/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.room.Ignore;
import no.nordicsemi.android.mesh.AddressRange;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public class AllocatedGroupRange
extends AddressRange {
    public static final Parcelable.Creator<AllocatedGroupRange> CREATOR = new Parcelable.Creator<AllocatedGroupRange>(){

        public AllocatedGroupRange createFromParcel(Parcel in) {
            return new AllocatedGroupRange(in);
        }

        public AllocatedGroupRange[] newArray(int size) {
            return new AllocatedGroupRange[size];
        }
    };

    @Override
    public final int getLowerBound() {
        return 49152;
    }

    @Override
    public final int getUpperBound() {
        return 65279;
    }

    public AllocatedGroupRange(int lowAddress, int highAddress) {
        this.lowerBound = 49152;
        this.upperBound = 65279;
        if (!MeshAddress.isValidGroupAddress(lowAddress)) {
            throw new IllegalArgumentException("Low address must range from 0xC000 to 0xFEFF");
        }
        if (!MeshAddress.isValidGroupAddress(highAddress)) {
            throw new IllegalArgumentException("High address must range from 0xC000 to 0xFEFF");
        }
        this.lowAddress = lowAddress;
        this.highAddress = highAddress;
    }

    @Ignore
    AllocatedGroupRange() {
    }

    protected AllocatedGroupRange(Parcel in) {
        this.lowerBound = in.readInt();
        this.upperBound = in.readInt();
        this.highAddress = in.readInt();
        this.lowAddress = in.readInt();
    }

    @Override
    public int getLowAddress() {
        return this.lowAddress;
    }

    public void setLowAddress(int lowAddress) {
        this.lowAddress = lowAddress;
    }

    @Override
    public int getHighAddress() {
        return this.highAddress;
    }

    public void setHighAddress(int highAddress) {
        this.highAddress = highAddress;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.lowerBound);
        dest.writeInt(this.upperBound);
        dest.writeInt(this.highAddress);
        dest.writeInt(this.lowAddress);
    }
}

