/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.util.Log;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.utils.MeshAddress;

final class AllocatedUnicastRangeDeserializer
implements JsonSerializer<List<AllocatedUnicastRange>>,
JsonDeserializer<List<AllocatedUnicastRange>> {
    private static final String TAG = AllocatedUnicastRangeDeserializer.class.getSimpleName();

    AllocatedUnicastRangeDeserializer() {
    }

    public List<AllocatedUnicastRange> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<AllocatedUnicastRange> unicastRanges = new ArrayList<AllocatedUnicastRange>();
        try {
            JsonArray jsonObject = json.getAsJsonArray();
            for (int i = 0; i < jsonObject.size(); ++i) {
                JsonObject unicastRangeJson = jsonObject.get(i).getAsJsonObject();
                int lowAddress = Integer.parseInt(unicastRangeJson.get("lowAddress").getAsString(), 16);
                int highAddress = Integer.parseInt(unicastRangeJson.get("highAddress").getAsString(), 16);
                unicastRanges.add(new AllocatedUnicastRange(lowAddress, highAddress));
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Error while de-serializing allocated unicast range: " + ex.getMessage()));
        }
        return unicastRanges;
    }

    public JsonElement serialize(List<AllocatedUnicastRange> ranges, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        for (AllocatedUnicastRange range : ranges) {
            JsonObject rangeJson = new JsonObject();
            rangeJson.addProperty("lowAddress", MeshAddress.formatAddress(range.getLowAddress(), false));
            rangeJson.addProperty("highAddress", MeshAddress.formatAddress(range.getHighAddress(), false));
            jsonArray.add((JsonElement)rangeJson);
        }
        return jsonArray;
    }
}

