/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.Calendar;

public class IvIndex
implements Parcelable {
    private final int ivIndex;
    private final boolean isIvUpdateActive;
    private boolean ivRecoveryFlag = false;
    private Calendar transitionDate;
    public static final Parcelable.Creator<IvIndex> CREATOR = new Parcelable.Creator<IvIndex>(){

        public IvIndex createFromParcel(Parcel in) {
            return new IvIndex(in);
        }

        public IvIndex[] newArray(int size) {
            return new IvIndex[size];
        }
    };

    public IvIndex(int ivIndex, boolean isIvUpdateActive, Calendar transitionDate) {
        this.ivIndex = ivIndex;
        this.isIvUpdateActive = isIvUpdateActive;
        this.transitionDate = transitionDate;
    }

    protected IvIndex(Parcel in) {
        this.ivIndex = in.readInt();
        this.isIvUpdateActive = in.readByte() != 0;
        this.ivRecoveryFlag = in.readByte() != 0;
    }

    @NonNull
    public String toString() {
        return "IV Index: " + this.ivIndex + ", IV Update Active: " + this.isIvUpdateActive;
    }

    public int getIvIndex() {
        return this.ivIndex;
    }

    public boolean isIvUpdateActive() {
        return this.isIvUpdateActive;
    }

    public int getTransmitIvIndex() {
        return this.isIvUpdateActive && this.ivIndex != 0 ? this.ivIndex - 1 : this.ivIndex;
    }

    public boolean getIvRecoveryFlag() {
        return this.ivRecoveryFlag;
    }

    public void setIvRecoveryFlag(boolean ivRecoveryFlag) {
        this.ivRecoveryFlag = ivRecoveryFlag;
    }

    public Calendar getTransitionDate() {
        return this.transitionDate;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.ivIndex);
        dest.writeByte((byte)(this.isIvUpdateActive ? 1 : 0));
        dest.writeByte((byte)(this.ivRecoveryFlag ? 1 : 0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IvIndex ivIndex1 = (IvIndex)o;
        return this.ivIndex == ivIndex1.ivIndex && this.isIvUpdateActive == ivIndex1.isIvUpdateActive && this.ivRecoveryFlag == ivIndex1.ivRecoveryFlag && this.transitionDate.getTimeInMillis() == ivIndex1.transitionDate.getTimeInMillis();
    }
}

