/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.Group;
import no.nordicsemi.android.mesh.IvIndex;
import no.nordicsemi.android.mesh.LoadNetworkCallbacks;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.NodeKey;
import no.nordicsemi.android.mesh.Provisioner;
import no.nordicsemi.android.mesh.Scene;
import no.nordicsemi.android.mesh.data.ApplicationKeyDao;
import no.nordicsemi.android.mesh.data.ApplicationKeysDao;
import no.nordicsemi.android.mesh.data.GroupDao;
import no.nordicsemi.android.mesh.data.GroupsDao;
import no.nordicsemi.android.mesh.data.MeshNetworkDao;
import no.nordicsemi.android.mesh.data.NetworkKeyDao;
import no.nordicsemi.android.mesh.data.NetworkKeysDao;
import no.nordicsemi.android.mesh.data.ProvisionedMeshNodeDao;
import no.nordicsemi.android.mesh.data.ProvisionedMeshNodesDao;
import no.nordicsemi.android.mesh.data.ProvisionerDao;
import no.nordicsemi.android.mesh.data.ProvisionersDao;
import no.nordicsemi.android.mesh.data.SceneDao;
import no.nordicsemi.android.mesh.data.ScenesDao;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

@SuppressLint(value={"Range"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@Database(entities={MeshNetwork.class, NetworkKey.class, ApplicationKey.class, Provisioner.class, ProvisionedMeshNode.class, Group.class, Scene.class}, version=12)
abstract class MeshNetworkDb
extends RoomDatabase {
    private static final String TAG = MeshNetworkDb.class.getSimpleName();
    private static volatile MeshNetworkDb INSTANCE;
    private static final int NUMBER_OF_THREADS = 4;
    private static final ExecutorService databaseWriteExecutor;
    private static final RoomDatabase.Callback sRoomDatabaseCallback;
    private static final Migration MIGRATION_1_2;
    private static final Migration MIGRATION_2_3;
    private static final Migration MIGRATION_3_4;
    private static final Migration MIGRATION_4_5;
    private static final Migration MIGRATION_5_6;
    private static final Migration MIGRATION_6_7;
    private static final Migration MIGRATION_7_8;
    private static final Migration MIGRATION_8_9;
    private static final Migration MIGRATION_9_10;
    private static final Migration MIGRATION_10_11;
    private static final Migration MIGRATION_11_12;

    MeshNetworkDb() {
    }

    abstract MeshNetworkDao meshNetworkDao();

    abstract NetworkKeyDao networkKeyDao();

    abstract NetworkKeysDao networkKeysDao();

    abstract ApplicationKeyDao applicationKeyDao();

    abstract ApplicationKeysDao applicationKeysDao();

    abstract ProvisionerDao provisionerDao();

    abstract ProvisionersDao provisionersDao();

    abstract ProvisionedMeshNodeDao provisionedMeshNodeDao();

    abstract ProvisionedMeshNodesDao provisionedMeshNodesDao();

    abstract GroupsDao groupsDao();

    abstract GroupDao groupDao();

    abstract ScenesDao scenesDao();

    abstract SceneDao sceneDao();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static MeshNetworkDb getDatabase(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<MeshNetworkDb> clazz = MeshNetworkDb.class;
        synchronized (MeshNetworkDb.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = (MeshNetworkDb)Room.databaseBuilder((Context)context.getApplicationContext(), MeshNetworkDb.class, (String)"mesh_network_database.db").addCallback(sRoomDatabaseCallback).addMigrations(new Migration[]{MIGRATION_1_2}).addMigrations(new Migration[]{MIGRATION_2_3}).addMigrations(new Migration[]{MIGRATION_3_4}).addMigrations(new Migration[]{MIGRATION_4_5}).addMigrations(new Migration[]{MIGRATION_5_6}).addMigrations(new Migration[]{MIGRATION_6_7}).addMigrations(new Migration[]{MIGRATION_7_8}).addMigrations(new Migration[]{MIGRATION_8_9}).addMigrations(new Migration[]{MIGRATION_9_10}).addMigrations(new Migration[]{MIGRATION_10_11}).addMigrations(new Migration[]{MIGRATION_11_12}).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    void insertNetwork(@NonNull MeshNetworkDao meshNetworkDao, @NonNull NetworkKeysDao netKeysDao, @NonNull ApplicationKeysDao appKeysDao, @NonNull ProvisionersDao provisionersDao, @NonNull ProvisionedMeshNodesDao nodesDao, @NonNull GroupsDao groupsDao, @NonNull ScenesDao scenesDao, @NonNull MeshNetwork meshNetwork) {
        databaseWriteExecutor.execute(() -> {
            meshNetworkDao.insert(meshNetwork);
            netKeysDao.insert(new ArrayList<NetworkKey>(meshNetwork.netKeys));
            appKeysDao.insert(new ArrayList<ApplicationKey>(meshNetwork.appKeys));
            provisionersDao.insert(new ArrayList<Provisioner>(meshNetwork.provisioners));
            if (!meshNetwork.nodes.isEmpty()) {
                nodesDao.insert(new ArrayList<ProvisionedMeshNode>(meshNetwork.nodes));
            }
            if (meshNetwork.groups != null) {
                groupsDao.insert(new ArrayList<Group>(meshNetwork.groups));
            }
            if (meshNetwork.scenes != null) {
                scenesDao.insert(new ArrayList<Scene>(meshNetwork.scenes));
            }
        });
    }

    void loadNetwork(@NonNull MeshNetworkDao meshNetworkDao, @NonNull NetworkKeysDao netKeysDao, @NonNull ApplicationKeysDao appKeysDao, @NonNull ProvisionersDao provisionersDao, @NonNull ProvisionedMeshNodesDao nodesDao, @NonNull GroupsDao groupsDao, @NonNull ScenesDao scenesDao, @NonNull LoadNetworkCallbacks listener) {
        databaseWriteExecutor.execute(() -> {
            MeshNetwork meshNetwork = meshNetworkDao.getMeshNetwork(true);
            if (meshNetwork != null) {
                meshNetwork.netKeys = netKeysDao.loadNetworkKeys(meshNetwork.getMeshUUID());
                meshNetwork.appKeys = appKeysDao.loadApplicationKeys(meshNetwork.getMeshUUID());
                meshNetwork.nodes = nodesDao.getNodes(meshNetwork.getMeshUUID());
                meshNetwork.provisioners = provisionersDao.getProvisioners(meshNetwork.getMeshUUID());
                meshNetwork.groups = groupsDao.loadGroups(meshNetwork.getMeshUUID());
                meshNetwork.scenes = scenesDao.loadScenes(meshNetwork.getMeshUUID());
            }
            listener.onNetworkLoadedFromDb(meshNetwork);
        });
    }

    MeshNetwork getMeshNetwork(@NonNull MeshNetworkDao meshNetworkDao, @NonNull String meshUuid) throws ExecutionException, InterruptedException {
        return databaseWriteExecutor.submit(() -> meshNetworkDao.getMeshNetwork(meshUuid)).get();
    }

    List<MeshNetwork> getMeshNetworks(@NonNull MeshNetworkDao meshNetworkDao) throws ExecutionException, InterruptedException {
        return databaseWriteExecutor.submit(meshNetworkDao::getMeshNetworks).get();
    }

    void update(@NonNull MeshNetworkDao dao, @NonNull MeshNetwork network) {
        databaseWriteExecutor.execute(() -> dao.update(network.meshUUID, network.meshName, network.timestamp, network.partial, MeshTypeConverters.ivIndexToJson(network.ivIndex), network.lastSelected, MeshTypeConverters.networkExclusionsToJson(new HashMap<Integer, List<Integer>>(network.getNetworkExclusions()))));
    }

    void update(@NonNull MeshNetworkDao dao, @NonNull MeshNetwork meshNetwork, boolean lastSelected) throws ExecutionException, InterruptedException {
        databaseWriteExecutor.submit(() -> dao.update(meshNetwork.meshUUID, lastSelected)).get();
    }

    void update(@NonNull MeshNetworkDao dao, @NonNull List<MeshNetwork> meshNetworks) {
        databaseWriteExecutor.execute(() -> dao.update(meshNetworks));
    }

    void update(@NonNull MeshNetwork network, @NonNull MeshNetworkDao networkDao, @NonNull NetworkKeysDao netKeyDao, @NonNull ApplicationKeysDao appKeyDao, @NonNull ProvisionersDao provisionersDao, @NonNull ProvisionedMeshNodesDao nodesDao, @NonNull GroupsDao groupsDao, @NonNull ScenesDao sceneDao) {
        databaseWriteExecutor.execute(() -> {
            networkDao.update(network.meshUUID, network.meshName, network.timestamp, network.partial, MeshTypeConverters.ivIndexToJson(network.ivIndex), network.lastSelected, MeshTypeConverters.networkExclusionsToJson(new HashMap<Integer, List<Integer>>(network.getNetworkExclusions())));
            netKeyDao.update(new ArrayList<NetworkKey>(network.netKeys));
            appKeyDao.update(new ArrayList<ApplicationKey>(network.appKeys));
            provisionersDao.update(new ArrayList<Provisioner>(network.provisioners));
            nodesDao.update(new ArrayList<ProvisionedMeshNode>(network.nodes));
            groupsDao.update(new ArrayList<Group>(network.groups));
            sceneDao.update(new ArrayList<Scene>(network.scenes));
        });
    }

    void delete(@NonNull MeshNetworkDao dao, @NonNull MeshNetwork meshNetwork) {
        databaseWriteExecutor.execute(() -> dao.delete(meshNetwork));
    }

    void insert(@NonNull NetworkKeyDao dao, @NonNull NetworkKey networkKey) {
        databaseWriteExecutor.execute(() -> dao.insert(networkKey));
    }

    void update(@NonNull NetworkKeyDao dao, @NonNull NetworkKey networkKey) {
        databaseWriteExecutor.execute(() -> dao.update(networkKey));
    }

    void delete(@NonNull NetworkKeyDao dao, @NonNull NetworkKey networkKey) {
        databaseWriteExecutor.execute(() -> dao.delete(networkKey.getKeyIndex()));
    }

    void insert(@NonNull ApplicationKeyDao dao, @NonNull ApplicationKey applicationKey) {
        databaseWriteExecutor.execute(() -> dao.insert(applicationKey));
    }

    void update(@NonNull ApplicationKeyDao dao, @NonNull ApplicationKey applicationKey) {
        databaseWriteExecutor.execute(() -> dao.update(applicationKey));
    }

    void delete(@NonNull ApplicationKeyDao dao, @NonNull ApplicationKey applicationKey) {
        databaseWriteExecutor.execute(() -> dao.delete(applicationKey));
    }

    void insert(@NonNull ProvisionerDao dao, @NonNull Provisioner provisioner) {
        databaseWriteExecutor.execute(() -> dao.insert(provisioner));
    }

    void update(@NonNull ProvisionerDao dao, @NonNull Provisioner provisioner) {
        databaseWriteExecutor.execute(() -> dao.update(provisioner));
    }

    void update(@NonNull ProvisionerDao dao, @NonNull List<Provisioner> provisioners) {
        databaseWriteExecutor.execute(() -> dao.update(provisioners));
    }

    void delete(@NonNull ProvisionerDao dao, @NonNull Provisioner provisioner) {
        databaseWriteExecutor.execute(() -> dao.delete(provisioner));
    }

    List<ProvisionedMeshNode> getNodes(@NonNull ProvisionedMeshNodesDao dao, @NonNull String meshUuid) throws ExecutionException, InterruptedException {
        return databaseWriteExecutor.submit(() -> dao.getNodes(meshUuid)).get();
    }

    void insert(@NonNull ProvisionedMeshNodeDao dao, @NonNull ProvisionedMeshNode node) {
        databaseWriteExecutor.execute(() -> dao.insert(node));
    }

    void update(@NonNull ProvisionedMeshNodeDao dao, @NonNull ProvisionedMeshNode node) {
        databaseWriteExecutor.execute(() -> dao.update(node));
    }

    void update(@NonNull ProvisionedMeshNodesDao dao, @NonNull List<ProvisionedMeshNode> nodes) {
        databaseWriteExecutor.execute(() -> dao.update(nodes));
    }

    void deleteNode(@NonNull ProvisionedMeshNodeDao dao, @NonNull ProvisionedMeshNode node) {
        databaseWriteExecutor.execute(() -> dao.delete(node));
    }

    void insert(@NonNull GroupDao dao, @NonNull Group group) {
        databaseWriteExecutor.execute(() -> dao.insert(group));
    }

    void update(@NonNull GroupDao dao, @NonNull Group group) {
        databaseWriteExecutor.execute(() -> dao.update(group));
    }

    void delete(@NonNull GroupDao dao, @NonNull Group group) {
        databaseWriteExecutor.execute(() -> dao.delete(group.getAddress()));
    }

    void insert(@NonNull SceneDao dao, @NonNull Scene scene) {
        databaseWriteExecutor.execute(() -> dao.insert(scene));
    }

    void update(@NonNull SceneDao dao, @NonNull Scene scene) {
        databaseWriteExecutor.execute(() -> dao.update(scene));
    }

    void delete(@NonNull SceneDao dao, @NonNull Scene scene) {
        databaseWriteExecutor.execute(() -> dao.delete(scene.getNumber()));
    }

    private static void migrateMeshNetwork(SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `mesh_network_temp` (`mesh_uuid` TEXT NOT NULL, `mesh_name` TEXT, `timestamp` INTEGER NOT NULL, `iv_index` INTEGER NOT NULL, `iv_update_state` INTEGER NOT NULL, `unicast_address` INTEGER NOT NULL DEFAULT 0x0001, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`mesh_uuid`))");
        database.execSQL("INSERT INTO mesh_network_temp (mesh_uuid, mesh_name, timestamp, iv_index, iv_update_state, last_selected) SELECT mesh_uuid, mesh_name, timestamp, iv_index, iv_update_state, last_selected FROM mesh_network");
        Cursor cursor = database.query("SELECT * FROM mesh_network");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String uuid = cursor.getString(cursor.getColumnIndex("mesh_uuid"));
                byte[] unicast = cursor.getBlob(cursor.getColumnIndex("unicast_address"));
                short address = MeshAddress.addressBytesToInt(unicast);
                ContentValues values = new ContentValues();
                values.put("unicast_address", Integer.valueOf(address));
                database.update("mesh_network_temp", 5, values, "mesh_uuid = ?", (Object[])new String[]{uuid});
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE mesh_network");
        database.execSQL("ALTER TABLE mesh_network_temp RENAME TO mesh_network");
    }

    private static void migrateNodes(SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `nodes_temp` (`timestamp` INTEGER NOT NULL, `mAddedNetworkKeys` TEXT, `name` TEXT, `ttl` INTEGER, `blacklisted` INTEGER NOT NULL, `secureNetworkBeacon` INTEGER, `mesh_uuid` TEXT, `uuid` TEXT NOT NULL, `security` INTEGER NOT NULL, `unicast_address` INTEGER NOT NULL DEFAULT 1, `configured` INTEGER NOT NULL, `device_key` BLOB, `seq_number` INTEGER NOT NULL, `cid` INTEGER, `pid` INTEGER, `vid` INTEGER, `crpl` INTEGER, `mElements` TEXT, `mAddedApplicationKeys` TEXT, `networkTransmitCount` INTEGER, `networkIntervalSteps` INTEGER, `relayTransmitCount` INTEGER, `relayIntervalSteps` INTEGER, `friend` INTEGER, `lowPower` INTEGER, `proxy` INTEGER, `relay` INTEGER, PRIMARY KEY(`uuid`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO nodes_temp (timestamp, mAddedNetworkKeys, name, blacklisted, secureNetworkBeacon, mesh_uuid, security, configured, device_key, seq_number, cid, pid, vid, crpl, mElements, mAddedApplicationKeys, networkTransmitCount, networkIntervalSteps, relayTransmitCount, relayIntervalSteps, friend, lowPower, proxy, relay, uuid, mesh_uuid) SELECT timestamp, mAddedNetworkKeys, name, blacklisted, secureNetworkBeacon, mesh_uuid, security, configured, device_key, seq_number, cid, pid, vid, crpl, mElements, mAddedApplicationKeys, networkTransmitCount, networkIntervalSteps, relayTransmitCount, relayIntervalSteps,friend, lowPower, proxy, relay, uuid, mesh_uuid FROM nodes");
        Cursor cursor = database.query("SELECT * FROM nodes");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String uuid = cursor.getString(cursor.getColumnIndex("uuid"));
                byte[] unicast = cursor.getBlob(cursor.getColumnIndex("unicast_address"));
                short address = MeshAddress.addressBytesToInt(unicast);
                ContentValues values = new ContentValues();
                values.put("unicast_address", Integer.valueOf(address));
                database.update("nodes_temp", 5, values, "uuid = ?", (Object[])new String[]{uuid});
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE nodes");
        database.execSQL("ALTER TABLE nodes_temp RENAME TO nodes");
        database.execSQL("CREATE INDEX index_nodes_mesh_uuid ON `nodes` (mesh_uuid)");
    }

    private static void migrateProvisioner(SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `provisioner_temp` (`mesh_uuid` TEXT NOT NULL, `provisioner_uuid` TEXT NOT NULL, `name` TEXT, `allocatedGroupRanges` TEXT, `allocatedUnicastRanges` TEXT, `allocatedSceneRanges` TEXT, `sequence_number` INTEGER NOT NULL, `provisioner_address` INTEGER NOT NULL DEFAULT 32767,`global_ttl` INTEGER NOT NULL, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`provisioner_uuid`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO provisioner_temp (mesh_uuid, provisioner_uuid, name, allocatedGroupRanges, allocatedUnicastRanges, allocatedSceneRanges, sequence_number, global_ttl, last_selected) SELECT mesh_uuid, provisioner_uuid, name, allocatedGroupRanges, allocatedUnicastRanges, allocatedSceneRanges, sequence_number, global_ttl, last_selected FROM provisioner");
        Cursor cursor = database.query("SELECT * FROM provisioner");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String uuid = cursor.getString(cursor.getColumnIndex("provisioner_uuid"));
                byte[] unicast = cursor.getBlob(cursor.getColumnIndex("provisioner_address"));
                short address = MeshAddress.addressBytesToInt(unicast);
                ContentValues values = new ContentValues();
                values.put("provisioner_address", Integer.valueOf(address));
                database.update("provisioner_temp", 5, values, "provisioner_uuid = ?", (Object[])new String[]{uuid});
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE provisioner");
        database.execSQL("ALTER TABLE provisioner_temp RENAME TO provisioner");
        database.execSQL("CREATE INDEX index_provisioner_mesh_uuid ON `provisioner` (mesh_uuid)");
    }

    private static void migrateGroup(SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `groups_temp` (`id` INTEGER PRIMARY KEY NOT NULL,`mesh_uuid` TEXT, `name` TEXT, `group_address` INTEGER NOT NULL DEFAULT 49152, `parent_address` INTEGER NOT NULL DEFAULT 49152, FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        Cursor cursor = database.query("SELECT * FROM groups");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String uuid = cursor.getString(cursor.getColumnIndex("mesh_uuid"));
                String name = cursor.getString(cursor.getColumnIndex("name"));
                byte[] grpAddress = cursor.getBlob(cursor.getColumnIndex("group_address"));
                byte[] pAddress = cursor.getBlob(cursor.getColumnIndex("parent_address"));
                int groupAddress = MeshParserUtils.unsignedBytesToInt(grpAddress[1], grpAddress[0]);
                ContentValues values = new ContentValues();
                values.put("mesh_uuid", uuid);
                values.put("name", name);
                values.put("group_address", Integer.valueOf(groupAddress));
                if (pAddress != null) {
                    int parentAddress = MeshParserUtils.unsignedBytesToInt(pAddress[1], pAddress[0]);
                    values.put("parent_address", Integer.valueOf(parentAddress));
                }
                database.insert("groups_temp", 5, values);
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE groups");
        database.execSQL("ALTER TABLE groups_temp RENAME TO groups");
        database.execSQL("CREATE INDEX index_groups_mesh_uuid ON `groups` (mesh_uuid)");
    }

    private static void migrateGroup2_3(SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `groups_temp` (`id` INTEGER PRIMARY KEY NOT NULL,`mesh_uuid` TEXT, `name` TEXT, `group_address` INTEGER NOT NULL DEFAULT 49152, `parent_address` INTEGER NOT NULL DEFAULT 0, `group_address_label` TEXT, `parent_address_label` TEXT, FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO groups_temp (id, mesh_uuid, name, group_address, parent_address) SELECT id, mesh_uuid, name, group_address, parent_address FROM groups");
        database.execSQL("DROP TABLE groups");
        database.execSQL("ALTER TABLE groups_temp RENAME TO groups");
        database.execSQL("CREATE INDEX index_groups_mesh_uuid ON `groups` (mesh_uuid)");
    }

    private static void migrateNodes3_4(SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `nodes_temp` (`timestamp` INTEGER NOT NULL, `name` TEXT, `ttl` INTEGER, `blacklisted` INTEGER NOT NULL, `secureNetworkBeacon` INTEGER, `mesh_uuid` TEXT, `uuid` TEXT NOT NULL, `security` INTEGER NOT NULL, `unicast_address` INTEGER NOT NULL DEFAULT 1, `configured` INTEGER NOT NULL, `device_key` BLOB, `seq_number` INTEGER NOT NULL, `cid` INTEGER, `pid` INTEGER, `vid` INTEGER, `crpl` INTEGER, `mElements` TEXT, `netKeys` TEXT, `appKeys` TEXT, `networkTransmitCount` INTEGER, `networkIntervalSteps` INTEGER, `relayTransmitCount` INTEGER, `relayIntervalSteps` INTEGER, `friend` INTEGER, `lowPower` INTEGER, `proxy` INTEGER, `relay` INTEGER, PRIMARY KEY(`uuid`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO nodes_temp (timestamp, name, blacklisted, secureNetworkBeacon, mesh_uuid, security, unicast_address, configured, device_key, seq_number, cid, pid, vid, crpl, mElements, networkTransmitCount, networkIntervalSteps, relayTransmitCount, relayIntervalSteps, friend, lowPower, proxy, relay, uuid, mesh_uuid) SELECT timestamp, name, blacklisted, secureNetworkBeacon, mesh_uuid, security, unicast_address, configured, device_key, seq_number, cid, pid, vid, crpl, mElements, networkTransmitCount, networkIntervalSteps, relayTransmitCount, relayIntervalSteps,friend, lowPower, proxy, relay, uuid, mesh_uuid FROM nodes");
        Cursor cursor = database.query("SELECT * FROM nodes");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                ContentValues values = new ContentValues();
                String uuid = cursor.getString(cursor.getColumnIndex("uuid"));
                String netKeysJson = cursor.getString(cursor.getColumnIndex("mAddedNetworkKeys"));
                List<NetworkKey> netKeys = MeshTypeConverters.fromJsonToAddedNetKeys(netKeysJson);
                ArrayList<Integer> keyIndexes = new ArrayList<Integer>();
                for (NetworkKey networkKey : netKeys) {
                    if (networkKey == null) continue;
                    keyIndexes.add(networkKey.getKeyIndex());
                }
                values.put("netKeys", MeshTypeConverters.integerToJson(keyIndexes));
                keyIndexes.clear();
                String appKeysJson = cursor.getString(cursor.getColumnIndex("mAddedApplicationKeys"));
                Map<Integer, ApplicationKey> appKeyMap = MeshTypeConverters.fromJsonToAddedAppKeys(appKeysJson);
                for (Map.Entry<Integer, ApplicationKey> applicationKeyEntry : appKeyMap.entrySet()) {
                    ApplicationKey key = applicationKeyEntry.getValue();
                    if (key == null) continue;
                    keyIndexes.add(key.getKeyIndex());
                }
                values.put("appKeys", MeshTypeConverters.integerToJson(keyIndexes));
                database.update("nodes_temp", 5, values, "uuid = ?", (Object[])new String[]{uuid});
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE nodes");
        database.execSQL("ALTER TABLE nodes_temp RENAME TO nodes");
        database.execSQL("CREATE INDEX index_nodes_mesh_uuid ON `nodes` (mesh_uuid)");
    }

    private static void migrateProvisioner4_5(SupportSQLiteDatabase database) {
        ArrayList<AllocatedUnicastRange> unicastRange = new ArrayList<AllocatedUnicastRange>();
        ArrayList<AllocatedGroupRange> groupRange = new ArrayList<AllocatedGroupRange>();
        ArrayList<AllocatedSceneRange> sceneRange = new ArrayList<AllocatedSceneRange>();
        unicastRange.add(new AllocatedUnicastRange(1, 6554));
        groupRange.add(new AllocatedGroupRange(49152, 52378));
        sceneRange.add(new AllocatedSceneRange(1, 13107));
        database.execSQL("CREATE TABLE `provisioner_temp` (`mesh_uuid` TEXT NOT NULL, `provisioner_uuid` TEXT NOT NULL, `name` TEXT, `allocated_unicast_ranges` TEXT NOT NULL, `allocated_group_ranges` TEXT NOT NULL, `allocated_scene_ranges` TEXT NOT NULL, `sequence_number` INTEGER NOT NULL, `provisioner_address` INTEGER,`global_ttl` INTEGER NOT NULL, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`provisioner_uuid`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO provisioner_temp (mesh_uuid, provisioner_uuid, name, allocated_unicast_ranges, allocated_group_ranges, allocated_scene_ranges, sequence_number, global_ttl, last_selected) SELECT mesh_uuid, provisioner_uuid, name, allocatedUnicastRanges, allocatedGroupRanges, allocatedSceneRanges,sequence_number, global_ttl, last_selected FROM provisioner");
        ArrayList<Provisioner> provisioners = new ArrayList<Provisioner>();
        Cursor cursor = database.query("SELECT * FROM provisioner");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String meshUuid = cursor.getString(cursor.getColumnIndex("mesh_uuid"));
                String uuid = cursor.getString(cursor.getColumnIndex("provisioner_uuid"));
                String name = cursor.getString(cursor.getColumnIndex("name"));
                String unicastRanges = cursor.getString(cursor.getColumnIndex("allocatedUnicastRanges"));
                String groupRanges = cursor.getString(cursor.getColumnIndex("allocatedGroupRanges"));
                String sceneRanges = cursor.getString(cursor.getColumnIndex("allocatedSceneRanges"));
                int sequenceNumber = cursor.getInt(cursor.getColumnIndex("sequence_number"));
                int globalTtl = cursor.getInt(cursor.getColumnIndex("global_ttl"));
                boolean lastSelected = cursor.getInt(cursor.getColumnIndex("last_selected")) == 1;
                int unicast = cursor.getInt(cursor.getColumnIndex("provisioner_address"));
                ContentValues values = new ContentValues();
                values.put("mesh_uuid", meshUuid);
                values.put("provisioner_uuid", uuid);
                values.put("name", name);
                values.put("sequence_number", Integer.valueOf(sequenceNumber));
                values.put("global_ttl", Integer.valueOf(globalTtl));
                values.put("last_selected", Boolean.valueOf(lastSelected));
                if (unicast == 0) {
                    Integer t = null;
                    values.put("provisioner_address", t);
                } else {
                    values.put("provisioner_address", Integer.valueOf(unicast));
                }
                values.put("allocated_unicast_ranges", unicastRanges.equalsIgnoreCase("null") ? MeshTypeConverters.allocatedUnicastRangeToJson(unicastRange) : unicastRanges);
                values.put("allocated_group_ranges", groupRanges.equalsIgnoreCase("null") ? MeshTypeConverters.allocatedGroupRangeToJson(groupRange) : groupRanges);
                values.put("allocated_scene_ranges", sceneRanges.equalsIgnoreCase("null") ? MeshTypeConverters.allocatedSceneRangeToJson(sceneRange) : sceneRanges);
                database.update("provisioner_temp", 5, values, "provisioner_uuid = ?", (Object[])new String[]{uuid});
                Provisioner provisioner = new Provisioner(uuid, unicastRanges.equalsIgnoreCase("null") ? unicastRange : MeshTypeConverters.fromJsonToAllocatedUnicastRanges(unicastRanges), groupRanges.equalsIgnoreCase("null") ? groupRange : MeshTypeConverters.fromJsonToAllocatedGroupRanges(groupRanges), sceneRanges.equalsIgnoreCase("null") ? sceneRange : MeshTypeConverters.fromJsonToAllocatedSceneRanges(sceneRanges), meshUuid);
                provisioner.setProvisionerName(name);
                provisioner.setProvisionerAddress(unicast);
                provisioner.setLastSelected(lastSelected);
                provisioner.setGlobalTtl(globalTtl);
                provisioners.add(provisioner);
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE provisioner");
        database.execSQL("ALTER TABLE provisioner_temp RENAME TO provisioner");
        database.execSQL("CREATE INDEX index_provisioner_mesh_uuid ON `provisioner` (mesh_uuid)");
        MeshNetworkDb.addProvisionerNodes(database, provisioners);
    }

    private static List<NetworkKey> getNetKeys(@NonNull SupportSQLiteDatabase database) {
        ArrayList<NetworkKey> keys = new ArrayList<NetworkKey>();
        Cursor cursor = database.query("SELECT * FROM network_key");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                int index = cursor.getInt(cursor.getColumnIndex("index"));
                byte[] key = cursor.getBlob(cursor.getColumnIndex("key"));
                NetworkKey networkKey = new NetworkKey(index, key);
                keys.add(networkKey);
            } while (cursor.moveToNext());
        }
        return keys;
    }

    private static List<ApplicationKey> getAppKeys(@NonNull SupportSQLiteDatabase database) {
        ArrayList<ApplicationKey> keys = new ArrayList<ApplicationKey>();
        Cursor cursor = database.query("SELECT * FROM application_key");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                int index = cursor.getInt(cursor.getColumnIndex("index"));
                byte[] key = cursor.getBlob(cursor.getColumnIndex("key"));
                ApplicationKey applicationKey = new ApplicationKey(index, key);
                keys.add(applicationKey);
            } while (cursor.moveToNext());
        }
        return keys;
    }

    private static void addProvisionerNodes(@NonNull SupportSQLiteDatabase database, @NonNull List<Provisioner> provisioners) {
        if (!provisioners.isEmpty()) {
            List<NetworkKey> netKeys = MeshNetworkDb.getNetKeys(database);
            List<ApplicationKey> appKeys = MeshNetworkDb.getAppKeys(database);
            for (Provisioner provisioner : provisioners) {
                ProvisionedMeshNode node = new ProvisionedMeshNode(provisioner, netKeys, appKeys);
                ContentValues values = new ContentValues();
                values.put("timestamp", Long.valueOf(node.getTimeStamp()));
                values.put("name", node.getNodeName());
                values.put("mesh_uuid", node.getMeshUuid());
                values.put("uuid", node.getUuid());
                values.put("ttl", node.getTtl());
                values.put("blacklisted", Boolean.valueOf(node.isExcluded()));
                values.put("security", Integer.valueOf(node.getSecurity()));
                values.put("unicast_address", Integer.valueOf(node.getUnicastAddress()));
                values.put("configured", Boolean.valueOf(node.isConfigured()));
                values.put("device_key", node.getDeviceKey());
                values.put("seq_number", Integer.valueOf(node.getSequenceNumber()));
                values.put("mElements", MeshTypeConverters.elementsToJson(node.getElements()));
                ArrayList<Integer> networkKeys = new ArrayList<Integer>();
                for (NetworkKey networkKey : netKeys) {
                    networkKeys.add(networkKey.getKeyIndex());
                }
                ArrayList<Integer> applicationKeys = new ArrayList<Integer>();
                for (ApplicationKey applicationKey : appKeys) {
                    applicationKeys.add(applicationKey.getKeyIndex());
                }
                if (!netKeys.isEmpty()) {
                    values.put("netKeys", MeshTypeConverters.integerToJson(networkKeys));
                }
                if (!appKeys.isEmpty()) {
                    values.put("appKeys", MeshTypeConverters.integerToJson(applicationKeys));
                }
                database.insert("nodes", 5, values);
            }
        }
    }

    private static void migrateMeshNetwork5_6(SupportSQLiteDatabase database) {
        HashMap<UUID, SparseIntArray> nodesMap = new HashMap<UUID, SparseIntArray>();
        Cursor cursor1 = database.query("SELECT mesh_uuid, unicast_address, seq_number FROM nodes");
        if (cursor1 != null && cursor1.moveToFirst()) {
            UUID meshUuid = UUID.fromString(cursor1.getString(cursor1.getColumnIndex("mesh_uuid")).toUpperCase(Locale.US));
            do {
                int unicast = cursor1.getInt(cursor1.getColumnIndex("unicast_address"));
                int seqNumber = cursor1.getInt(cursor1.getColumnIndex("seq_number"));
                SparseIntArray sparseIntArray = (SparseIntArray)nodesMap.get(meshUuid);
                if (sparseIntArray == null) {
                    sparseIntArray = new SparseIntArray();
                }
                sparseIntArray.put(unicast, seqNumber);
                nodesMap.put(meshUuid, sparseIntArray);
            } while (cursor1.moveToNext());
            cursor1.close();
        }
        database.execSQL("ALTER TABLE mesh_network RENAME TO mesh_network_temp");
        database.execSQL("CREATE TABLE `mesh_network` (`mesh_uuid` TEXT NOT NULL, `mesh_name` TEXT, `timestamp` INTEGER NOT NULL, `iv_index` INTEGER NOT NULL, `iv_update_state` INTEGER NOT NULL, `sequence_numbers` TEXT NOT NULL, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`mesh_uuid`))");
        Cursor cursor = database.query("SELECT * FROM mesh_network_temp");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String meshUuid = cursor.getString(cursor.getColumnIndex("mesh_uuid")).toUpperCase(Locale.US);
                String meshName = cursor.getString(cursor.getColumnIndex("mesh_name"));
                long timestamp = cursor.getLong(cursor.getColumnIndex("timestamp"));
                int ivIndex = cursor.getInt(cursor.getColumnIndex("iv_index"));
                int ivUpdateState = cursor.getInt(cursor.getColumnIndex("iv_update_state"));
                boolean lastSelected = cursor.getInt(cursor.getColumnIndex("last_selected")) == 1;
                SparseIntArray sequenceNumbersArray = (SparseIntArray)nodesMap.get(UUID.fromString(meshUuid));
                ContentValues values = new ContentValues();
                values.put("mesh_uuid", meshUuid);
                values.put("mesh_name", meshName);
                values.put("timestamp", Long.valueOf(timestamp));
                values.put("iv_index", Integer.valueOf(ivIndex));
                values.put("iv_update_state", Integer.valueOf(ivUpdateState));
                if (sequenceNumbersArray != null) {
                    values.put("sequence_numbers", MeshTypeConverters.sparseIntArrayToJson(sequenceNumbersArray));
                }
                values.put("last_selected", Boolean.valueOf(lastSelected));
                database.insert("mesh_network", 5, values);
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE mesh_network_temp");
    }

    private static void migrateKeyIndexes6_7(@NonNull SupportSQLiteDatabase database) {
        Cursor cursor = database.query("SELECT uuid, netKeys, appKeys FROM nodes");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                try {
                    ContentValues values = new ContentValues();
                    String uuid = cursor.getString(cursor.getColumnIndex("uuid"));
                    String netKeysJson = cursor.getString(cursor.getColumnIndex("netKeys"));
                    List<Integer> netKeys = MeshTypeConverters.fromJsonToIntegerList(netKeysJson);
                    ArrayList<NodeKey> netKeyIndexes = new ArrayList<NodeKey>();
                    for (Integer keyIndex : netKeys) {
                        if (keyIndex == null) continue;
                        netKeyIndexes.add(new NodeKey(keyIndex, false));
                    }
                    values.put("netKeys", MeshTypeConverters.nodeKeysToJson(netKeyIndexes));
                    ArrayList<NodeKey> appKeyIndexes = new ArrayList<NodeKey>();
                    String appKeysJson = cursor.getString(cursor.getColumnIndex("appKeys"));
                    List<Integer> appKeys = MeshTypeConverters.fromJsonToIntegerList(appKeysJson);
                    for (Integer keyIndex : appKeys) {
                        appKeyIndexes.add(new NodeKey(keyIndex, false));
                    }
                    values.put("appKeys", MeshTypeConverters.nodeKeysToJson(appKeyIndexes));
                    database.update("nodes", 5, values, "uuid = ?", (Object[])new String[]{uuid});
                }
                catch (Exception ex) {
                    Log.v((String)TAG, (String)"Something went wrong while migrating data");
                }
            } while (cursor.moveToNext());
            cursor.close();
        }
    }

    private static void migrateMeshNetwork7_8(@NonNull SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `mesh_network_temp` (`mesh_uuid` TEXT NOT NULL, `mesh_name` TEXT, `timestamp` INTEGER NOT NULL, `iv_index` TEXT NOT NULL, `sequence_numbers` TEXT NOT NULL, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`mesh_uuid`))");
        Cursor cursor = database.query("SELECT * FROM mesh_network");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String uuid = cursor.getString(cursor.getColumnIndex("mesh_uuid"));
                String meshName = cursor.getString(cursor.getColumnIndex("mesh_name"));
                long timestamp = cursor.getInt(cursor.getColumnIndex("timestamp"));
                int ivIndex = cursor.getInt(cursor.getColumnIndex("iv_index"));
                int ivUpdateState = cursor.getInt(cursor.getColumnIndex("iv_update_state"));
                String sequenceNumbers = cursor.getString(cursor.getColumnIndex("sequence_numbers"));
                int lastSelected = cursor.getInt(cursor.getColumnIndex("last_selected"));
                ContentValues values = new ContentValues();
                values.put("mesh_uuid", uuid);
                values.put("mesh_name", meshName);
                values.put("timestamp", Long.valueOf(timestamp));
                values.put("iv_index", MeshTypeConverters.ivIndexToJson(new IvIndex(ivIndex, ivUpdateState == 1, Calendar.getInstance())));
                values.put("sequence_numbers", sequenceNumbers);
                values.put("last_selected", Integer.valueOf(lastSelected));
                database.insert("mesh_network_temp", 5, values);
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE mesh_network");
        database.execSQL("ALTER TABLE mesh_network_temp RENAME TO mesh_network");
    }

    private static void migrateProvisioner8_9(@NonNull SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `provisioner_temp` (`provisioner_uuid` TEXT NOT NULL, `mesh_uuid` TEXT NOT NULL, `name` TEXT, `allocated_unicast_ranges` TEXT NOT NULL, `allocated_group_ranges` TEXT NOT NULL, `allocated_scene_ranges` TEXT NOT NULL, `provisioner_address` INTEGER,`global_ttl` INTEGER NOT NULL, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`provisioner_uuid`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO provisioner_temp (provisioner_uuid,  mesh_uuid, name,  allocated_unicast_ranges, allocated_group_ranges, allocated_scene_ranges, provisioner_address, global_ttl, last_selected) SELECT provisioner_uuid, mesh_uuid, name,allocated_unicast_ranges, allocated_group_ranges, allocated_scene_ranges,provisioner_address, global_ttl, last_selected FROM provisioner");
        database.execSQL("DROP TABLE provisioner");
        database.execSQL("CREATE INDEX index_provisioner_mesh_uuid ON `provisioner_temp` (mesh_uuid)");
        database.execSQL("ALTER TABLE provisioner_temp RENAME TO provisioner");
    }

    private static void migrateMeshNetwork9_10(@NonNull SupportSQLiteDatabase database) {
        database.execSQL("ALTER TABLE mesh_network ADD COLUMN partial INTEGER NOT NULL DEFAULT 0");
    }

    private static void migrateNodes10_11(@NonNull SupportSQLiteDatabase database) {
        MeshNetworkDb.addColumnNetworkExclusionList(database);
        MeshNetworkDb.migrateFromBlacklistedToExcluded(database);
    }

    private static void addColumnNetworkExclusionList(@NonNull SupportSQLiteDatabase database) {
        database.execSQL("ALTER TABLE mesh_network ADD COLUMN networkExclusions TEXT NOT NULL DEFAULT '{}'");
    }

    private static void migrateFromBlacklistedToExcluded(@NonNull SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `nodes_temp` (timestamp INTEGER NOT NULL, netKeys TEXT, name TEXT, ttl INTEGER DEFAULT 5, excluded INTEGER NOT NULL, secureNetworkBeacon INTEGER, mesh_uuid TEXT, uuid TEXT NOT NULL, security INTEGER NOT NULL, unicast_address INTEGER NOT NULL DEFAULT 1, configured INTEGER NOT NULL, device_key BLOB, seq_number INTEGER NOT NULL, cid INTEGER, pid INTEGER, vid INTEGER, crpl INTEGER, elements TEXT, appKeys TEXT, networkTransmitCount INTEGER, networkIntervalSteps INTEGER, relayTransmitCount INTEGER, relayIntervalSteps INTEGER, friend INTEGER, lowPower INTEGER, proxy INTEGER, relay INTEGER, PRIMARY KEY(uuid), FOREIGN KEY(mesh_uuid) REFERENCES mesh_network(mesh_uuid) ON UPDATE CASCADE ON DELETE CASCADE )");
        database.execSQL("INSERT INTO nodes_temp (timestamp, netKeys, name, excluded, secureNetworkBeacon, mesh_uuid, security, unicast_address, configured, device_key, seq_number, cid, pid, vid, crpl, elements, appKeys, networkTransmitCount, networkIntervalSteps, relayTransmitCount, relayIntervalSteps, friend, lowPower, proxy, relay, uuid, mesh_uuid) SELECT timestamp, netKeys, name, blacklisted, secureNetworkBeacon, mesh_uuid, security, unicast_address, configured, device_key, seq_number, cid, pid, vid, crpl, mElements, appKeys, networkTransmitCount, networkIntervalSteps, relayTransmitCount, relayIntervalSteps,friend, lowPower, proxy, relay, uuid, mesh_uuid FROM nodes");
        database.execSQL("DROP TABLE nodes");
        database.execSQL("ALTER TABLE nodes_temp RENAME TO nodes");
        database.execSQL("CREATE INDEX index_nodes_mesh_uuid ON `nodes` (mesh_uuid)");
    }

    private static void migrateMeshNetwork11_12(@NonNull SupportSQLiteDatabase database) {
        database.execSQL("CREATE TABLE `mesh_network_temp` (`mesh_uuid` TEXT NOT NULL,  `mesh_name` TEXT,  `timestamp` INTEGER NOT NULL DEFAULT 0,  `partial` INTEGER NOT NULL DEFAULT 0, `iv_index` TEXT NOT NULL,  `network_exclusions` TEXT NOT NULL DEFAULT '{}',  `last_selected` INTEGER NOT NULL, PRIMARY KEY(`mesh_uuid`))");
        Cursor cursor = database.query("select * from mesh_network");
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String uuid = cursor.getString(cursor.getColumnIndex("mesh_uuid"));
                String meshName = cursor.getString(cursor.getColumnIndex("mesh_name"));
                long timestamp = cursor.getLong(cursor.getColumnIndex("timestamp"));
                String ivIndex = cursor.getString(cursor.getColumnIndex("iv_index"));
                String networkExclusions = cursor.getString(cursor.getColumnIndex("networkExclusions"));
                int lastSelected = cursor.getInt(cursor.getColumnIndex("last_selected"));
                ContentValues values = new ContentValues();
                values.put("mesh_uuid", uuid);
                values.put("mesh_name", meshName);
                values.put("timestamp", Long.valueOf(timestamp));
                values.put("iv_index", ivIndex);
                values.put("network_exclusions", networkExclusions);
                values.put("last_selected", Integer.valueOf(lastSelected));
                database.insert("mesh_network_temp", 5, values);
            } while (cursor.moveToNext());
            cursor.close();
        }
        database.execSQL("DROP TABLE mesh_network");
        database.execSQL("ALTER TABLE mesh_network_temp RENAME TO mesh_network");
    }

    static {
        databaseWriteExecutor = Executors.newFixedThreadPool(4);
        sRoomDatabaseCallback = new RoomDatabase.Callback(){

            public void onOpen(@NonNull SupportSQLiteDatabase db) {
                super.onOpen(db);
            }
        };
        MIGRATION_1_2 = new Migration(1, 2){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateMeshNetwork(database);
                MeshNetworkDb.migrateNodes(database);
                MeshNetworkDb.migrateProvisioner(database);
                MeshNetworkDb.migrateGroup(database);
            }
        };
        MIGRATION_2_3 = new Migration(2, 3){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateGroup2_3(database);
            }
        };
        MIGRATION_3_4 = new Migration(3, 4){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateNodes3_4(database);
            }
        };
        MIGRATION_4_5 = new Migration(4, 5){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateProvisioner4_5(database);
            }
        };
        MIGRATION_5_6 = new Migration(5, 6){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateMeshNetwork5_6(database);
            }
        };
        MIGRATION_6_7 = new Migration(6, 7){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateKeyIndexes6_7(database);
            }
        };
        MIGRATION_7_8 = new Migration(7, 8){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateMeshNetwork7_8(database);
            }
        };
        MIGRATION_8_9 = new Migration(8, 9){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateProvisioner8_9(database);
            }
        };
        MIGRATION_9_10 = new Migration(9, 10){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateMeshNetwork9_10(database);
            }
        };
        MIGRATION_10_11 = new Migration(10, 11){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateNodes10_11(database);
            }
        };
        MIGRATION_11_12 = new Migration(11, 12){

            public void migrate(@NonNull SupportSQLiteDatabase database) {
                MeshNetworkDb.migrateMeshNetwork11_12(database);
            }
        };
    }
}

