/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.nordicsemi.android.mesh.MeshNetworkDb;
import no.nordicsemi.android.mesh.data.ApplicationKeyDao;
import no.nordicsemi.android.mesh.data.ApplicationKeyDao_Impl;
import no.nordicsemi.android.mesh.data.ApplicationKeysDao;
import no.nordicsemi.android.mesh.data.ApplicationKeysDao_Impl;
import no.nordicsemi.android.mesh.data.GroupDao;
import no.nordicsemi.android.mesh.data.GroupDao_Impl;
import no.nordicsemi.android.mesh.data.GroupsDao;
import no.nordicsemi.android.mesh.data.GroupsDao_Impl;
import no.nordicsemi.android.mesh.data.MeshNetworkDao;
import no.nordicsemi.android.mesh.data.MeshNetworkDao_Impl;
import no.nordicsemi.android.mesh.data.NetworkKeyDao;
import no.nordicsemi.android.mesh.data.NetworkKeyDao_Impl;
import no.nordicsemi.android.mesh.data.NetworkKeysDao;
import no.nordicsemi.android.mesh.data.NetworkKeysDao_Impl;
import no.nordicsemi.android.mesh.data.ProvisionedMeshNodeDao;
import no.nordicsemi.android.mesh.data.ProvisionedMeshNodeDao_Impl;
import no.nordicsemi.android.mesh.data.ProvisionedMeshNodesDao;
import no.nordicsemi.android.mesh.data.ProvisionedMeshNodesDao_Impl;
import no.nordicsemi.android.mesh.data.ProvisionerDao;
import no.nordicsemi.android.mesh.data.ProvisionerDao_Impl;
import no.nordicsemi.android.mesh.data.ProvisionersDao;
import no.nordicsemi.android.mesh.data.ProvisionersDao_Impl;
import no.nordicsemi.android.mesh.data.SceneDao;
import no.nordicsemi.android.mesh.data.SceneDao_Impl;
import no.nordicsemi.android.mesh.data.ScenesDao;
import no.nordicsemi.android.mesh.data.ScenesDao_Impl;

public final class MeshNetworkDb_Impl
extends MeshNetworkDb {
    private volatile MeshNetworkDao _meshNetworkDao;
    private volatile NetworkKeyDao _networkKeyDao;
    private volatile NetworkKeysDao _networkKeysDao;
    private volatile ApplicationKeyDao _applicationKeyDao;
    private volatile ApplicationKeysDao _applicationKeysDao;
    private volatile ProvisionerDao _provisionerDao;
    private volatile ProvisionersDao _provisionersDao;
    private volatile ProvisionedMeshNodeDao _provisionedMeshNodeDao;
    private volatile ProvisionedMeshNodesDao _provisionedMeshNodesDao;
    private volatile GroupsDao _groupsDao;
    private volatile GroupDao _groupDao;
    private volatile ScenesDao _scenesDao;
    private volatile SceneDao _sceneDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(12){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `mesh_network` (`mesh_uuid` TEXT NOT NULL, `mesh_name` TEXT, `timestamp` INTEGER NOT NULL DEFAULT 0, `partial` INTEGER NOT NULL DEFAULT 0, `iv_index` TEXT NOT NULL, `network_exclusions` TEXT NOT NULL DEFAULT '{}', `last_selected` INTEGER NOT NULL, PRIMARY KEY(`mesh_uuid`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `network_key` (`phase` INTEGER NOT NULL, `security` INTEGER NOT NULL, `timestamp` INTEGER NOT NULL, `id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `mesh_uuid` TEXT, `index` INTEGER NOT NULL, `name` TEXT, `key` BLOB, `old_key` BLOB, FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_network_key_mesh_uuid` ON `network_key` (`mesh_uuid`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `application_key` (`bound_key_index` INTEGER NOT NULL, `id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `mesh_uuid` TEXT, `index` INTEGER NOT NULL, `name` TEXT, `key` BLOB, `old_key` BLOB, FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_application_key_mesh_uuid` ON `application_key` (`mesh_uuid`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `provisioner` (`mesh_uuid` TEXT NOT NULL, `provisioner_uuid` TEXT NOT NULL, `name` TEXT, `allocated_unicast_ranges` TEXT NOT NULL, `allocated_group_ranges` TEXT NOT NULL, `allocated_scene_ranges` TEXT NOT NULL, `provisioner_address` INTEGER, `global_ttl` INTEGER NOT NULL, `last_selected` INTEGER NOT NULL, PRIMARY KEY(`provisioner_uuid`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_provisioner_mesh_uuid` ON `provisioner` (`mesh_uuid`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `nodes` (`timestamp` INTEGER NOT NULL, `name` TEXT, `ttl` INTEGER, `secureNetworkBeacon` INTEGER, `mesh_uuid` TEXT, `uuid` TEXT NOT NULL, `security` INTEGER NOT NULL, `unicast_address` INTEGER NOT NULL, `configured` INTEGER NOT NULL, `device_key` BLOB, `seq_number` INTEGER NOT NULL, `cid` INTEGER, `pid` INTEGER, `vid` INTEGER, `crpl` INTEGER, `netKeys` TEXT, `appKeys` TEXT, `elements` TEXT, `excluded` INTEGER NOT NULL, `networkTransmitCount` INTEGER, `networkIntervalSteps` INTEGER, `relayTransmitCount` INTEGER, `relayIntervalSteps` INTEGER, `friend` INTEGER, `lowPower` INTEGER, `proxy` INTEGER, `relay` INTEGER, PRIMARY KEY(`uuid`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_nodes_mesh_uuid` ON `nodes` (`mesh_uuid`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `groups` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `name` TEXT, `group_address` INTEGER NOT NULL, `group_address_label` TEXT, `parent_address` INTEGER NOT NULL, `parent_address_label` TEXT, `mesh_uuid` TEXT, FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_groups_mesh_uuid` ON `groups` (`mesh_uuid`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `scene` (`mesh_uuid` TEXT, `name` TEXT, `addresses` TEXT, `number` INTEGER NOT NULL, PRIMARY KEY(`number`), FOREIGN KEY(`mesh_uuid`) REFERENCES `mesh_network`(`mesh_uuid`) ON UPDATE CASCADE ON DELETE CASCADE )");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `index_scene_mesh_uuid` ON `scene` (`mesh_uuid`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '8394ae9cb3679dd212c1ebfb9789bdc2')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `mesh_network`");
                _db.execSQL("DROP TABLE IF EXISTS `network_key`");
                _db.execSQL("DROP TABLE IF EXISTS `application_key`");
                _db.execSQL("DROP TABLE IF EXISTS `provisioner`");
                _db.execSQL("DROP TABLE IF EXISTS `nodes`");
                _db.execSQL("DROP TABLE IF EXISTS `groups`");
                _db.execSQL("DROP TABLE IF EXISTS `scene`");
                if (MeshNetworkDb_Impl.this.mCallbacks != null) {
                    int _size = MeshNetworkDb_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MeshNetworkDb_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (MeshNetworkDb_Impl.this.mCallbacks != null) {
                    int _size = MeshNetworkDb_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MeshNetworkDb_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                MeshNetworkDb_Impl.this.mDatabase = _db;
                _db.execSQL("PRAGMA foreign_keys = ON");
                MeshNetworkDb_Impl.this.internalInitInvalidationTracker(_db);
                if (MeshNetworkDb_Impl.this.mCallbacks != null) {
                    int _size = MeshNetworkDb_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MeshNetworkDb_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsMeshNetwork = new HashMap<String, TableInfo.Column>(7);
                _columnsMeshNetwork.put("mesh_uuid", new TableInfo.Column("mesh_uuid", "TEXT", true, 1, null, 1));
                _columnsMeshNetwork.put("mesh_name", new TableInfo.Column("mesh_name", "TEXT", false, 0, null, 1));
                _columnsMeshNetwork.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, "0", 1));
                _columnsMeshNetwork.put("partial", new TableInfo.Column("partial", "INTEGER", true, 0, "0", 1));
                _columnsMeshNetwork.put("iv_index", new TableInfo.Column("iv_index", "TEXT", true, 0, null, 1));
                _columnsMeshNetwork.put("network_exclusions", new TableInfo.Column("network_exclusions", "TEXT", true, 0, "'{}'", 1));
                _columnsMeshNetwork.put("last_selected", new TableInfo.Column("last_selected", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysMeshNetwork = new HashSet(0);
                HashSet _indicesMeshNetwork = new HashSet(0);
                TableInfo _infoMeshNetwork = new TableInfo("mesh_network", _columnsMeshNetwork, _foreignKeysMeshNetwork, _indicesMeshNetwork);
                TableInfo _existingMeshNetwork = TableInfo.read((SupportSQLiteDatabase)_db, (String)"mesh_network");
                if (!_infoMeshNetwork.equals((Object)_existingMeshNetwork)) {
                    return new RoomOpenHelper.ValidationResult(false, "mesh_network(no.nordicsemi.android.mesh.MeshNetwork).\n Expected:\n" + _infoMeshNetwork + "\n Found:\n" + _existingMeshNetwork);
                }
                HashMap<String, TableInfo.Column> _columnsNetworkKey = new HashMap<String, TableInfo.Column>(9);
                _columnsNetworkKey.put("phase", new TableInfo.Column("phase", "INTEGER", true, 0, null, 1));
                _columnsNetworkKey.put("security", new TableInfo.Column("security", "INTEGER", true, 0, null, 1));
                _columnsNetworkKey.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, 1));
                _columnsNetworkKey.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsNetworkKey.put("mesh_uuid", new TableInfo.Column("mesh_uuid", "TEXT", false, 0, null, 1));
                _columnsNetworkKey.put("index", new TableInfo.Column("index", "INTEGER", true, 0, null, 1));
                _columnsNetworkKey.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, 1));
                _columnsNetworkKey.put("key", new TableInfo.Column("key", "BLOB", false, 0, null, 1));
                _columnsNetworkKey.put("old_key", new TableInfo.Column("old_key", "BLOB", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysNetworkKey = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysNetworkKey.add(new TableInfo.ForeignKey("mesh_network", "CASCADE", "CASCADE", Arrays.asList("mesh_uuid"), Arrays.asList("mesh_uuid")));
                HashSet<TableInfo.Index> _indicesNetworkKey = new HashSet<TableInfo.Index>(1);
                _indicesNetworkKey.add(new TableInfo.Index("index_network_key_mesh_uuid", false, Arrays.asList("mesh_uuid"), Arrays.asList("ASC")));
                TableInfo _infoNetworkKey = new TableInfo("network_key", _columnsNetworkKey, _foreignKeysNetworkKey, _indicesNetworkKey);
                TableInfo _existingNetworkKey = TableInfo.read((SupportSQLiteDatabase)_db, (String)"network_key");
                if (!_infoNetworkKey.equals((Object)_existingNetworkKey)) {
                    return new RoomOpenHelper.ValidationResult(false, "network_key(no.nordicsemi.android.mesh.NetworkKey).\n Expected:\n" + _infoNetworkKey + "\n Found:\n" + _existingNetworkKey);
                }
                HashMap<String, TableInfo.Column> _columnsApplicationKey = new HashMap<String, TableInfo.Column>(7);
                _columnsApplicationKey.put("bound_key_index", new TableInfo.Column("bound_key_index", "INTEGER", true, 0, null, 1));
                _columnsApplicationKey.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsApplicationKey.put("mesh_uuid", new TableInfo.Column("mesh_uuid", "TEXT", false, 0, null, 1));
                _columnsApplicationKey.put("index", new TableInfo.Column("index", "INTEGER", true, 0, null, 1));
                _columnsApplicationKey.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, 1));
                _columnsApplicationKey.put("key", new TableInfo.Column("key", "BLOB", false, 0, null, 1));
                _columnsApplicationKey.put("old_key", new TableInfo.Column("old_key", "BLOB", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysApplicationKey = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysApplicationKey.add(new TableInfo.ForeignKey("mesh_network", "CASCADE", "CASCADE", Arrays.asList("mesh_uuid"), Arrays.asList("mesh_uuid")));
                HashSet<TableInfo.Index> _indicesApplicationKey = new HashSet<TableInfo.Index>(1);
                _indicesApplicationKey.add(new TableInfo.Index("index_application_key_mesh_uuid", false, Arrays.asList("mesh_uuid"), Arrays.asList("ASC")));
                TableInfo _infoApplicationKey = new TableInfo("application_key", _columnsApplicationKey, _foreignKeysApplicationKey, _indicesApplicationKey);
                TableInfo _existingApplicationKey = TableInfo.read((SupportSQLiteDatabase)_db, (String)"application_key");
                if (!_infoApplicationKey.equals((Object)_existingApplicationKey)) {
                    return new RoomOpenHelper.ValidationResult(false, "application_key(no.nordicsemi.android.mesh.ApplicationKey).\n Expected:\n" + _infoApplicationKey + "\n Found:\n" + _existingApplicationKey);
                }
                HashMap<String, TableInfo.Column> _columnsProvisioner = new HashMap<String, TableInfo.Column>(9);
                _columnsProvisioner.put("mesh_uuid", new TableInfo.Column("mesh_uuid", "TEXT", true, 0, null, 1));
                _columnsProvisioner.put("provisioner_uuid", new TableInfo.Column("provisioner_uuid", "TEXT", true, 1, null, 1));
                _columnsProvisioner.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, 1));
                _columnsProvisioner.put("allocated_unicast_ranges", new TableInfo.Column("allocated_unicast_ranges", "TEXT", true, 0, null, 1));
                _columnsProvisioner.put("allocated_group_ranges", new TableInfo.Column("allocated_group_ranges", "TEXT", true, 0, null, 1));
                _columnsProvisioner.put("allocated_scene_ranges", new TableInfo.Column("allocated_scene_ranges", "TEXT", true, 0, null, 1));
                _columnsProvisioner.put("provisioner_address", new TableInfo.Column("provisioner_address", "INTEGER", false, 0, null, 1));
                _columnsProvisioner.put("global_ttl", new TableInfo.Column("global_ttl", "INTEGER", true, 0, null, 1));
                _columnsProvisioner.put("last_selected", new TableInfo.Column("last_selected", "INTEGER", true, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysProvisioner = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysProvisioner.add(new TableInfo.ForeignKey("mesh_network", "CASCADE", "CASCADE", Arrays.asList("mesh_uuid"), Arrays.asList("mesh_uuid")));
                HashSet<TableInfo.Index> _indicesProvisioner = new HashSet<TableInfo.Index>(1);
                _indicesProvisioner.add(new TableInfo.Index("index_provisioner_mesh_uuid", false, Arrays.asList("mesh_uuid"), Arrays.asList("ASC")));
                TableInfo _infoProvisioner = new TableInfo("provisioner", _columnsProvisioner, _foreignKeysProvisioner, _indicesProvisioner);
                TableInfo _existingProvisioner = TableInfo.read((SupportSQLiteDatabase)_db, (String)"provisioner");
                if (!_infoProvisioner.equals((Object)_existingProvisioner)) {
                    return new RoomOpenHelper.ValidationResult(false, "provisioner(no.nordicsemi.android.mesh.Provisioner).\n Expected:\n" + _infoProvisioner + "\n Found:\n" + _existingProvisioner);
                }
                HashMap<String, TableInfo.Column> _columnsNodes = new HashMap<String, TableInfo.Column>(27);
                _columnsNodes.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, 1));
                _columnsNodes.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, 1));
                _columnsNodes.put("ttl", new TableInfo.Column("ttl", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("secureNetworkBeacon", new TableInfo.Column("secureNetworkBeacon", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("mesh_uuid", new TableInfo.Column("mesh_uuid", "TEXT", false, 0, null, 1));
                _columnsNodes.put("uuid", new TableInfo.Column("uuid", "TEXT", true, 1, null, 1));
                _columnsNodes.put("security", new TableInfo.Column("security", "INTEGER", true, 0, null, 1));
                _columnsNodes.put("unicast_address", new TableInfo.Column("unicast_address", "INTEGER", true, 0, null, 1));
                _columnsNodes.put("configured", new TableInfo.Column("configured", "INTEGER", true, 0, null, 1));
                _columnsNodes.put("device_key", new TableInfo.Column("device_key", "BLOB", false, 0, null, 1));
                _columnsNodes.put("seq_number", new TableInfo.Column("seq_number", "INTEGER", true, 0, null, 1));
                _columnsNodes.put("cid", new TableInfo.Column("cid", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("pid", new TableInfo.Column("pid", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("vid", new TableInfo.Column("vid", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("crpl", new TableInfo.Column("crpl", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("netKeys", new TableInfo.Column("netKeys", "TEXT", false, 0, null, 1));
                _columnsNodes.put("appKeys", new TableInfo.Column("appKeys", "TEXT", false, 0, null, 1));
                _columnsNodes.put("elements", new TableInfo.Column("elements", "TEXT", false, 0, null, 1));
                _columnsNodes.put("excluded", new TableInfo.Column("excluded", "INTEGER", true, 0, null, 1));
                _columnsNodes.put("networkTransmitCount", new TableInfo.Column("networkTransmitCount", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("networkIntervalSteps", new TableInfo.Column("networkIntervalSteps", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("relayTransmitCount", new TableInfo.Column("relayTransmitCount", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("relayIntervalSteps", new TableInfo.Column("relayIntervalSteps", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("friend", new TableInfo.Column("friend", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("lowPower", new TableInfo.Column("lowPower", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("proxy", new TableInfo.Column("proxy", "INTEGER", false, 0, null, 1));
                _columnsNodes.put("relay", new TableInfo.Column("relay", "INTEGER", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysNodes = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysNodes.add(new TableInfo.ForeignKey("mesh_network", "CASCADE", "CASCADE", Arrays.asList("mesh_uuid"), Arrays.asList("mesh_uuid")));
                HashSet<TableInfo.Index> _indicesNodes = new HashSet<TableInfo.Index>(1);
                _indicesNodes.add(new TableInfo.Index("index_nodes_mesh_uuid", false, Arrays.asList("mesh_uuid"), Arrays.asList("ASC")));
                TableInfo _infoNodes = new TableInfo("nodes", _columnsNodes, _foreignKeysNodes, _indicesNodes);
                TableInfo _existingNodes = TableInfo.read((SupportSQLiteDatabase)_db, (String)"nodes");
                if (!_infoNodes.equals((Object)_existingNodes)) {
                    return new RoomOpenHelper.ValidationResult(false, "nodes(no.nordicsemi.android.mesh.transport.ProvisionedMeshNode).\n Expected:\n" + _infoNodes + "\n Found:\n" + _existingNodes);
                }
                HashMap<String, TableInfo.Column> _columnsGroups = new HashMap<String, TableInfo.Column>(7);
                _columnsGroups.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsGroups.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, 1));
                _columnsGroups.put("group_address", new TableInfo.Column("group_address", "INTEGER", true, 0, null, 1));
                _columnsGroups.put("group_address_label", new TableInfo.Column("group_address_label", "TEXT", false, 0, null, 1));
                _columnsGroups.put("parent_address", new TableInfo.Column("parent_address", "INTEGER", true, 0, null, 1));
                _columnsGroups.put("parent_address_label", new TableInfo.Column("parent_address_label", "TEXT", false, 0, null, 1));
                _columnsGroups.put("mesh_uuid", new TableInfo.Column("mesh_uuid", "TEXT", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysGroups = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysGroups.add(new TableInfo.ForeignKey("mesh_network", "CASCADE", "CASCADE", Arrays.asList("mesh_uuid"), Arrays.asList("mesh_uuid")));
                HashSet<TableInfo.Index> _indicesGroups = new HashSet<TableInfo.Index>(1);
                _indicesGroups.add(new TableInfo.Index("index_groups_mesh_uuid", false, Arrays.asList("mesh_uuid"), Arrays.asList("ASC")));
                TableInfo _infoGroups = new TableInfo("groups", _columnsGroups, _foreignKeysGroups, _indicesGroups);
                TableInfo _existingGroups = TableInfo.read((SupportSQLiteDatabase)_db, (String)"groups");
                if (!_infoGroups.equals((Object)_existingGroups)) {
                    return new RoomOpenHelper.ValidationResult(false, "groups(no.nordicsemi.android.mesh.Group).\n Expected:\n" + _infoGroups + "\n Found:\n" + _existingGroups);
                }
                HashMap<String, TableInfo.Column> _columnsScene = new HashMap<String, TableInfo.Column>(4);
                _columnsScene.put("mesh_uuid", new TableInfo.Column("mesh_uuid", "TEXT", false, 0, null, 1));
                _columnsScene.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, 1));
                _columnsScene.put("addresses", new TableInfo.Column("addresses", "TEXT", false, 0, null, 1));
                _columnsScene.put("number", new TableInfo.Column("number", "INTEGER", true, 1, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysScene = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysScene.add(new TableInfo.ForeignKey("mesh_network", "CASCADE", "CASCADE", Arrays.asList("mesh_uuid"), Arrays.asList("mesh_uuid")));
                HashSet<TableInfo.Index> _indicesScene = new HashSet<TableInfo.Index>(1);
                _indicesScene.add(new TableInfo.Index("index_scene_mesh_uuid", false, Arrays.asList("mesh_uuid"), Arrays.asList("ASC")));
                TableInfo _infoScene = new TableInfo("scene", _columnsScene, _foreignKeysScene, _indicesScene);
                TableInfo _existingScene = TableInfo.read((SupportSQLiteDatabase)_db, (String)"scene");
                if (!_infoScene.equals((Object)_existingScene)) {
                    return new RoomOpenHelper.ValidationResult(false, "scene(no.nordicsemi.android.mesh.Scene).\n Expected:\n" + _infoScene + "\n Found:\n" + _existingScene);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "8394ae9cb3679dd212c1ebfb9789bdc2", "0d3343e75525c9cd7b8f4f460fbf7598");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"mesh_network", "network_key", "application_key", "provisioner", "nodes", "groups", "scene"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        boolean _supportsDeferForeignKeys = Build.VERSION.SDK_INT >= 21;
        try {
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = FALSE");
            }
            super.beginTransaction();
            if (_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
            }
            _db.execSQL("DELETE FROM `mesh_network`");
            _db.execSQL("DELETE FROM `network_key`");
            _db.execSQL("DELETE FROM `application_key`");
            _db.execSQL("DELETE FROM `provisioner`");
            _db.execSQL("DELETE FROM `nodes`");
            _db.execSQL("DELETE FROM `groups`");
            _db.execSQL("DELETE FROM `scene`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = TRUE");
            }
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(MeshNetworkDao.class, MeshNetworkDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(NetworkKeyDao.class, NetworkKeyDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(NetworkKeysDao.class, NetworkKeysDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ApplicationKeyDao.class, ApplicationKeyDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ApplicationKeysDao.class, ApplicationKeysDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ProvisionerDao.class, ProvisionerDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ProvisionersDao.class, ProvisionersDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ProvisionedMeshNodeDao.class, ProvisionedMeshNodeDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ProvisionedMeshNodesDao.class, ProvisionedMeshNodesDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(GroupsDao.class, GroupsDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(GroupDao.class, GroupDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(ScenesDao.class, ScenesDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(SceneDao.class, SceneDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    MeshNetworkDao meshNetworkDao() {
        if (this._meshNetworkDao != null) {
            return this._meshNetworkDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._meshNetworkDao == null) {
                this._meshNetworkDao = new MeshNetworkDao_Impl(this);
            }
            return this._meshNetworkDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    NetworkKeyDao networkKeyDao() {
        if (this._networkKeyDao != null) {
            return this._networkKeyDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._networkKeyDao == null) {
                this._networkKeyDao = new NetworkKeyDao_Impl(this);
            }
            return this._networkKeyDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    NetworkKeysDao networkKeysDao() {
        if (this._networkKeysDao != null) {
            return this._networkKeysDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._networkKeysDao == null) {
                this._networkKeysDao = new NetworkKeysDao_Impl(this);
            }
            return this._networkKeysDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ApplicationKeyDao applicationKeyDao() {
        if (this._applicationKeyDao != null) {
            return this._applicationKeyDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._applicationKeyDao == null) {
                this._applicationKeyDao = new ApplicationKeyDao_Impl(this);
            }
            return this._applicationKeyDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ApplicationKeysDao applicationKeysDao() {
        if (this._applicationKeysDao != null) {
            return this._applicationKeysDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._applicationKeysDao == null) {
                this._applicationKeysDao = new ApplicationKeysDao_Impl(this);
            }
            return this._applicationKeysDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ProvisionerDao provisionerDao() {
        if (this._provisionerDao != null) {
            return this._provisionerDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._provisionerDao == null) {
                this._provisionerDao = new ProvisionerDao_Impl(this);
            }
            return this._provisionerDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ProvisionersDao provisionersDao() {
        if (this._provisionersDao != null) {
            return this._provisionersDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._provisionersDao == null) {
                this._provisionersDao = new ProvisionersDao_Impl(this);
            }
            return this._provisionersDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ProvisionedMeshNodeDao provisionedMeshNodeDao() {
        if (this._provisionedMeshNodeDao != null) {
            return this._provisionedMeshNodeDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._provisionedMeshNodeDao == null) {
                this._provisionedMeshNodeDao = new ProvisionedMeshNodeDao_Impl(this);
            }
            return this._provisionedMeshNodeDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ProvisionedMeshNodesDao provisionedMeshNodesDao() {
        if (this._provisionedMeshNodesDao != null) {
            return this._provisionedMeshNodesDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._provisionedMeshNodesDao == null) {
                this._provisionedMeshNodesDao = new ProvisionedMeshNodesDao_Impl(this);
            }
            return this._provisionedMeshNodesDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    GroupsDao groupsDao() {
        if (this._groupsDao != null) {
            return this._groupsDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._groupsDao == null) {
                this._groupsDao = new GroupsDao_Impl(this);
            }
            return this._groupsDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    GroupDao groupDao() {
        if (this._groupDao != null) {
            return this._groupDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._groupDao == null) {
                this._groupDao = new GroupDao_Impl(this);
            }
            return this._groupDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ScenesDao scenesDao() {
        if (this._scenesDao != null) {
            return this._scenesDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._scenesDao == null) {
                this._scenesDao = new ScenesDao_Impl(this);
            }
            return this._scenesDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    SceneDao sceneDao() {
        if (this._sceneDao != null) {
            return this._sceneDao;
        }
        MeshNetworkDb_Impl meshNetworkDb_Impl = this;
        synchronized (meshNetworkDb_Impl) {
            if (this._sceneDao == null) {
                this._sceneDao = new SceneDao_Impl(this);
            }
            return this._sceneDao;
        }
    }
}

