/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.util.List;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.MeshProvisioningStatusCallbacks;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningCapabilities;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningState;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedMeshNode;
import no.nordicsemi.android.mesh.utils.AlgorithmType;
import no.nordicsemi.android.mesh.utils.AuthenticationOOBMethods;
import no.nordicsemi.android.mesh.utils.InputOOBAction;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.OutputOOBAction;
import no.nordicsemi.android.mesh.utils.StaticOOBType;

public class ProvisioningStartState
extends ProvisioningState {
    private final String TAG = ProvisioningStartState.class.getSimpleName();
    private final UnprovisionedMeshNode node;
    private final MeshProvisioningStatusCallbacks mMeshProvisioningStatusCallbacks;
    private final InternalTransportCallbacks mInternalTransportCallbacks;
    private List<AlgorithmType> algorithmTypes;
    private int outputOOBSize;
    private int inputOOBSize;
    private int publicKeyType;
    private short outputActionType;
    private short inputActionType;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ProvisioningStartState(UnprovisionedMeshNode node, ProvisioningCapabilities capabilities, InternalTransportCallbacks internalTransportCallbacks, MeshProvisioningStatusCallbacks provisioningStatusCallbacks) {
        this.node = node;
        this.mInternalTransportCallbacks = internalTransportCallbacks;
        this.mMeshProvisioningStatusCallbacks = provisioningStatusCallbacks;
        this.setProvisioningCapabilities(capabilities);
    }

    public void setUseStaticOOB(StaticOOBType actionType) {
        this.node.setAuthMethodUsed(AuthenticationOOBMethods.STATIC_OOB_AUTHENTICATION);
        this.node.setAuthActionUsed(actionType.getStaticOobType());
    }

    public void setUseOutputOOB(OutputOOBAction actionType) {
        this.node.setAuthMethodUsed(AuthenticationOOBMethods.OUTPUT_OOB_AUTHENTICATION);
        this.outputActionType = actionType.getOutputOOBAction();
        this.node.setAuthActionUsed(actionType.getOutputOOBAction());
    }

    public void setUseInputOOB(InputOOBAction actionType) {
        this.node.setAuthMethodUsed(AuthenticationOOBMethods.INPUT_OOB_AUTHENTICATION);
        this.inputActionType = actionType.getInputOOBAction();
        this.node.setAuthActionUsed(actionType.getInputOOBAction());
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_START;
    }

    @Override
    public void executeSend() {
        byte[] provisioningStartPDU = this.createProvisioningStartPDU();
        this.node.setProvisioningStartPdu(provisioningStartPDU);
        this.mMeshProvisioningStatusCallbacks.onProvisioningStateChanged(this.node, ProvisioningState.States.PROVISIONING_START, provisioningStartPDU);
        this.mInternalTransportCallbacks.sendProvisioningPdu(this.node, provisioningStartPDU);
    }

    @Override
    public boolean parseData(@NonNull byte[] data) {
        return true;
    }

    private byte[] createProvisioningStartPDU() {
        byte[] provisioningPDU = new byte[7];
        provisioningPDU[0] = 3;
        provisioningPDU[1] = 2;
        provisioningPDU[2] = AlgorithmType.getSupportedAlgorithmValue(this.algorithmTypes);
        provisioningPDU[3] = (byte)(this.node.getProvisioneePublicKeyXY() == null ? 0 : this.publicKeyType);
        provisioningPDU[4] = (byte)this.node.getAuthMethodUsed().ordinal();
        switch (this.node.getAuthMethodUsed()) {
            case NO_OOB_AUTHENTICATION: 
            case STATIC_OOB_AUTHENTICATION: {
                provisioningPDU[5] = 0;
                provisioningPDU[6] = 0;
                break;
            }
            case OUTPUT_OOB_AUTHENTICATION: {
                provisioningPDU[5] = (byte)OutputOOBAction.getOutputOOBActionValue(this.outputActionType);
                provisioningPDU[6] = (byte)this.outputOOBSize;
                break;
            }
            case INPUT_OOB_AUTHENTICATION: {
                provisioningPDU[5] = (byte)InputOOBAction.getInputOOBActionValue(this.inputActionType);
                provisioningPDU[6] = (byte)this.inputOOBSize;
                this.node.setInputAuthentication(InputOOBAction.getInputOOOBAuthenticationValue(this.inputActionType, (byte)this.inputOOBSize));
            }
        }
        Log.v((String)this.TAG, (String)("Provisioning start PDU: " + MeshParserUtils.bytesToHex(provisioningPDU, true)));
        return provisioningPDU;
    }

    private void setProvisioningCapabilities(ProvisioningCapabilities capabilities) {
        this.algorithmTypes = capabilities.getSupportedAlgorithmTypes();
        this.outputOOBSize = capabilities.getOutputOOBSize();
        this.inputOOBSize = capabilities.getInputOOBSize();
        this.publicKeyType = capabilities.getRawPublicKeyType();
    }
}

