/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class Temperature
extends DevicePropertyCharacteristic<Float> {
    private static final String TAG = Temperature.class.getSimpleName();
    private final int length;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Temperature(@NonNull byte[] data, int offset, int length) {
        super(data, offset, length);
        this.length = length;
        switch (length) {
            case 1: {
                int tempValue = MeshParserUtils.unsignedToSigned(data[offset] & 0xFF, 8);
                if (tempValue == 32768) {
                    this.value = null;
                }
                this.value = Float.valueOf((float)tempValue / 2.0f);
                if (!(((Float)this.value).floatValue() < -64.0f) && !(((Float)this.value).floatValue() > 63.5f)) break;
                this.value = null;
                Log.e((String)TAG, (String)("Value " + tempValue + " is Prohibited!"));
                break;
            }
            case 2: {
                int tempValue = MeshParserUtils.unsignedToSigned(data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8, 16);
                if (tempValue == 32768) {
                    this.value = null;
                }
                this.value = Float.valueOf((float)tempValue / 100.0f);
                if (!(((Float)this.value).floatValue() < -273.15f) && !(((Float)this.value).floatValue() > 327.67f)) break;
                this.value = null;
                Log.e((String)TAG, (String)("Value " + tempValue + " is Prohibited!"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid length");
            }
        }
    }

    public Temperature(float temperature) {
        int length = Float.floatToIntBits(temperature) / 8;
        if (length != 1 && length != 2) {
            throw new IllegalArgumentException("Illegal length");
        }
        this.length = length;
        this.value = Float.valueOf(temperature);
    }

    @NonNull
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] getBytes() {
        if (this.getLength() == 1) {
            float val = ((Float)this.value).floatValue() * 10.0f;
            return new byte[]{(byte)val};
        }
        float val = ((Float)this.value).floatValue() * 100.0f;
        return ByteBuffer.allocate(this.getLength()).order(ByteOrder.LITTLE_ENDIAN).putShort((short)val).array();
    }
}

