/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class ConfigModelSubscriptionOverwrite
extends ConfigMessage {
    private static final String TAG = ConfigModelSubscriptionOverwrite.class.getSimpleName();
    private static final int OP_CODE = 32798;
    private static final int SIG_MODEL_APP_KEY_BIND_PARAMS_LENGTH = 6;
    private static final int VENDOR_MODEL_APP_KEY_BIND_PARAMS_LENGTH = 8;
    private final int elementAddress;
    private final int mSubscriptionAddress;
    private final int mModelIdentifier;

    public ConfigModelSubscriptionOverwrite(int elementAddress, int subscriptionAddress, int modelIdentifier) throws IllegalArgumentException {
        if (!MeshAddress.isValidUnicastAddress(elementAddress)) {
            throw new IllegalArgumentException("Invalid unicast address, unicast address must be a 16-bit value, and must range from 0x0001 to 0x7FFF");
        }
        this.elementAddress = elementAddress;
        if (!MeshAddress.isAddressInRange(subscriptionAddress)) {
            throw new IllegalArgumentException("Invalid subscription address, subscription address must be a 16-bit value");
        }
        this.mSubscriptionAddress = subscriptionAddress;
        this.mModelIdentifier = modelIdentifier;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32798;
    }

    @Override
    void assembleMessageParameters() {
        ByteBuffer paramsBuffer;
        byte[] elementAddress = MeshAddress.addressIntToBytes(this.elementAddress);
        byte[] subscriptionAddress = MeshAddress.addressIntToBytes(this.mSubscriptionAddress);
        if (!MeshParserUtils.isVendorModel(this.mModelIdentifier)) {
            paramsBuffer = ByteBuffer.allocate(6).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put(elementAddress[1]);
            paramsBuffer.put(elementAddress[0]);
            paramsBuffer.put(subscriptionAddress[1]);
            paramsBuffer.put(subscriptionAddress[0]);
            paramsBuffer.putShort((short)this.mModelIdentifier);
        } else {
            paramsBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put(elementAddress[1]);
            paramsBuffer.put(elementAddress[0]);
            paramsBuffer.put(subscriptionAddress[1]);
            paramsBuffer.put(subscriptionAddress[0]);
            byte[] modelIdentifier = new byte[]{(byte)(this.mModelIdentifier >> 24 & 0xFF), (byte)(this.mModelIdentifier >> 16 & 0xFF), (byte)(this.mModelIdentifier >> 8 & 0xFF), (byte)(this.mModelIdentifier & 0xFF)};
            paramsBuffer.put(modelIdentifier[1]);
            paramsBuffer.put(modelIdentifier[0]);
            paramsBuffer.put(modelIdentifier[3]);
            paramsBuffer.put(modelIdentifier[2]);
        }
        this.mParameters = paramsBuffer.array();
    }
}

