/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import no.nordicsemi.android.mesh.Group;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshStatusCallbacks;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.control.BlockAcknowledgementMessage;
import no.nordicsemi.android.mesh.control.TransportControlMessage;
import no.nordicsemi.android.mesh.models.ConfigurationServerModel;
import no.nordicsemi.android.mesh.models.SceneServer;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigAppKeyAdd;
import no.nordicsemi.android.mesh.transport.ConfigAppKeyDelete;
import no.nordicsemi.android.mesh.transport.ConfigAppKeyList;
import no.nordicsemi.android.mesh.transport.ConfigAppKeyStatus;
import no.nordicsemi.android.mesh.transport.ConfigAppKeyUpdate;
import no.nordicsemi.android.mesh.transport.ConfigBeaconStatus;
import no.nordicsemi.android.mesh.transport.ConfigCompositionDataStatus;
import no.nordicsemi.android.mesh.transport.ConfigDefaultTtlStatus;
import no.nordicsemi.android.mesh.transport.ConfigFriendStatus;
import no.nordicsemi.android.mesh.transport.ConfigHeartbeatPublicationStatus;
import no.nordicsemi.android.mesh.transport.ConfigHeartbeatSubscriptionStatus;
import no.nordicsemi.android.mesh.transport.ConfigKeyRefreshPhaseStatus;
import no.nordicsemi.android.mesh.transport.ConfigLowPowerNodePollTimeoutStatus;
import no.nordicsemi.android.mesh.transport.ConfigModelAppBind;
import no.nordicsemi.android.mesh.transport.ConfigModelAppStatus;
import no.nordicsemi.android.mesh.transport.ConfigModelPublicationGet;
import no.nordicsemi.android.mesh.transport.ConfigModelPublicationSet;
import no.nordicsemi.android.mesh.transport.ConfigModelPublicationStatus;
import no.nordicsemi.android.mesh.transport.ConfigModelPublicationVirtualAddressSet;
import no.nordicsemi.android.mesh.transport.ConfigModelSubscriptionAdd;
import no.nordicsemi.android.mesh.transport.ConfigModelSubscriptionDelete;
import no.nordicsemi.android.mesh.transport.ConfigModelSubscriptionDeleteAll;
import no.nordicsemi.android.mesh.transport.ConfigModelSubscriptionOverwrite;
import no.nordicsemi.android.mesh.transport.ConfigModelSubscriptionStatus;
import no.nordicsemi.android.mesh.transport.ConfigModelSubscriptionVirtualAddressAdd;
import no.nordicsemi.android.mesh.transport.ConfigModelSubscriptionVirtualAddressDelete;
import no.nordicsemi.android.mesh.transport.ConfigModelSubscriptionVirtualAddressOverwrite;
import no.nordicsemi.android.mesh.transport.ConfigNetKeyAdd;
import no.nordicsemi.android.mesh.transport.ConfigNetKeyDelete;
import no.nordicsemi.android.mesh.transport.ConfigNetKeyList;
import no.nordicsemi.android.mesh.transport.ConfigNetKeyStatus;
import no.nordicsemi.android.mesh.transport.ConfigNetKeyUpdate;
import no.nordicsemi.android.mesh.transport.ConfigNetworkTransmitStatus;
import no.nordicsemi.android.mesh.transport.ConfigNodeIdentityStatus;
import no.nordicsemi.android.mesh.transport.ConfigNodeResetStatus;
import no.nordicsemi.android.mesh.transport.ConfigProxyStatus;
import no.nordicsemi.android.mesh.transport.ConfigRelayStatus;
import no.nordicsemi.android.mesh.transport.ConfigSigModelAppList;
import no.nordicsemi.android.mesh.transport.ConfigSigModelSubscriptionList;
import no.nordicsemi.android.mesh.transport.ConfigVendorModelAppList;
import no.nordicsemi.android.mesh.transport.ConfigVendorModelSubscriptionList;
import no.nordicsemi.android.mesh.transport.ControlMessage;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.GenericDefaultTransitionTimeStatus;
import no.nordicsemi.android.mesh.transport.GenericLevelStatus;
import no.nordicsemi.android.mesh.transport.GenericLocationGlobalStatus;
import no.nordicsemi.android.mesh.transport.GenericOnOffStatus;
import no.nordicsemi.android.mesh.transport.GenericOnPowerUpStatus;
import no.nordicsemi.android.mesh.transport.GenericPropertyStatus;
import no.nordicsemi.android.mesh.transport.InternalMeshMsgHandlerCallbacks;
import no.nordicsemi.android.mesh.transport.LightCtlStatus;
import no.nordicsemi.android.mesh.transport.LightHslStatus;
import no.nordicsemi.android.mesh.transport.LightLCLightOnOffStatus;
import no.nordicsemi.android.mesh.transport.LightLCModeStatus;
import no.nordicsemi.android.mesh.transport.LightLCOccupancyModeStatus;
import no.nordicsemi.android.mesh.transport.LightLCPropertyStatus;
import no.nordicsemi.android.mesh.transport.LightLightnessStatus;
import no.nordicsemi.android.mesh.transport.MeshMessage;
import no.nordicsemi.android.mesh.transport.MeshMessageState;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.transport.MeshTransport;
import no.nordicsemi.android.mesh.transport.Message;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.transport.ProxyConfigAddAddressToFilter;
import no.nordicsemi.android.mesh.transport.ProxyConfigFilterStatus;
import no.nordicsemi.android.mesh.transport.ProxyConfigRemoveAddressFromFilter;
import no.nordicsemi.android.mesh.transport.ProxyConfigSetFilterType;
import no.nordicsemi.android.mesh.transport.SceneDelete;
import no.nordicsemi.android.mesh.transport.SceneRecall;
import no.nordicsemi.android.mesh.transport.SceneRegisterStatus;
import no.nordicsemi.android.mesh.transport.SceneStatus;
import no.nordicsemi.android.mesh.transport.SceneStore;
import no.nordicsemi.android.mesh.transport.SchedulerActionStatus;
import no.nordicsemi.android.mesh.transport.SchedulerStatus;
import no.nordicsemi.android.mesh.transport.SensorCadenceStatus;
import no.nordicsemi.android.mesh.transport.SensorColumnStatus;
import no.nordicsemi.android.mesh.transport.SensorDescriptorStatus;
import no.nordicsemi.android.mesh.transport.SensorSeriesStatus;
import no.nordicsemi.android.mesh.transport.SensorSettingStatus;
import no.nordicsemi.android.mesh.transport.SensorSettingsStatus;
import no.nordicsemi.android.mesh.transport.SensorStatus;
import no.nordicsemi.android.mesh.transport.TimeStatus;
import no.nordicsemi.android.mesh.transport.TimeZoneStatus;
import no.nordicsemi.android.mesh.transport.VendorModelMessageAcked;
import no.nordicsemi.android.mesh.transport.VendorModelMessageStatus;
import no.nordicsemi.android.mesh.transport.VendorModelMessageUnacked;
import no.nordicsemi.android.mesh.utils.AddressArray;
import no.nordicsemi.android.mesh.utils.ExtendedInvalidCipherTextException;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.NetworkTransmitSettings;
import no.nordicsemi.android.mesh.utils.ProxyFilter;
import no.nordicsemi.android.mesh.utils.ProxyFilterType;
import no.nordicsemi.android.mesh.utils.RelaySettings;

class DefaultNoOperationMessageState
extends MeshMessageState {
    private static final String TAG = DefaultNoOperationMessageState.class.getSimpleName();

    DefaultNoOperationMessageState(@Nullable MeshMessage meshMessage, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks handlerCallbacks, @NonNull InternalTransportCallbacks transportCallbacks, @NonNull MeshStatusCallbacks statusCallbacks) {
        super(meshMessage, meshTransport, handlerCallbacks, transportCallbacks, statusCallbacks);
    }

    @Override
    public MeshMessageState.MessageState getState() {
        return null;
    }

    void parseMeshPdu(@NonNull NetworkKey key, @NonNull ProvisionedMeshNode node, @NonNull byte[] pdu, @NonNull byte[] networkHeader, @NonNull byte[] decryptedNetworkPayload, int ivIndex, @NonNull byte[] sequenceNumber) {
        try {
            Message message = this.mMeshTransport.parseMeshMessage(key, node, pdu, networkHeader, decryptedNetworkPayload, ivIndex, sequenceNumber);
            if (message != null) {
                if (message instanceof AccessMessage) {
                    this.parseAccessMessage((AccessMessage)message);
                } else {
                    this.parseControlMessage((ControlMessage)message);
                }
            } else {
                Log.v((String)TAG, (String)"Message reassembly may not be completed yet!");
            }
        }
        catch (ExtendedInvalidCipherTextException e) {
            Log.e((String)TAG, (String)("Decryption failed in " + e.getTag() + " : " + e.getMessage()));
            this.mMeshStatusCallbacks.onMessageDecryptionFailed(e.getTag(), e.getMessage());
        }
    }

    private void parseAccessMessage(AccessMessage message) {
        ProvisionedMeshNode node = this.mInternalTransportCallbacks.getNode(message.getSrc());
        int opCodeLength = MeshParserUtils.getOpCodeLength(message.getAccessPdu()[0] & 0xFF);
        switch (opCodeLength) {
            case 1: {
                if (message.getOpCode() == 2) {
                    ConfigCompositionDataStatus status = new ConfigCompositionDataStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        node.setCompositionData(status);
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 94) {
                    MeshModel model;
                    SceneStatus sceneStatus = new SceneStatus(message);
                    if (sceneStatus.isSuccessful() && (model = this.getMeshModel(node, sceneStatus.getSrc(), 4611)) != null) {
                        SceneServer sceneServer = (SceneServer)model;
                        sceneServer.currentScene = sceneStatus.getCurrentScene();
                        sceneServer.targetScene = sceneStatus.getTargetScene();
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(sceneStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), sceneStatus);
                    break;
                }
                if (message.getOpCode() == 6) {
                    ConfigurationServerModel model;
                    ConfigHeartbeatPublicationStatus status = new ConfigHeartbeatPublicationStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful() && (model = (ConfigurationServerModel)this.getMeshModel(node, status.getSrc(), 0)) != null) {
                        model.setHeartbeatPublication(!MeshAddress.isValidUnassignedAddress(status.getHeartbeatPublication().getDst()) ? status.getHeartbeatPublication() : null);
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 64) {
                    GenericLocationGlobalStatus genericLocationGlobalStatus = new GenericLocationGlobalStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(genericLocationGlobalStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), genericLocationGlobalStatus);
                    break;
                }
                if (message.getOpCode() == 81) {
                    SensorDescriptorStatus status = new SensorDescriptorStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 87) {
                    SensorCadenceStatus status = new SensorCadenceStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 88) {
                    SensorSettingsStatus status = new SensorSettingsStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 91) {
                    SensorSettingStatus status = new SensorSettingStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 82) {
                    SensorStatus status = new SensorStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 83) {
                    SensorColumnStatus status = new SensorColumnStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 84) {
                    SensorSeriesStatus status = new SensorSeriesStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 95) {
                    SchedulerActionStatus schedulerActionStatus = new SchedulerActionStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(schedulerActionStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), schedulerActionStatus);
                    break;
                }
                if (message.getOpCode() == 74 || message.getOpCode() == 70 || message.getOpCode() == 78) {
                    GenericPropertyStatus status = new GenericPropertyStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 93) {
                    TimeStatus timeStatus = new TimeStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(timeStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), timeStatus);
                    break;
                }
                this.handleUnknownPdu(message);
                break;
            }
            case 2: {
                if (message.getOpCode() == 32782) {
                    ConfigDefaultTtlStatus status = new ConfigDefaultTtlStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        node.setTtl(status.getTtl());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 33298) {
                    GenericOnPowerUpStatus genericOnPowerUpStatus = new GenericOnPowerUpStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(genericOnPowerUpStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), genericOnPowerUpStatus);
                    break;
                }
                if (message.getOpCode() == 32836) {
                    ConfigNetKeyStatus status = new ConfigNetKeyStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful()) {
                        if (this.mMeshMessage instanceof ConfigNetKeyAdd) {
                            node.setAddedNetKeyIndex(status.getNetKeyIndex());
                        } else if (this.mMeshMessage instanceof ConfigNetKeyUpdate) {
                            node.updateAddedNetKey(status.getNetKeyIndex());
                        } else if (this.mMeshMessage instanceof ConfigNetKeyDelete) {
                            node.removeAddedNetKeyIndex(status.getNetKeyIndex());
                        }
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32835) {
                    ConfigNetKeyList netKeyList = new ConfigNetKeyList(message);
                    if (!this.isReceivedViaProxyFilter(message) && netKeyList.isSuccessful()) {
                        node.updateNetKeyList(netKeyList.getKeyIndexes());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(netKeyList);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), netKeyList);
                    break;
                }
                if (message.getOpCode() == 32771) {
                    ConfigAppKeyStatus status = new ConfigAppKeyStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful()) {
                        if (this.mMeshMessage instanceof ConfigAppKeyAdd) {
                            node.setAddedAppKeyIndex(status.getAppKeyIndex());
                        } else if (this.mMeshMessage instanceof ConfigAppKeyUpdate) {
                            node.updateAddedAppKey(status.getAppKeyIndex());
                        } else if (this.mMeshMessage instanceof ConfigAppKeyDelete) {
                            node.removeAddedAppKeyIndex(status.getAppKeyIndex());
                        }
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32770) {
                    ConfigAppKeyList appKeyList = new ConfigAppKeyList(message);
                    if (!this.isReceivedViaProxyFilter(message) && appKeyList.isSuccessful()) {
                        node.updateAppKeyList(appKeyList.getNetKeyIndex(), appKeyList.getKeyIndexes(), this.mInternalTransportCallbacks.getApplicationKeys(appKeyList.getNetKeyIndex()));
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(appKeyList);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), appKeyList);
                    break;
                }
                if (message.getOpCode() == 32830) {
                    ConfigModelAppStatus status = new ConfigModelAppStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful()) {
                        if (this.mMeshMessage instanceof ConfigModelAppBind) {
                            node.setAppKeyBindStatus(status);
                        } else {
                            node.setAppKeyUnbindStatus(status);
                        }
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32844) {
                    MeshModel model;
                    ConfigSigModelAppList appKeyList = new ConfigSigModelAppList(message);
                    if (!this.isReceivedViaProxyFilter(message) && appKeyList.isSuccessful() && (model = this.getMeshModel(node, appKeyList.getElementAddress(), appKeyList.getModelIdentifier())) != null) {
                        model.setBoundAppKeyIndexes(appKeyList.getKeyIndexes());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(appKeyList);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), appKeyList);
                    break;
                }
                if (message.getOpCode() == 32846) {
                    MeshModel model;
                    ConfigVendorModelAppList appKeyList = new ConfigVendorModelAppList(message);
                    if (!this.isReceivedViaProxyFilter(message) && appKeyList.isSuccessful() && (model = this.getMeshModel(node, appKeyList.getElementAddress(), appKeyList.getModelIdentifier())) != null) {
                        model.setBoundAppKeyIndexes(appKeyList.getKeyIndexes());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(appKeyList);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), appKeyList);
                    break;
                }
                if (message.getOpCode() == 32793) {
                    MeshModel model;
                    ConfigModelPublicationStatus status = new ConfigModelPublicationStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful() && (model = this.getMeshModel(node, status.getElementAddress(), status.getModelIdentifier())) != null) {
                        if (this.mMeshMessage instanceof ConfigModelPublicationGet) {
                            model.updatePublicationStatus(status);
                        } else if (this.mMeshMessage instanceof ConfigModelPublicationSet) {
                            model.setPublicationStatus(status, null);
                        } else if (this.mMeshMessage instanceof ConfigModelPublicationVirtualAddressSet) {
                            UUID labelUUID = ((ConfigModelPublicationVirtualAddressSet)this.mMeshMessage).getLabelUuid();
                            model.setPublicationStatus(status, labelUUID);
                        }
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32799) {
                    MeshModel model;
                    ConfigModelSubscriptionStatus status = new ConfigModelSubscriptionStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful() && (model = this.getMeshModel(node, status.getElementAddress(), status.getModelIdentifier())) != null) {
                        if (this.mMeshMessage instanceof ConfigModelSubscriptionAdd) {
                            model.addSubscriptionAddress(status.getSubscriptionAddress());
                        } else if (this.mMeshMessage instanceof ConfigModelSubscriptionVirtualAddressAdd) {
                            model.addSubscriptionAddress(((ConfigModelSubscriptionVirtualAddressAdd)this.mMeshMessage).getLabelUuid(), status.getSubscriptionAddress());
                        } else if (this.mMeshMessage instanceof ConfigModelSubscriptionOverwrite) {
                            model.overwriteSubscriptionAddress(status.getSubscriptionAddress());
                        } else if (this.mMeshMessage instanceof ConfigModelSubscriptionVirtualAddressOverwrite) {
                            model.overwriteSubscriptionAddress(((ConfigModelSubscriptionVirtualAddressOverwrite)this.mMeshMessage).getLabelUuid(), status.getSubscriptionAddress());
                        } else if (this.mMeshMessage instanceof ConfigModelSubscriptionDelete) {
                            model.removeSubscriptionAddress(status.getSubscriptionAddress());
                        } else if (this.mMeshMessage instanceof ConfigModelSubscriptionVirtualAddressDelete) {
                            model.removeSubscriptionAddress(((ConfigModelSubscriptionVirtualAddressDelete)this.mMeshMessage).getLabelUuid(), status.getSubscriptionAddress());
                        } else if (this.mMeshMessage instanceof ConfigModelSubscriptionDeleteAll) {
                            model.removeAllSubscriptionAddresses();
                        }
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32810) {
                    ConfigSigModelSubscriptionList status = new ConfigSigModelSubscriptionList(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful()) {
                        MeshModel model = this.getMeshModel(node, status.getElementAddress(), status.getModelIdentifier());
                        if (model != null) {
                            model.updateSubscriptionAddressesList(status.getSubscriptionAddresses());
                        }
                        this.createGroups(status.getSubscriptionAddresses());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32812) {
                    ConfigVendorModelSubscriptionList status = new ConfigVendorModelSubscriptionList(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful()) {
                        MeshModel model = this.getMeshModel(node, status.getElementAddress(), status.getModelIdentifier());
                        if (model != null) {
                            model.updateSubscriptionAddressesList(status.getSubscriptionAddresses());
                        }
                        this.createGroups(status.getSubscriptionAddresses());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32828) {
                    MeshModel model;
                    ConfigHeartbeatSubscriptionStatus status = new ConfigHeartbeatSubscriptionStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful() && (model = this.getMeshModel(node, message.getSrc(), 0)) != null) {
                        ((ConfigurationServerModel)model).setHeartbeatSubscription(!MeshAddress.isValidUnassignedAddress(status.getHeartbeatSubscription().getSrc()) || !MeshAddress.isValidUnassignedAddress(status.getHeartbeatSubscription().getDst()) ? status.getHeartbeatSubscription() : null);
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32840) {
                    ConfigNodeIdentityStatus status = new ConfigNodeIdentityStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        node.nodeIdentityState = status.getNodeIdentityState();
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32842) {
                    ConfigNodeResetStatus status = new ConfigNodeResetStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        this.mInternalTransportCallbacks.onMeshNodeReset(node);
                    }
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32805) {
                    ConfigNetworkTransmitStatus status = new ConfigNetworkTransmitStatus(message);
                    NetworkTransmitSettings networkTransmitSettings = new NetworkTransmitSettings(status.getNetworkTransmitCount(), status.getNetworkTransmitIntervalSteps());
                    node.setNetworkTransmitSettings(networkTransmitSettings);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32808) {
                    ConfigRelayStatus status = new ConfigRelayStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        RelaySettings relaySettings = new RelaySettings(status.getRelayRetransmitCount(), status.getRelayRetransmitIntervalSteps());
                        node.setRelaySettings(relaySettings);
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32779) {
                    ConfigBeaconStatus status = new ConfigBeaconStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        node.setSecureNetworkBeaconSupported(status.isEnable());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32785) {
                    ConfigFriendStatus status = new ConfigFriendStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        node.getNodeFeatures().setFriend(status.isEnable() ? 1 : 0);
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32791) {
                    ConfigKeyRefreshPhaseStatus status = new ConfigKeyRefreshPhaseStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32788) {
                    ConfigProxyStatus status = new ConfigProxyStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32814) {
                    ConfigLowPowerNodePollTimeoutStatus status = new ConfigLowPowerNodePollTimeoutStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 33284) {
                    GenericOnOffStatus status = new GenericOnOffStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 33288) {
                    GenericLevelStatus genericLevelStatus = new GenericLevelStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(genericLevelStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), genericLevelStatus);
                    break;
                }
                if (message.getOpCode() == 33358) {
                    LightLightnessStatus lightLightnessStatus = new LightLightnessStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(lightLightnessStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), lightLightnessStatus);
                    break;
                }
                if (message.getOpCode() == 33376) {
                    LightCtlStatus lightCtlStatus = new LightCtlStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(lightCtlStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), lightCtlStatus);
                    break;
                }
                if (message.getOpCode() == 33400) {
                    LightHslStatus lightHslStatus = new LightHslStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(lightHslStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), lightHslStatus);
                    break;
                }
                if (message.getOpCode() == 33428) {
                    LightLCModeStatus lightLcModeStatus = new LightLCModeStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(lightLcModeStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), lightLcModeStatus);
                    break;
                }
                if (message.getOpCode() == 33432) {
                    LightLCOccupancyModeStatus lightLcOccupancyModeStatus = new LightLCOccupancyModeStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(lightLcOccupancyModeStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), lightLcOccupancyModeStatus);
                    break;
                }
                if (message.getOpCode() == 33436) {
                    LightLCLightOnOffStatus lightLcLightOnOffStatus = new LightLCLightOnOffStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(lightLcLightOnOffStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), lightLcLightOnOffStatus);
                    break;
                }
                if (message.getOpCode() == 100) {
                    LightLCPropertyStatus status = new LightLCPropertyStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 33349) {
                    if (this.mMeshMessage instanceof SceneStore) {
                        SceneRegisterStatus status = new SceneRegisterStatus(message);
                        this.storeScene(node, status);
                        this.mInternalTransportCallbacks.updateMeshNetwork(status);
                        this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                        break;
                    }
                    if (this.mMeshMessage instanceof SceneRecall) {
                        SceneStatus status = new SceneStatus(message);
                        this.storeScene(node, status);
                        this.mInternalTransportCallbacks.updateMeshNetwork(status);
                        this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                        break;
                    }
                    if (!(this.mMeshMessage instanceof SceneDelete)) break;
                    SceneRegisterStatus status = new SceneRegisterStatus(message);
                    this.deleteScene(node, status);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 33354) {
                    SchedulerStatus schedulerStatus = new SchedulerStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(schedulerStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), schedulerStatus);
                    break;
                }
                if (message.getOpCode() == 33341) {
                    TimeZoneStatus timeZoneStatus = new TimeZoneStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(timeZoneStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), timeZoneStatus);
                    break;
                }
                if (message.getOpCode() == 33296) {
                    GenericDefaultTransitionTimeStatus genericDefaultTransitionTimeStatus = new GenericDefaultTransitionTimeStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(genericDefaultTransitionTimeStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), genericDefaultTransitionTimeStatus);
                    break;
                }
                this.handleUnknownPdu(message);
                break;
            }
            case 3: {
                if (this.mMeshMessage instanceof VendorModelMessageAcked) {
                    VendorModelMessageAcked vendorModelMessageAcked = (VendorModelMessageAcked)this.mMeshMessage;
                    VendorModelMessageStatus status = new VendorModelMessageStatus(message, vendorModelMessageAcked.getModelIdentifier());
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    Log.v((String)TAG, (String)("Vendor model Access PDU Received: " + MeshParserUtils.bytesToHex(message.getAccessPdu(), false)));
                    break;
                }
                if (this.mMeshMessage instanceof VendorModelMessageUnacked) {
                    VendorModelMessageUnacked vendorModelMessageUnacked = (VendorModelMessageUnacked)this.mMeshMessage;
                    VendorModelMessageStatus status = new VendorModelMessageStatus(message, vendorModelMessageUnacked.getModelIdentifier());
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                this.handleUnknownPdu(message);
            }
        }
    }

    private void handleUnknownPdu(AccessMessage message) {
        Log.v((String)TAG, (String)("Unknown Access PDU Received: " + MeshParserUtils.bytesToHex(message.getAccessPdu(), false)));
        this.mMeshStatusCallbacks.onUnknownPduReceived(message.getSrc(), message.getAccessPdu());
    }

    private void parseControlMessage(ControlMessage controlMessage) {
        int segmentCount = this.message.getNetworkLayerPdu().size();
        if (controlMessage.getPduType() == 0) {
            TransportControlMessage transportControlMessage = controlMessage.getTransportControlMessage();
            if (transportControlMessage.getState() == TransportControlMessage.TransportControlMessageState.LOWER_TRANSPORT_BLOCK_ACKNOWLEDGEMENT) {
                Log.v((String)TAG, (String)("Acknowledgement payload: " + MeshParserUtils.bytesToHex(controlMessage.getTransportControlPdu(), false)));
                ArrayList<Integer> retransmitPduIndexes = BlockAcknowledgementMessage.getSegmentsToBeRetransmitted(controlMessage.getTransportControlPdu(), segmentCount);
                this.mMeshStatusCallbacks.onBlockAcknowledgementReceived(controlMessage.getSrc(), controlMessage);
                this.executeResend(retransmitPduIndexes);
            } else {
                Log.v((String)TAG, (String)"Unexpected control message received, ignoring message");
                this.mMeshStatusCallbacks.onUnknownPduReceived(controlMessage.getSrc(), controlMessage.getTransportControlPdu());
            }
        } else if (controlMessage.getPduType() == 2 && controlMessage.getOpCode() == 3) {
            ProxyConfigFilterStatus status = new ProxyConfigFilterStatus(controlMessage);
            if (this.mMeshMessage instanceof ProxyConfigSetFilterType) {
                ProxyFilter filter = new ProxyFilter(status.getFilterType());
                this.mInternalTransportCallbacks.setProxyFilter(filter);
                this.mInternalTransportCallbacks.updateMeshNetwork(status);
                this.mMeshStatusCallbacks.onMeshMessageReceived(controlMessage.getSrc(), status);
            } else if (this.mMeshMessage instanceof ProxyConfigAddAddressToFilter) {
                ProxyFilter filter = this.updateProxyFilter(this.mInternalTransportCallbacks.getProxyFilter(), status.getFilterType());
                ProxyConfigAddAddressToFilter addAddressToFilter = (ProxyConfigAddAddressToFilter)this.mMeshMessage;
                for (AddressArray addressArray : addAddressToFilter.getAddresses()) {
                    filter.addAddress(addressArray);
                }
                this.mInternalTransportCallbacks.setProxyFilter(filter);
                this.mInternalTransportCallbacks.updateMeshNetwork(status);
                this.mMeshStatusCallbacks.onMeshMessageReceived(controlMessage.getSrc(), status);
            } else if (this.mMeshMessage instanceof ProxyConfigRemoveAddressFromFilter) {
                ProxyFilter filter = this.updateProxyFilter(this.mInternalTransportCallbacks.getProxyFilter(), status.getFilterType());
                ProxyConfigRemoveAddressFromFilter removeAddressFromFilter = (ProxyConfigRemoveAddressFromFilter)this.mMeshMessage;
                for (AddressArray addressArray : removeAddressFromFilter.getAddresses()) {
                    filter.removeAddress(addressArray);
                }
                this.mInternalTransportCallbacks.setProxyFilter(filter);
                this.mInternalTransportCallbacks.updateMeshNetwork(status);
                this.mMeshStatusCallbacks.onMeshMessageReceived(controlMessage.getSrc(), status);
            }
        }
    }

    private ProxyFilter updateProxyFilter(ProxyFilter currentFilter, ProxyFilterType filterType) {
        if (currentFilter != null && currentFilter.getFilterType().getType() == filterType.getType()) {
            return currentFilter;
        }
        return new ProxyFilter(filterType);
    }

    private boolean isReceivedViaProxyFilter(@NonNull Message message) {
        ProxyFilter filter = this.mInternalTransportCallbacks.getProxyFilter();
        if (filter != null && !filter.getAddresses().isEmpty()) {
            if (filter.getFilterType().getType() == 0) {
                return this.filterAddressMatches(filter, message.getDst());
            }
            return !this.filterAddressMatches(filter, message.getDst());
        }
        return false;
    }

    private boolean filterAddressMatches(@NonNull ProxyFilter filter, int dst) {
        for (AddressArray addressArray : filter.getAddresses()) {
            int address = MeshParserUtils.unsignedBytesToInt(addressArray.getAddress()[1], addressArray.getAddress()[0]);
            if (address != dst) continue;
            return true;
        }
        return false;
    }

    private void createGroups(@NonNull List<Integer> subscriptionAddresses) {
        MeshNetwork network = this.mInternalTransportCallbacks.getMeshNetwork();
        for (Integer groupAddress : subscriptionAddresses) {
            Group group;
            if (groupAddress >= 65532 || (group = network.getGroup(groupAddress)) != null) continue;
            group = new Group(groupAddress, network.getMeshUUID());
            group.setName("Unknown Group");
            this.mInternalTransportCallbacks.addGroup(group);
        }
    }

    private MeshModel getMeshModel(ProvisionedMeshNode node, int src, int modelId) {
        Element element = node.getElements().get(src);
        if (element != null) {
            return element.getMeshModels().get(modelId);
        }
        return null;
    }

    private void storeScene(ProvisionedMeshNode node, SceneRegisterStatus status) {
        SceneServer sceneServer;
        if (status.isSuccessful() && (sceneServer = (SceneServer)this.getMeshModel(node, status.getSrc(), 4611)) != null) {
            this.mInternalTransportCallbacks.storeScene(status.getSrc(), status.getCurrentScene(), status.getSceneList());
            if (!sceneServer.sceneNumbers.contains(status.getCurrentScene())) {
                sceneServer.sceneNumbers.add(status.getCurrentScene());
            }
            sceneServer.currentScene = status.getCurrentScene();
        }
    }

    private void storeScene(ProvisionedMeshNode node, SceneStatus status) {
        SceneServer sceneServer;
        if (status.isSuccessful() && (sceneServer = (SceneServer)this.getMeshModel(node, status.getSrc(), 4611)) != null) {
            sceneServer.currentScene = status.getCurrentScene();
        }
    }

    private void deleteScene(ProvisionedMeshNode node, SceneRegisterStatus status) {
        SceneServer sceneServer;
        if (status.isSuccessful() && (sceneServer = (SceneServer)this.getMeshModel(node, status.getSrc(), 4611)) != null) {
            int deletedScene = ((SceneDelete)this.mMeshMessage).getSceneNumber();
            this.mInternalTransportCallbacks.deleteScene(status.getSrc(), deletedScene, status.getSceneList());
            if (sceneServer.sceneNumbers.contains(deletedScene)) {
                sceneServer.sceneNumbers.remove((Object)deletedScene);
            }
        }
    }
}

