/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class GenericPropertyGet
extends ApplicationMessage {
    private final int opCode;
    private final short propertyId;

    public GenericPropertyGet(@NonNull int opcode, @NonNull ApplicationKey appKey, short propertyId) {
        super(appKey);
        this.opCode = opcode;
        this.propertyId = propertyId;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return this.opCode;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        this.mParameters = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(this.propertyId).array();
    }

    public short getPropertyId() {
        return this.propertyId;
    }
}

