/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.MeshModel;

public final class InternalElementListDeserializer
implements JsonSerializer<List<Element>>,
JsonDeserializer<List<Element>>,
Type {
    public List<Element> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Element element;
                JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
                int location = Integer.parseInt(jsonObject.get("location").getAsString(), 16);
                List<MeshModel> models = this.deserializeModels(context, jsonObject);
                if (jsonObject.has("name")) {
                    String name = jsonObject.get("name").getAsString();
                    element = new Element(location, this.populateModels(models));
                    element.setName(name);
                } else {
                    element = new Element(location, this.populateModels(models));
                }
                elements.add(element);
            }
        }
        return elements;
    }

    public JsonElement serialize(List<Element> elements, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        int i = 0;
        for (Element element : elements) {
            JsonObject elementJson = new JsonObject();
            elementJson.addProperty("name", element.getName());
            elementJson.addProperty("index", (Number)i);
            elementJson.addProperty("location", String.format(Locale.US, "%04X", element.getLocationDescriptor()));
            elementJson.add("models", this.serializeModels(context, element.getMeshModels()));
            jsonArray.add((JsonElement)elementJson);
            ++i;
        }
        return jsonArray;
    }

    private JsonElement serializeModels(JsonSerializationContext context, Map<Integer, MeshModel> meshModels) {
        Type meshModelList = new TypeToken<List<MeshModel>>(){}.getType();
        return context.serialize(this.populateModels(meshModels), meshModelList);
    }

    private List<MeshModel> deserializeModels(JsonDeserializationContext context, JsonObject json) {
        Type modelsList = new TypeToken<List<MeshModel>>(){}.getType();
        return (List)context.deserialize((JsonElement)json.getAsJsonArray("models"), modelsList);
    }

    private Map<Integer, MeshModel> populateModels(List<MeshModel> models) {
        LinkedHashMap<Integer, MeshModel> meshModels = new LinkedHashMap<Integer, MeshModel>();
        for (MeshModel model : models) {
            meshModels.put(model.getModelId(), model);
        }
        return meshModels;
    }

    private List<MeshModel> populateModels(Map<Integer, MeshModel> meshModelMap) {
        ArrayList<MeshModel> meshModels = new ArrayList<MeshModel>();
        for (Map.Entry<Integer, MeshModel> modelEntry : meshModelMap.entrySet()) {
            meshModels.add(modelEntry.getValue());
        }
        return meshModels;
    }
}

