/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class LightCtlSet
extends ApplicationMessage {
    private static final String TAG = LightCtlSet.class.getSimpleName();
    private static final int OP_CODE = 33374;
    private static final int LIGHT_CTL_SET_TRANSITION_PARAMS_LENGTH = 9;
    private static final int LIGHT_CTL_SET_PARAMS_LENGTH = 7;
    private final Integer mTransitionSteps;
    private final Integer mTransitionResolution;
    private final Integer mDelay;
    private final int mLightness;
    private final int mTemperature;
    private final int mDeltaUv;
    private final int tId;

    public LightCtlSet(@NonNull ApplicationKey appKey, int lightLightness, int lightTemperature, int lightDeltaUv, int tId) throws IllegalArgumentException {
        this(appKey, null, null, null, lightLightness, lightTemperature, lightDeltaUv, tId);
    }

    public LightCtlSet(@NonNull ApplicationKey appKey, @Nullable Integer transitionSteps, @Nullable Integer transitionResolution, @Nullable Integer delay, int lightLightness, int lightTemperature, int lightDeltaUv, int tId) throws IllegalArgumentException {
        super(appKey);
        this.mTransitionSteps = transitionSteps;
        this.mTransitionResolution = transitionResolution;
        this.mDelay = delay;
        if (lightLightness < 0 || lightLightness > 65535) {
            throw new IllegalArgumentException("Light lightness value must be between 0 to 0xFFFF");
        }
        if (lightTemperature < 800 || lightTemperature > 20000) {
            throw new IllegalArgumentException("Light temperature value must be between 0x0320 to 0x4E20");
        }
        if (lightDeltaUv < Short.MIN_VALUE || lightDeltaUv > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Light delta uv value must be between 0x8000 to 0x7FFF or 0");
        }
        this.mLightness = lightLightness;
        this.mTemperature = lightTemperature;
        this.mDeltaUv = lightDeltaUv;
        this.tId = tId;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33374;
    }

    @Override
    void assembleMessageParameters() {
        ByteBuffer paramsBuffer;
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        Log.v((String)TAG, (String)("Lightness: " + this.mLightness));
        Log.v((String)TAG, (String)("Temperature: " + this.mTemperature));
        Log.v((String)TAG, (String)("Delta UV: " + this.mDeltaUv));
        Log.v((String)TAG, (String)("TID: " + (byte)this.tId));
        if (this.mTransitionSteps == null || this.mTransitionResolution == null || this.mDelay == null) {
            paramsBuffer = ByteBuffer.allocate(7).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mLightness);
            paramsBuffer.putShort((short)this.mTemperature);
            paramsBuffer.putShort((short)this.mDeltaUv);
            paramsBuffer.put((byte)this.tId);
        } else {
            Log.v((String)TAG, (String)("Transition steps: " + this.mTransitionSteps));
            Log.v((String)TAG, (String)("Transition step resolution: " + this.mTransitionResolution));
            paramsBuffer = ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mLightness);
            paramsBuffer.putShort((short)this.mTemperature);
            paramsBuffer.putShort((short)this.mDeltaUv);
            paramsBuffer.put((byte)this.tId);
            paramsBuffer.put((byte)(this.mTransitionResolution << 6 | this.mTransitionSteps));
            int delay = this.mDelay;
            paramsBuffer.put((byte)delay);
        }
        this.mParameters = paramsBuffer.array();
    }
}

