/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.Provisioner;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ControlMessage;
import no.nordicsemi.android.mesh.transport.LowerTransportLayer;
import no.nordicsemi.android.mesh.transport.Message;
import no.nordicsemi.android.mesh.transport.NetworkLayerCallbacks;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.ExtendedInvalidCipherTextException;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.SecureUtils;
import org.spongycastle.crypto.InvalidCipherTextException;

abstract class NetworkLayer
extends LowerTransportLayer {
    private static final String TAG = NetworkLayer.class.getSimpleName();
    NetworkLayerCallbacks mNetworkLayerCallbacks;
    private SparseArray<byte[]> segmentedAccessMessagesMessages;
    private SparseArray<byte[]> segmentedControlMessagesMessages;

    NetworkLayer() {
    }

    abstract void setNetworkLayerCallbacks(@NonNull NetworkLayerCallbacks var1);

    @Override
    protected final void createMeshMessage(@NonNull Message message) {
        if (message instanceof AccessMessage) {
            super.createMeshMessage(message);
        } else {
            super.createMeshMessage(message);
        }
        this.createNetworkLayerPDU(message);
    }

    @Override
    protected final void createVendorMeshMessage(@NonNull Message message) {
        if (message instanceof AccessMessage) {
            super.createVendorMeshMessage(message);
        } else {
            super.createVendorMeshMessage(message);
        }
        this.createNetworkLayerPDU(message);
    }

    @Override
    public final Message createNetworkLayerPDU(@NonNull Message message) {
        SecureUtils.K2Output k2Output = this.getK2Output(message);
        byte nid = k2Output.getNid();
        byte[] encryptionKey = k2Output.getEncryptionKey();
        Log.v((String)TAG, (String)("Encryption key: " + MeshParserUtils.bytesToHex(encryptionKey, false)));
        byte[] privacyKey = k2Output.getPrivacyKey();
        Log.v((String)TAG, (String)("Privacy key: " + MeshParserUtils.bytesToHex(privacyKey, false)));
        int ctl = message.getCtl();
        int ttl = message.getTtl();
        int ivi = message.getIvIndex()[3] & 1;
        byte iviNID = (byte)(ivi << 7 | nid & 0x7F);
        byte ctlTTL = (byte)(ctl << 7 | ttl & 0x7F);
        int src = message.getSrc();
        SparseArray encryptedPduPayload = new SparseArray();
        ArrayList<byte[]> sequenceNumbers = new ArrayList<byte[]>();
        ProvisionedMeshNode node = this.mUpperTransportLayerCallbacks.getNode(message.getSrc());
        int pduType = message.getPduType();
        switch (message.getPduType()) {
            case 0: {
                byte[] lowerTransportPdu;
                int i;
                SparseArray<byte[]> lowerTransportPduMap = message instanceof AccessMessage ? ((AccessMessage)message).getLowerTransportAccessPdu() : ((ControlMessage)message).getLowerTransportControlPdu();
                for (i = 0; i < lowerTransportPduMap.size(); ++i) {
                    lowerTransportPdu = (byte[])lowerTransportPduMap.get(i);
                    if (i != 0) {
                        node.setSequenceNumber(MeshParserUtils.convert24BitsToInt(message.getSequenceNumber()));
                        byte[] sequenceNumber = MeshParserUtils.getSequenceNumberBytes(node.incrementSequenceNumber());
                        message.setSequenceNumber(sequenceNumber);
                    }
                    sequenceNumbers.add(message.getSequenceNumber());
                    Log.v((String)TAG, (String)("Sequence Number: " + MeshParserUtils.bytesToHex((byte[])sequenceNumbers.get(i), false)));
                    byte[] nonce = NetworkLayer.createNetworkNonce(ctlTTL, (byte[])sequenceNumbers.get(i), src, message.getIvIndex());
                    byte[] encryptedPayload = this.encryptPdu(lowerTransportPdu, encryptionKey, nonce, message.getDst(), SecureUtils.getNetMicLength(message.getCtl()));
                    encryptedPduPayload.put(i, (Object)encryptedPayload);
                    Log.v((String)TAG, (String)("Encrypted Network payload: " + MeshParserUtils.bytesToHex(encryptedPayload, false)));
                }
                break;
            }
            case 2: {
                byte[] lowerTransportPdu;
                int i;
                SparseArray<byte[]> lowerTransportPduMap = ((ControlMessage)message).getLowerTransportControlPdu();
                for (i = 0; i < lowerTransportPduMap.size(); ++i) {
                    lowerTransportPdu = (byte[])lowerTransportPduMap.get(i);
                    byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(node.incrementSequenceNumber());
                    message.setSequenceNumber(sequenceNum);
                    sequenceNumbers.add(message.getSequenceNumber());
                    byte[] nonce = NetworkLayer.createProxyNonce(message.getSequenceNumber(), src, message.getIvIndex());
                    byte[] encryptedPayload = this.encryptPdu(lowerTransportPdu, encryptionKey, nonce, message.getDst(), SecureUtils.getNetMicLength(message.getCtl()));
                    encryptedPduPayload.put(i, (Object)encryptedPayload);
                    Log.v((String)TAG, (String)("Encrypted Network payload: " + MeshParserUtils.bytesToHex(encryptedPayload, false)));
                }
                break;
            }
        }
        SparseArray pduArray = new SparseArray();
        for (int i = 0; i < encryptedPduPayload.size(); ++i) {
            byte[] encryptedPayload = (byte[])encryptedPduPayload.get(i);
            byte[] privacyRandom = NetworkLayer.createPrivacyRandom(encryptedPayload);
            byte[] pecb = NetworkLayer.createPECB(message.getIvIndex(), privacyRandom, privacyKey);
            byte[] header = this.obfuscateNetworkHeader(ctlTTL, (byte[])sequenceNumbers.get(i), src, pecb);
            byte[] pdu = ByteBuffer.allocate(2 + header.length + encryptedPayload.length).order(ByteOrder.BIG_ENDIAN).put((byte)pduType).put(iviNID).put(header).put(encryptedPayload).array();
            pduArray.put(i, (Object)pdu);
            message.setNetworkLayerPdu((SparseArray<byte[]>)pduArray);
        }
        return message;
    }

    @VisibleForTesting(otherwise=4)
    final Message createRetransmitNetworkLayerPDU(@NonNull Message message, int segment) {
        SecureUtils.K2Output k2Output = this.getK2Output(message);
        byte nid = k2Output.getNid();
        byte[] encryptionKey = k2Output.getEncryptionKey();
        Log.v((String)TAG, (String)("Encryption key: " + MeshParserUtils.bytesToHex(encryptionKey, false)));
        byte[] privacyKey = k2Output.getPrivacyKey();
        Log.v((String)TAG, (String)("Privacy key: " + MeshParserUtils.bytesToHex(privacyKey, false)));
        int ctl = message.getCtl();
        int ttl = message.getTtl();
        int ivi = message.getIvIndex()[3] & 1;
        byte iviNID = (byte)(ivi << 7 | nid & 0x7F);
        byte ctlTTL = (byte)(ctl << 7 | ttl & 0x7F);
        int src = message.getSrc();
        SparseArray<byte[]> lowerTransportPduMap = message instanceof AccessMessage ? ((AccessMessage)message).getLowerTransportAccessPdu() : ((ControlMessage)message).getLowerTransportControlPdu();
        byte[] encryptedNetworkPayload = null;
        int pduType = message.getPduType();
        if (message.getPduType() == 0) {
            ProvisionedMeshNode node = this.mUpperTransportLayerCallbacks.getNode(message.getSrc());
            byte[] lowerTransportPdu = (byte[])lowerTransportPduMap.get(segment);
            node.setSequenceNumber(MeshParserUtils.convert24BitsToInt(message.getSequenceNumber()));
            byte[] sequenceNum = MeshParserUtils.getSequenceNumberBytes(node.incrementSequenceNumber());
            message.setSequenceNumber(sequenceNum);
            Log.v((String)TAG, (String)("Sequence Number: " + MeshParserUtils.bytesToHex(sequenceNum, false)));
            byte[] nonce = NetworkLayer.createNetworkNonce(ctlTTL, sequenceNum, src, message.getIvIndex());
            encryptedNetworkPayload = this.encryptPdu(lowerTransportPdu, encryptionKey, nonce, message.getDst(), SecureUtils.getNetMicLength(message.getCtl()));
            if (encryptedNetworkPayload == null) {
                return null;
            }
            Log.v((String)TAG, (String)("Encrypted Network payload: " + MeshParserUtils.bytesToHex(encryptedNetworkPayload, false)));
        }
        if (encryptedNetworkPayload == null) {
            return null;
        }
        byte[] privacyRandom = NetworkLayer.createPrivacyRandom(encryptedNetworkPayload);
        byte[] pecb = NetworkLayer.createPECB(message.getIvIndex(), privacyRandom, privacyKey);
        byte[] header = this.obfuscateNetworkHeader(ctlTTL, message.getSequenceNumber(), src, pecb);
        byte[] pdu = ByteBuffer.allocate(2 + header.length + encryptedNetworkPayload.length).order(ByteOrder.BIG_ENDIAN).put((byte)pduType).put(iviNID).put(header).put(encryptedNetworkPayload).array();
        message.getNetworkLayerPdu().put(segment, (Object)pdu);
        return message;
    }

    final Message parseMeshMessage(@NonNull NetworkKey key, @NonNull ProvisionedMeshNode node, @NonNull byte[] data, @NonNull byte[] networkHeader, @NonNull byte[] decryptedNetworkPayload, int ivIndex, @NonNull byte[] sequenceNumber) throws ExtendedInvalidCipherTextException {
        this.mMeshNode = node;
        Provisioner provisioner = this.mNetworkLayerCallbacks.getProvisioner();
        byte ctlTtl = networkHeader[0];
        int ctl = ctlTtl >> 7 & 1;
        int ttl = ctlTtl & 0x7F;
        Log.v((String)TAG, (String)("TTL for received message: " + ttl));
        int src = MeshParserUtils.unsignedBytesToInt(networkHeader[5], networkHeader[4]);
        if (ctl == 1) {
            return this.parseControlMessage(key, provisioner.getProvisionerAddress(), data, networkHeader, decryptedNetworkPayload, src, sequenceNumber);
        }
        return this.parseAccessMessage(key, data, networkHeader, decryptedNetworkPayload, src, sequenceNumber, ivIndex);
    }

    @VisibleForTesting
    private AccessMessage parseAccessMessage(@NonNull NetworkKey key, @NonNull byte[] data, @NonNull byte[] networkHeader, @NonNull byte[] decryptedNetworkPayload, int src, @NonNull byte[] sequenceNumber, int ivIndex) throws ExtendedInvalidCipherTextException {
        try {
            int receivedTtl = networkHeader[0] & 0x7F;
            int dst = MeshParserUtils.unsignedBytesToInt(decryptedNetworkPayload[1], decryptedNetworkPayload[0]);
            Log.v((String)TAG, (String)("Dst: " + MeshAddress.formatAddress(dst, true)));
            if (this.isSegmentedMessage(decryptedNetworkPayload[2])) {
                Log.v((String)TAG, (String)("Received a segmented access message from: " + MeshAddress.formatAddress(src, false)));
                if (!this.mMeshNode.hasUnicastAddress(src)) {
                    Log.v((String)TAG, (String)"Segment received is from a different src than the one we are processing, let's drop it");
                    return null;
                }
                if (this.segmentedAccessMessagesMessages == null) {
                    this.segmentedAccessMessagesMessages = new SparseArray();
                    this.segmentedAccessMessagesMessages.put(0, (Object)data);
                } else {
                    int k = this.segmentedAccessMessagesMessages.size();
                    this.segmentedAccessMessagesMessages.put(k, (Object)data);
                }
                byte[] pdu = ByteBuffer.allocate(2 + networkHeader.length + decryptedNetworkPayload.length).order(ByteOrder.BIG_ENDIAN).put(data, 0, 2).put(networkHeader).put(decryptedNetworkPayload).array();
                int ttl = receivedTtl == 0 ? receivedTtl : this.mNetworkLayerCallbacks.getProvisioner().getGlobalTtl();
                AccessMessage message = this.parseSegmentedAccessLowerTransportPDU(ttl, pdu, ivIndex, sequenceNumber);
                if (message != null) {
                    SparseArray segmentedMessages = this.segmentedAccessMessagesMessages.clone();
                    this.segmentedAccessMessagesMessages = null;
                    message.setNetworkKey(key);
                    message.setIvIndex(MeshParserUtils.intToBytes(ivIndex));
                    message.setNetworkLayerPdu((SparseArray<byte[]>)segmentedMessages);
                    message.setTtl(receivedTtl);
                    message.setSrc(src);
                    message.setDst(dst);
                    this.parseUpperTransportPDU(message);
                    this.parseAccessLayerPDU(message);
                }
                return message;
            }
            byte[] pdu = ByteBuffer.allocate(2 + networkHeader.length + decryptedNetworkPayload.length).order(ByteOrder.BIG_ENDIAN).put(data, 0, 2).put(networkHeader).put(decryptedNetworkPayload).array();
            AccessMessage message = this.parseUnsegmentedAccessLowerTransportPDU(pdu, ivIndex, sequenceNumber);
            if (message == null) {
                return null;
            }
            message.setNetworkKey(key);
            message.setIvIndex(MeshParserUtils.intToBytes(ivIndex));
            SparseArray pduArray = new SparseArray();
            pduArray.put(0, (Object)data);
            message.setNetworkLayerPdu((SparseArray<byte[]>)pduArray);
            message.setTtl(receivedTtl);
            message.setSrc(src);
            message.setDst(dst);
            message.setSequenceNumber(sequenceNumber);
            this.parseUpperTransportPDU(message);
            this.parseAccessLayerPDU(message);
            return message;
        }
        catch (InvalidCipherTextException ex) {
            throw new ExtendedInvalidCipherTextException(ex.getMessage(), ex.getCause(), TAG);
        }
    }

    private ControlMessage parseControlMessage(@NonNull NetworkKey key, @Nullable Integer provisionerAddress, @NonNull byte[] data, @NonNull byte[] networkHeader, @NonNull byte[] decryptedNetworkPayload, int src, @NonNull byte[] sequenceNumber) throws ExtendedInvalidCipherTextException {
        try {
            int ttl = networkHeader[0] & 0x7F;
            int dst = MeshParserUtils.unsignedBytesToInt(decryptedNetworkPayload[1], decryptedNetworkPayload[0]);
            byte[] decryptedProxyPdu = ByteBuffer.allocate(2 + networkHeader.length + decryptedNetworkPayload.length).order(ByteOrder.BIG_ENDIAN).put(data, 0, 2).put(networkHeader).put(decryptedNetworkPayload).array();
            byte pduType = data[0];
            switch (pduType) {
                case 0: {
                    if (provisionerAddress == null) {
                        return null;
                    }
                    if (provisionerAddress != dst) {
                        Log.v((String)TAG, (String)"Received a control message that was not directed to us, so we drop it");
                        return null;
                    }
                    if (this.isSegmentedMessage(decryptedNetworkPayload[2])) {
                        return this.parseSegmentedControlMessage(key, data, decryptedProxyPdu, ttl, src, dst);
                    }
                    return this.parseUnsegmentedControlMessage(key, data, decryptedProxyPdu, ttl, src, dst, sequenceNumber);
                }
                case 2: {
                    return this.parseUnsegmentedControlMessage(key, data, decryptedProxyPdu, ttl, src, dst, sequenceNumber);
                }
            }
            return null;
        }
        catch (InvalidCipherTextException ex) {
            throw new ExtendedInvalidCipherTextException(ex.getMessage(), ex.getCause(), TAG);
        }
    }

    private ControlMessage parseUnsegmentedControlMessage(@NonNull NetworkKey key, @NonNull byte[] data, @NonNull byte[] decryptedProxyPdu, int ttl, int src, int dst, @NonNull byte[] sequenceNumber) throws ExtendedInvalidCipherTextException {
        ControlMessage message = new ControlMessage();
        message.setNetworkKey(key);
        message.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
        SparseArray proxyPduArray = new SparseArray();
        proxyPduArray.put(0, (Object)data);
        message.setNetworkLayerPdu((SparseArray<byte[]>)proxyPduArray);
        message.setTtl(ttl);
        message.setSrc(src);
        message.setDst(dst);
        message.setSequenceNumber(sequenceNumber);
        message.setSegmented(false);
        this.parseUnsegmentedControlLowerTransportPDU(message, decryptedProxyPdu);
        return message;
    }

    private ControlMessage parseSegmentedControlMessage(@NonNull NetworkKey key, @NonNull byte[] data, @NonNull byte[] decryptedProxyPdu, int ttl, int src, int dst) {
        if (this.segmentedControlMessagesMessages == null) {
            this.segmentedControlMessagesMessages = new SparseArray();
            this.segmentedControlMessagesMessages.put(0, (Object)data);
        } else {
            int k = this.segmentedControlMessagesMessages.size();
            this.segmentedAccessMessagesMessages.put(k, (Object)data);
        }
        ControlMessage message = this.parseSegmentedControlLowerTransportPDU(decryptedProxyPdu);
        if (message != null) {
            SparseArray segmentedMessages = this.segmentedControlMessagesMessages.clone();
            this.segmentedControlMessagesMessages = null;
            message.setNetworkKey(key);
            message.setIvIndex(this.mUpperTransportLayerCallbacks.getIvIndex());
            message.setNetworkLayerPdu((SparseArray<byte[]>)segmentedMessages);
            message.setTtl(ttl);
            message.setSrc(src);
            message.setDst(dst);
        }
        return message;
    }

    private SecureUtils.K2Output getK2Output(Message message) {
        NetworkKey networkKey;
        if (message.getAkf() == 0) {
            networkKey = this.mNetworkLayerCallbacks.getPrimaryNetworkKey();
        } else {
            int netKeyIndex = message.getApplicationKey().getBoundNetKeyIndex();
            networkKey = this.mNetworkLayerCallbacks.getNetworkKey(netKeyIndex);
        }
        return networkKey.getTxDerivatives();
    }

    private byte[] obfuscateNetworkHeader(byte ctlTTL, @NonNull byte[] sequenceNumber, int src, @NonNull byte[] pecb) {
        ByteBuffer buffer = ByteBuffer.allocate(1 + sequenceNumber.length + 2).order(ByteOrder.BIG_ENDIAN);
        buffer.put(ctlTTL);
        buffer.put(sequenceNumber);
        buffer.putShort((short)src);
        byte[] headerBuffer = buffer.array();
        ByteBuffer bufferPECB = ByteBuffer.allocate(6);
        bufferPECB.put(pecb, 0, 6);
        byte[] obfuscated = new byte[6];
        for (int i = 0; i < 6; ++i) {
            obfuscated[i] = (byte)(headerBuffer[i] ^ pecb[i]);
        }
        return obfuscated;
    }

    static byte[] deObfuscateNetworkHeader(@NonNull byte[] pdu, @NonNull byte[] ivIndex, @NonNull byte[] privacyKey) {
        ByteBuffer obfuscatedNetworkBuffer = ByteBuffer.allocate(6);
        obfuscatedNetworkBuffer.order(ByteOrder.BIG_ENDIAN);
        obfuscatedNetworkBuffer.put(pdu, 2, 6);
        byte[] obfuscatedData = obfuscatedNetworkBuffer.array();
        ByteBuffer privacyRandomBuffer = ByteBuffer.allocate(7);
        privacyRandomBuffer.order(ByteOrder.BIG_ENDIAN);
        privacyRandomBuffer.put(pdu, 8, 7);
        byte[] privacyRandom = NetworkLayer.createPrivacyRandom(privacyRandomBuffer.array());
        byte[] pecb = NetworkLayer.createPECB(ivIndex, privacyRandom, privacyKey);
        byte[] deObfuscatedData = new byte[6];
        for (int i = 0; i < 6; ++i) {
            deObfuscatedData[i] = (byte)(obfuscatedData[i] ^ pecb[i]);
        }
        return deObfuscatedData;
    }

    private static byte[] createPrivacyRandom(@NonNull byte[] encryptedUpperTransportPDU) {
        byte[] privacyRandom = new byte[7];
        System.arraycopy(encryptedUpperTransportPDU, 0, privacyRandom, 0, privacyRandom.length);
        return privacyRandom;
    }

    private static byte[] createPECB(@NonNull byte[] ivIndex, @NonNull byte[] privacyRandom, @NonNull byte[] privacyKey) {
        ByteBuffer buffer = ByteBuffer.allocate(5 + privacyRandom.length + ivIndex.length);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.put(new byte[]{0, 0, 0, 0, 0});
        buffer.put(ivIndex);
        buffer.put(privacyRandom);
        byte[] temp = buffer.array();
        return SecureUtils.encryptWithAES(temp, privacyKey);
    }

    static byte[] createNetworkNonce(byte ctlTTL, @NonNull byte[] sequenceNumber, int src, @NonNull byte[] ivIndex) {
        ByteBuffer networkNonce = ByteBuffer.allocate(13);
        networkNonce.put((byte)0);
        networkNonce.put(ctlTTL);
        networkNonce.put(sequenceNumber);
        networkNonce.putShort((short)src);
        networkNonce.put(new byte[]{0, 0});
        networkNonce.put(ivIndex);
        return networkNonce.array();
    }

    static byte[] createProxyNonce(@NonNull byte[] sequenceNumber, int src, @NonNull byte[] ivIndex) {
        ByteBuffer applicationNonceBuffer = ByteBuffer.allocate(13);
        applicationNonceBuffer.put((byte)3);
        applicationNonceBuffer.put((byte)0);
        applicationNonceBuffer.put(sequenceNumber);
        applicationNonceBuffer.putShort((short)src);
        applicationNonceBuffer.put(new byte[]{0, 0});
        applicationNonceBuffer.put(ivIndex);
        return applicationNonceBuffer.array();
    }

    private byte[] encryptPdu(@NonNull byte[] lowerTransportPdu, @NonNull byte[] encryptionKey, @NonNull byte[] nonce, int dst, int micLength) {
        byte[] unencryptedNetworkPayload = ByteBuffer.allocate(2 + lowerTransportPdu.length).order(ByteOrder.BIG_ENDIAN).putShort((short)dst).put(lowerTransportPdu).array();
        return SecureUtils.encryptCCM(unencryptedNetworkPayload, encryptionKey, nonce, micLength);
    }
}

