/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import no.nordicsemi.android.mesh.Features;
import no.nordicsemi.android.mesh.NodeKey;
import no.nordicsemi.android.mesh.models.ConfigurationServerModel;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.CompositionDataParser;
import no.nordicsemi.android.mesh.utils.Heartbeat;
import no.nordicsemi.android.mesh.utils.HeartbeatPublication;
import no.nordicsemi.android.mesh.utils.HeartbeatSubscription;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.NetworkTransmitSettings;
import no.nordicsemi.android.mesh.utils.RelaySettings;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class NodeDeserializer
implements JsonSerializer<List<ProvisionedMeshNode>>,
JsonDeserializer<List<ProvisionedMeshNode>> {
    public List<ProvisionedMeshNode> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<ProvisionedMeshNode> nodes = new ArrayList<ProvisionedMeshNode>();
        JsonArray jsonArray = json.getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            int steps;
            int interval;
            int count;
            int unicastAddress;
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            ProvisionedMeshNode node = new ProvisionedMeshNode();
            String uuid = MeshParserUtils.formatUuid(jsonObject.get("UUID").getAsString());
            if (uuid == null) {
                throw new IllegalArgumentException("Invalid Mesh Provisioning/Configuration Database, invalid node UUID.");
            }
            node.uuid = uuid;
            if (jsonObject.has("deviceKey") && jsonObject.get("deviceKey") != null) {
                node.deviceKey = MeshParserUtils.toByteArray(jsonObject.get("deviceKey").getAsString());
            }
            node.unicastAddress = unicastAddress = Integer.parseInt(jsonObject.get("unicastAddress").getAsString(), 16);
            String jsonSecurity = jsonObject.get("security").getAsString();
            boolean security = jsonSecurity.equalsIgnoreCase("secure") || jsonSecurity.equalsIgnoreCase("high");
            node.security = security ? 1 : 0;
            node.mAddedNetKeys = this.deserializeAddedIndexes(jsonObject.get("netKeys").getAsJsonArray());
            node.isConfigured = jsonObject.get("configComplete").getAsBoolean();
            if (jsonObject.has("cid")) {
                node.companyIdentifier = Integer.parseInt(jsonObject.get("cid").getAsString(), 16);
            }
            if (jsonObject.has("pid")) {
                node.productIdentifier = Integer.parseInt(jsonObject.get("pid").getAsString(), 16);
            }
            if (jsonObject.has("vid")) {
                node.versionIdentifier = Integer.parseInt(jsonObject.get("vid").getAsString(), 16);
            }
            if (jsonObject.has("crpl")) {
                node.crpl = Integer.parseInt(jsonObject.get("crpl").getAsString(), 16);
            }
            if (jsonObject.has("features")) {
                JsonObject featuresJson = jsonObject.get("features").getAsJsonObject();
                node.nodeFeatures = new Features(featuresJson.get("friend").getAsInt(), featuresJson.get("lowPower").getAsInt(), featuresJson.get("relay").getAsInt(), featuresJson.get("proxy").getAsInt());
            }
            if (jsonObject.has("secureNetworkBeacon")) {
                node.setSecureNetworkBeaconSupported(jsonObject.get("secureNetworkBeacon").getAsBoolean());
            }
            if (jsonObject.has("defaultTTL") && !jsonObject.get("defaultTTL").isJsonNull()) {
                node.ttl = jsonObject.get("defaultTTL").getAsInt();
            }
            if (jsonObject.has("networkTransmit")) {
                JsonObject jsonNetTransmit = jsonObject.getAsJsonObject("networkTransmit");
                count = jsonNetTransmit.get("count").getAsInt();
                interval = jsonNetTransmit.get("interval").getAsInt();
                if (count < 1 || count > 8) {
                    throw new IllegalArgumentException("Error while deserializing Network Transmit on : " + MeshAddress.formatAddress(unicastAddress, true) + ", Network Transmit count must be in range 1-8.");
                }
                if (count != 0 && interval != 0) {
                    NetworkTransmitSettings networkTransmitSettings;
                    if (interval % 10 != 0 && interval <= 32) {
                        networkTransmitSettings = new NetworkTransmitSettings(count, interval);
                        node.setNetworkTransmitSettings(networkTransmitSettings);
                    } else if (interval % 10 == 0) {
                        steps = NetworkTransmitSettings.decodeNetworkTransmissionInterval(interval);
                        networkTransmitSettings = new NetworkTransmitSettings(count, steps);
                        node.setNetworkTransmitSettings(networkTransmitSettings);
                    }
                }
            }
            if (jsonObject.has("relayRetransmit")) {
                JsonObject jsonRelay = jsonObject.getAsJsonObject("relayRetransmit");
                count = jsonRelay.get("count").getAsInt();
                interval = jsonRelay.get("interval").getAsInt();
                if (count != 0 && interval != 0) {
                    RelaySettings relaySettings;
                    if (count < 1 || count > 8) {
                        throw new IllegalArgumentException("Error while deserializing Relay Retransmit on : " + MeshAddress.formatAddress(unicastAddress, true) + " Relay Retransmit count must be in range 1-8.");
                    }
                    if (interval % 10 != 0 && interval <= 32) {
                        relaySettings = new RelaySettings(count, interval);
                        node.setRelaySettings(relaySettings);
                    } else if (interval % 10 == 0) {
                        steps = RelaySettings.decodeRelayRetransmitInterval(interval);
                        relaySettings = new RelaySettings(count, steps);
                        node.setRelaySettings(relaySettings);
                    }
                }
            }
            if (jsonObject.has("appKeys")) {
                node.mAddedAppKeys = this.deserializeAddedIndexes(jsonObject.get("appKeys").getAsJsonArray());
            }
            if (jsonObject.has("elements")) {
                List<Element> elements = this.deserializeElements(context, jsonObject);
                Map<Integer, Element> elementMap = this.populateElements(unicastAddress, elements);
                node.mElements.clear();
                node.mElements.putAll(elementMap);
            }
            if (jsonObject.has("blacklisted")) {
                node.setExcluded(jsonObject.get("blacklisted").getAsBoolean());
            } else if (jsonObject.has("excluded")) {
                node.setExcluded(jsonObject.get("excluded").getAsBoolean());
            }
            if (jsonObject.has("name")) {
                node.nodeName = jsonObject.get("name").getAsString();
            }
            this.deserializeHeartbeat(jsonObject, node);
            nodes.add(node);
        }
        return nodes;
    }

    public JsonElement serialize(List<ProvisionedMeshNode> nodes, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        for (ProvisionedMeshNode node : nodes) {
            JsonObject json;
            JsonObject nodeJson = new JsonObject();
            nodeJson.addProperty("UUID", node.getUuid().toUpperCase(Locale.US));
            nodeJson.addProperty("name", node.getNodeName());
            nodeJson.addProperty("deviceKey", MeshParserUtils.bytesToHex(node.getDeviceKey(), false));
            nodeJson.addProperty("unicastAddress", MeshParserUtils.bytesToHex(MeshAddress.addressIntToBytes(node.getUnicastAddress()), false));
            nodeJson.addProperty("security", node.getSecurity() == 1 ? "secure" : "insecure");
            nodeJson.addProperty("configComplete", Boolean.valueOf(node.isConfigured()));
            if (node.getCompanyIdentifier() != null) {
                nodeJson.addProperty("cid", CompositionDataParser.formatCompanyIdentifier(node.getCompanyIdentifier(), false));
            }
            if (node.getProductIdentifier() != null) {
                nodeJson.addProperty("pid", CompositionDataParser.formatProductIdentifier(node.getProductIdentifier(), false));
            }
            if (node.getVersionIdentifier() != null) {
                nodeJson.addProperty("vid", CompositionDataParser.formatVersionIdentifier(node.getVersionIdentifier(), false));
            }
            if (node.getCrpl() != null) {
                nodeJson.addProperty("crpl", CompositionDataParser.formatReplayProtectionCount(node.getCrpl(), false));
            }
            if (node.getNodeFeatures() != null) {
                json = new JsonObject();
                json.addProperty("friend", (Number)node.getNodeFeatures().getFriend());
                json.addProperty("lowPower", (Number)node.getNodeFeatures().getLowPower());
                json.addProperty("proxy", (Number)node.getNodeFeatures().getProxy());
                json.addProperty("relay", (Number)node.getNodeFeatures().getRelay());
                nodeJson.add("features", (JsonElement)json);
            }
            if (node.isSecureNetworkBeaconSupported() != null) {
                nodeJson.addProperty("secureNetworkBeacon", node.isSecureNetworkBeaconSupported());
            }
            nodeJson.addProperty("defaultTTL", (Number)node.getTtl());
            if (node.getNetworkTransmitSettings() != null) {
                json = new JsonObject();
                json.addProperty("count", (Number)node.getNetworkTransmitSettings().getNetworkTransmitCount());
                json.addProperty("interval", (Number)node.getNetworkTransmitSettings().getNetworkTransmissionInterval());
                nodeJson.add("networkTransmit", (JsonElement)json);
            }
            if (node.getRelaySettings() != null) {
                json = new JsonObject();
                json.addProperty("count", (Number)node.getRelaySettings().getRelayTransmitCount());
                json.addProperty("interval", (Number)node.getRelaySettings().getRetransmissionIntervals());
                nodeJson.add("relayRetransmit", (JsonElement)json);
            }
            nodeJson.add("netKeys", this.serializeAddedIndexes(node.getAddedNetKeys()));
            nodeJson.add("appKeys", this.serializeAddedIndexes(node.getAddedAppKeys()));
            nodeJson.add("elements", this.serializeElements(context, node.getElements()));
            nodeJson.addProperty("excluded", Boolean.valueOf(node.isExcluded()));
            this.serializeHeartbeat(nodeJson, node);
            jsonArray.add((JsonElement)nodeJson);
        }
        return jsonArray;
    }

    private JsonElement serializeAddedIndexes(List<NodeKey> addedKeyIndexes) {
        JsonArray addedKeys = new JsonArray();
        for (NodeKey nodeKey : addedKeyIndexes) {
            JsonObject keyIndexJson = new JsonObject();
            keyIndexJson.addProperty("index", (Number)nodeKey.getIndex());
            keyIndexJson.addProperty("updated", Boolean.valueOf(nodeKey.isUpdated()));
            addedKeys.add((JsonElement)keyIndexJson);
        }
        return addedKeys;
    }

    private List<NodeKey> deserializeAddedIndexes(JsonArray jsonNetKeyIndexes) {
        ArrayList<NodeKey> addedKeys = new ArrayList<NodeKey>();
        for (int i = 0; i < jsonNetKeyIndexes.size(); ++i) {
            JsonObject jsonAddedKeys = jsonNetKeyIndexes.get(i).getAsJsonObject();
            int index = jsonAddedKeys.get("index").getAsInt();
            boolean updated = false;
            if (jsonAddedKeys.has("updated")) {
                updated = jsonAddedKeys.get("updated").getAsBoolean();
            }
            addedKeys.add(new NodeKey(index, updated));
        }
        return addedKeys;
    }

    private JsonElement serializeElements(JsonSerializationContext context, Map<Integer, Element> elementsMap) {
        Type elementsList = new TypeToken<List<Element>>(){}.getType();
        return context.serialize(this.populateElements(elementsMap), elementsList);
    }

    private List<Element> deserializeElements(JsonDeserializationContext context, JsonObject json) {
        Type elementList = new TypeToken<List<Element>>(){}.getType();
        return (List)context.deserialize((JsonElement)json.getAsJsonArray("elements"), elementList);
    }

    private Map<Integer, Element> populateElements(int unicastAddress, List<Element> elementsList) {
        LinkedHashMap<Integer, Element> elements = new LinkedHashMap<Integer, Element>();
        int address = 0;
        for (int i = 0; i < elementsList.size(); ++i) {
            Element element = elementsList.get(i);
            element.elementAddress = i == 0 ? (address = unicastAddress) : ++address;
            if (TextUtils.isEmpty((CharSequence)element.name)) {
                element.name = "Element: " + MeshAddress.formatAddress(element.elementAddress, true);
            }
            elements.put(element.elementAddress, element);
        }
        return elements;
    }

    private List<Element> populateElements(Map<Integer, Element> elementMap) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Map.Entry<Integer, Element> elementEntry : elementMap.entrySet()) {
            elements.add(elementEntry.getValue());
        }
        return elements;
    }

    private void deserializeHeartbeat(@NonNull JsonObject jsonObject, @NonNull ProvisionedMeshNode node) {
        ConfigurationServerModel model = this.getConfigurationServerModel(node);
        if (model != null) {
            JsonObject jsonHeartbeatPub;
            int dst;
            if (jsonObject.has("heartbeatPub") && (dst = (jsonHeartbeatPub = jsonObject.get("heartbeatPub").getAsJsonObject()).has("address") ? Integer.parseInt(jsonHeartbeatPub.get("address").getAsString(), 16) : Integer.parseInt(jsonHeartbeatPub.get("destination").getAsString(), 16)) != 0) {
                JsonArray jsonFeatures = jsonHeartbeatPub.get("features").getAsJsonArray();
                int relay = 0;
                int proxy = 0;
                int friend = 0;
                int lowPower = 0;
                for (JsonElement element : jsonFeatures) {
                    if (element.getAsString().equalsIgnoreCase("relay")) {
                        relay = 1;
                        continue;
                    }
                    if (element.getAsString().equalsIgnoreCase("proxy")) {
                        proxy = 1;
                        continue;
                    }
                    if (element.getAsString().equalsIgnoreCase("friend")) {
                        friend = 1;
                        continue;
                    }
                    if (!element.getAsString().equalsIgnoreCase("lowPower")) continue;
                    lowPower = 1;
                }
                Features features = new Features(friend, lowPower, proxy, relay);
                int index = jsonHeartbeatPub.get("index").getAsInt();
                byte period = Heartbeat.decodeHeartbeatPeriod(jsonHeartbeatPub.get("period").getAsInt());
                int ttl = jsonHeartbeatPub.get("ttl").getAsInt();
                model.setHeartbeatPublication(new HeartbeatPublication(dst, 0, period, ttl, features, index));
            }
            if (jsonObject.has("heartbeatSub")) {
                JsonObject jsonHeartbeatSub = jsonObject.get("heartbeatSub").getAsJsonObject();
                dst = Integer.parseInt(jsonHeartbeatSub.get("destination").getAsString(), 16);
                int src = Integer.parseInt(jsonHeartbeatSub.get("source").getAsString(), 16);
                if (dst != 0 || src != 0) {
                    model.setHeartbeatSubscription(new HeartbeatSubscription(src, dst, 0, 0, 0, 0));
                }
            }
        }
    }

    private void serializeHeartbeat(@NonNull JsonObject jsonObject, @NonNull ProvisionedMeshNode node) {
        ConfigurationServerModel model = this.getConfigurationServerModel(node);
        if (model != null) {
            if (model.getHeartbeatPublication() != null) {
                HeartbeatPublication publication = model.getHeartbeatPublication();
                JsonObject heartbeatPub = new JsonObject();
                heartbeatPub.addProperty("address", MeshAddress.formatAddress(publication.getDst(), false));
                heartbeatPub.addProperty("period", (Number)publication.getPeriod());
                heartbeatPub.addProperty("ttl", (Number)publication.getTtl());
                heartbeatPub.addProperty("index", (Number)publication.getNetKeyIndex());
                JsonArray featuresArray = new JsonArray();
                if (publication.getFeatures().getRelay() == 1) {
                    featuresArray.add("relay");
                }
                if (publication.getFeatures().getProxy() == 1) {
                    featuresArray.add("proxy");
                }
                if (publication.getFeatures().getFriend() == 1) {
                    featuresArray.add("friend");
                }
                if (publication.getFeatures().getLowPower() == 1) {
                    featuresArray.add("lowPower");
                }
                heartbeatPub.add("features", (JsonElement)featuresArray);
                jsonObject.add("heartbeatPub", (JsonElement)heartbeatPub);
            }
            if (model.getHeartbeatSubscription() != null) {
                JsonObject subscription = new JsonObject();
                subscription.addProperty("destination", MeshAddress.formatAddress(model.getHeartbeatSubscription().getDst(), false));
                subscription.addProperty("source", MeshAddress.formatAddress(model.getHeartbeatSubscription().getSrc(), false));
                jsonObject.add("heartbeatSub", (JsonElement)subscription);
            }
        }
    }

    private ConfigurationServerModel getConfigurationServerModel(@NonNull ProvisionedMeshNode node) {
        MeshModel meshModel;
        Element element = node.getElements().get(node.getUnicastAddress());
        if (element != null && (meshModel = element.getMeshModels().get(0)) instanceof ConfigurationServerModel) {
            return (ConfigurationServerModel)meshModel;
        }
        return null;
    }
}

