/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class SceneRecall
extends ApplicationMessage {
    private static final String TAG = SceneRecall.class.getSimpleName();
    private static final int OP_CODE = 33346;
    private static final int SCENE_RECALL_TRANSITION_PARAMS_LENGTH = 5;
    private static final int SCENE_RECALL_PARAMS_LENGTH = 3;
    private final Integer mTransitionSteps;
    private final Integer mTransitionResolution;
    private final Integer mDelay;
    private final int mSceneNumber;
    private final int tId;

    public SceneRecall(@NonNull ApplicationKey appKey, int sceneNumber, int tId) throws IllegalArgumentException {
        this(appKey, null, null, null, sceneNumber, tId);
    }

    public SceneRecall(@NonNull ApplicationKey appKey, @Nullable Integer transitionSteps, @Nullable Integer transitionResolution, @Nullable Integer delay, int sceneNumber, int tId) {
        super(appKey);
        this.mTransitionSteps = transitionSteps;
        this.mTransitionResolution = transitionResolution;
        this.mDelay = delay;
        this.mSceneNumber = sceneNumber;
        this.tId = tId;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33346;
    }

    @Override
    void assembleMessageParameters() {
        ByteBuffer paramsBuffer;
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        Log.v((String)TAG, (String)("Scene number: " + this.mSceneNumber));
        if (this.mTransitionSteps == null || this.mTransitionResolution == null || this.mDelay == null) {
            paramsBuffer = ByteBuffer.allocate(3).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mSceneNumber);
            paramsBuffer.put((byte)this.tId);
        } else {
            Log.v((String)TAG, (String)("Transition steps: " + this.mTransitionSteps));
            Log.v((String)TAG, (String)("Transition step resolution: " + this.mTransitionResolution));
            paramsBuffer = ByteBuffer.allocate(5).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mSceneNumber);
            paramsBuffer.put((byte)this.tId);
            paramsBuffer.put((byte)(this.mTransitionResolution << 6 | this.mTransitionSteps));
            int delay = this.mDelay;
            paramsBuffer.put((byte)delay);
        }
        this.mParameters = paramsBuffer.array();
    }
}

