/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.sensorutils.SensorDescriptor;
import no.nordicsemi.android.mesh.sensorutils.SensorSamplingFunction;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.transport.SceneStatuses;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class SensorDescriptorStatus
extends ApplicationStatusMessage
implements Parcelable,
SceneStatuses {
    private static final String TAG = SensorDescriptorStatus.class.getSimpleName();
    private static final int OP_CODE = 81;
    private DescriptorStatusResult result;
    private static final Parcelable.Creator<SensorDescriptorStatus> CREATOR = new Parcelable.Creator<SensorDescriptorStatus>(){

        public SensorDescriptorStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new SensorDescriptorStatus(message);
        }

        public SensorDescriptorStatus[] newArray(int size) {
            return new SensorDescriptorStatus[size];
        }
    };

    public SensorDescriptorStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        if (this.mParameters.length == 2) {
            this.result = new PropertyNotFound(DeviceProperty.from((short)MeshParserUtils.unsignedBytesToInt(this.mParameters[0], this.mParameters[1])));
        } else {
            ArrayList<SensorDescriptor> sensorDescriptors = new ArrayList<SensorDescriptor>();
            for (int offset = 0; offset < this.mParameters.length; offset += 8) {
                DeviceProperty property = DeviceProperty.from((short)MeshParserUtils.unsignedBytesToInt(this.mParameters[offset], this.mParameters[offset + 1]));
                short positiveTolerance = (short)MeshParserUtils.bytesToInt(new byte[]{(byte)(this.mParameters[offset + 3] & 0xF), this.mParameters[offset + 2]});
                short negativeTolerance = (short)MeshParserUtils.bytesToInt(new byte[]{(byte)((this.mParameters[offset + 4] & 0xF0) >> 4), (byte)(this.mParameters[offset + 4] << 4 | (this.mParameters[offset + 3] & 0xF0) >> 4)});
                SensorSamplingFunction samplingFunction = SensorSamplingFunction.from(this.mParameters[offset + 5]);
                byte measurementPeriod = this.mParameters[offset + 6];
                byte updateInterval = this.mParameters[offset + 7];
                SensorDescriptor descriptor = new SensorDescriptor(property, positiveTolerance, negativeTolerance, samplingFunction, measurementPeriod, updateInterval);
                Log.d((String)TAG, (String)("Sensor Descriptor: " + descriptor.toString()));
                sensorDescriptors.add(descriptor);
            }
            this.result = new SensorDescriptors(sensorDescriptors);
        }
    }

    protected DescriptorStatusResult getResult() {
        return this.result;
    }

    @Override
    public int getOpCode() {
        return 81;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public static interface DescriptorStatusResult {
    }

    public class SensorDescriptors
    implements DescriptorStatusResult {
        public final List<SensorDescriptor> descriptors;

        public SensorDescriptors(List<SensorDescriptor> descriptors) {
            this.descriptors = descriptors;
        }
    }

    public class PropertyNotFound
    implements DescriptorStatusResult {
        public final DeviceProperty property;

        public PropertyNotFound(DeviceProperty property) {
            this.property = property;
        }
    }
}

