/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class VendorModelMessageStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = VendorModelMessageStatus.class.getSimpleName();
    private final int mModelIdentifier;
    public static final Parcelable.Creator<VendorModelMessageStatus> CREATOR = new Parcelable.Creator<VendorModelMessageStatus>(){

        public VendorModelMessageStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            int modelIdentifier = in.readInt();
            return new VendorModelMessageStatus(message, modelIdentifier);
        }

        public VendorModelMessageStatus[] newArray(int size) {
            return new VendorModelMessageStatus[size];
        }
    };

    public VendorModelMessageStatus(@NonNull AccessMessage message, int modelIdentifier) {
        super(message);
        this.mParameters = message.getParameters();
        this.mModelIdentifier = modelIdentifier;
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        Log.v((String)TAG, (String)("Received Vendor model status: " + MeshParserUtils.bytesToHex(this.mParameters, false)));
    }

    @Override
    public int getOpCode() {
        return this.mMessage.getOpCode();
    }

    public int getCompanyIdentifier() {
        return this.mMessage.getCompanyIdentifier();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
        dest.writeInt(this.mModelIdentifier);
    }

    public final byte[] getAccessPayload() {
        return ((AccessMessage)this.mMessage).getAccessPdu();
    }

    public int getModelIdentifier() {
        return this.mModelIdentifier;
    }
}

