/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum AlgorithmType {
    FIPS_P_256_ELLIPTIC_CURVE("FIPS P-256 Elliptic Curve", 1, 0);

    private static final String TAG;
    private final short bitMask;
    private final String name;
    private final byte value;

    private AlgorithmType(String name, short bitMask, byte value) {
        this.name = name;
        this.bitMask = bitMask;
        this.value = value;
    }

    public short getBitMask() {
        return this.bitMask;
    }

    public String getName() {
        return this.name;
    }

    public byte getValue() {
        return this.value;
    }

    public static ArrayList<AlgorithmType> getAlgorithmTypeFromBitMask(short algorithmTypeValue) {
        AlgorithmType[] algorithmTypes = AlgorithmType.values();
        ArrayList<AlgorithmType> supportedAlgorithms = new ArrayList<AlgorithmType>();
        for (AlgorithmType algorithmType : algorithmTypes) {
            if ((algorithmTypeValue & algorithmType.bitMask) != algorithmType.bitMask) continue;
            supportedAlgorithms.add(algorithmType);
            Log.v((String)TAG, (String)("Supported output oob action type: " + algorithmType.name));
        }
        return supportedAlgorithms;
    }

    public static byte getSupportedAlgorithmValue(List<AlgorithmType> supportedAlgorithmByNode) {
        List<AlgorithmType> provisionerSupportedAlgorithms = Arrays.asList(AlgorithmType.values());
        Collections.reverse(supportedAlgorithmByNode);
        for (AlgorithmType algorithmType : supportedAlgorithmByNode) {
            for (AlgorithmType provisionerSupportedAlgorithm : provisionerSupportedAlgorithms) {
                if (provisionerSupportedAlgorithm != algorithmType) continue;
                return provisionerSupportedAlgorithm.value;
            }
        }
        throw new IllegalArgumentException("Unsupported algorithm!");
    }

    static {
        TAG = AlgorithmType.class.getSimpleName();
    }
}

