/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import androidx.annotation.NonNull;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.Group;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.Provisioner;
import no.nordicsemi.android.mesh.Scene;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class MeshNetworkDeserializer
implements JsonSerializer<MeshNetwork>,
JsonDeserializer<MeshNetwork> {
    private static final String TAG = MeshNetworkDeserializer.class.getSimpleName();

    public MeshNetwork deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        if (!this.isValidMeshObject(jsonObject)) {
            throw new JsonSyntaxException("Invalid Mesh Provisioning/Configuration Database, Mesh Network must follow the Mesh Provisioning/Configuration Database format.");
        }
        String uuid = jsonObject.get("meshUUID").getAsString();
        String meshUuid = MeshParserUtils.formatUuid(uuid);
        MeshNetwork network = new MeshNetwork(meshUuid == null ? uuid : meshUuid);
        network.schema = jsonObject.get("$schema").getAsString();
        network.id = jsonObject.get("id").getAsString();
        network.version = jsonObject.get("version").getAsString();
        network.meshName = jsonObject.get("meshName").getAsString();
        try {
            network.timestamp = MeshParserUtils.parseTimeStamp(jsonObject.get("timestamp").getAsString());
        }
        catch (Exception ex) {
            throw new JsonSyntaxException("Invalid Mesh Provisioning/Configuration Database JSON file, mesh network timestamp must follow the Mesh Provisioning/Configuration Database format.");
        }
        if (jsonObject.has("partial")) {
            network.partial = jsonObject.get("partial").getAsBoolean();
        }
        network.netKeys = this.deserializeNetKeys(context, jsonObject.getAsJsonArray("netKeys"), network.meshUUID);
        network.appKeys = this.deserializeAppKeys(context, jsonObject.getAsJsonArray("appKeys"), network.meshUUID);
        network.provisioners = this.deserializeProvisioners(context, jsonObject.getAsJsonArray("provisioners"), network.meshUUID);
        network.nodes = this.deserializeNodes(context, jsonObject.getAsJsonArray("nodes"), network.meshUUID);
        network.groups = this.deserializeGroups(jsonObject, network.meshUUID);
        network.scenes = this.deserializeScenes(jsonObject, network.meshUUID);
        if (jsonObject.has("networkExclusions")) {
            network.networkExclusions = this.deserializeExclusionList(jsonObject.getAsJsonArray("networkExclusions"));
        }
        this.assignProvisionerAddresses(network);
        return network;
    }

    public JsonElement serialize(MeshNetwork network, Type typeOfSrc, JsonSerializationContext context) {
        String meshUuid = network.getMeshUUID().toUpperCase(Locale.US);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("$schema", network.getSchema());
        jsonObject.addProperty("id", network.getId());
        jsonObject.addProperty("version", network.getVersion());
        jsonObject.addProperty("meshUUID", meshUuid);
        jsonObject.addProperty("meshName", network.getMeshName());
        jsonObject.addProperty("timestamp", MeshParserUtils.formatTimeStamp(network.getTimestamp()));
        jsonObject.addProperty("partial", Boolean.valueOf(network.partial));
        jsonObject.add("netKeys", this.serializeNetKeys(context, network.getNetKeys()));
        jsonObject.add("appKeys", this.serializeAppKeys(context, network.getAppKeys()));
        jsonObject.add("provisioners", this.serializeProvisioners(context, network.getProvisioners()));
        jsonObject.add("nodes", this.serializeNodes(context, network.getNodes()));
        jsonObject.add("groups", this.serializeGroups(network.getGroups()));
        jsonObject.add("scenes", this.serializeScenes(network.getScenes()));
        jsonObject.add("networkExclusions", this.serializeExclusionList(network.getNetworkExclusions()));
        return jsonObject;
    }

    private boolean isValidMeshObject(@NonNull JsonObject mesh) {
        return mesh.has("$schema") && mesh.has("id") && mesh.has("version") && mesh.has("meshUUID") && mesh.has("meshName") && mesh.has("timestamp") && mesh.has("provisioners") && mesh.has("netKeys") && mesh.has("appKeys") && mesh.has("nodes");
    }

    private JsonElement serializeNetKeys(@NonNull JsonSerializationContext context, @NonNull List<NetworkKey> networkKeys) {
        Type networkKey = new TypeToken<List<NetworkKey>>(){}.getType();
        return context.serialize(networkKeys, networkKey);
    }

    private List<NetworkKey> deserializeNetKeys(@NonNull JsonDeserializationContext context, @NonNull JsonArray json, @NonNull String meshUuid) {
        Type networkKey = new TypeToken<List<NetworkKey>>(){}.getType();
        List networkKeys = (List)context.deserialize((JsonElement)json, networkKey);
        for (NetworkKey key : networkKeys) {
            key.setMeshUuid(meshUuid);
        }
        return networkKeys;
    }

    private JsonElement serializeAppKeys(@NonNull JsonSerializationContext context, @NonNull List<ApplicationKey> applicationKeys) {
        Type networkKey = new TypeToken<List<ApplicationKey>>(){}.getType();
        return context.serialize(applicationKeys, networkKey);
    }

    private List<ApplicationKey> deserializeAppKeys(@NonNull JsonDeserializationContext context, @NonNull JsonArray json, @NonNull String meshUuid) {
        Type applicationKeyList = new TypeToken<List<ApplicationKey>>(){}.getType();
        List applicationKeys = (List)context.deserialize((JsonElement)json, applicationKeyList);
        for (ApplicationKey key : applicationKeys) {
            key.setMeshUuid(meshUuid);
        }
        return applicationKeys;
    }

    private List<Provisioner> deserializeProvisioners(@NonNull JsonDeserializationContext context, @NonNull JsonArray json, @NonNull String meshUuid) {
        ArrayList<Provisioner> provisioners = new ArrayList<Provisioner>();
        JsonArray jsonProvisioners = json.getAsJsonArray();
        for (int i = 0; i < jsonProvisioners.size(); ++i) {
            JsonObject jsonProvisioner = jsonProvisioners.get(i).getAsJsonObject();
            String name = jsonProvisioner.get("provisionerName").getAsString();
            String uuid = jsonProvisioner.get("UUID").getAsString().toUpperCase();
            String provisionerUuid = MeshParserUtils.formatUuid(uuid);
            if (provisionerUuid == null) {
                throw new IllegalArgumentException("Invalid Mesh Provisioning/Configuration Database, invalid provisioner uuid.");
            }
            List<AllocatedUnicastRange> unicastRanges = this.deserializeAllocatedUnicastRange(context, jsonProvisioner);
            ArrayList<AllocatedGroupRange> groupRanges = new ArrayList();
            if (jsonProvisioner.has("allocatedGroupRange") && !jsonProvisioner.get("allocatedGroupRange").isJsonNull()) {
                groupRanges = this.deserializeAllocatedGroupRange(context, jsonProvisioner);
            }
            List<AllocatedSceneRange> sceneRanges = new ArrayList<AllocatedSceneRange>();
            if (jsonProvisioner.has("allocatedSceneRange") && !jsonProvisioner.get("allocatedSceneRange").isJsonNull()) {
                sceneRanges = this.deserializeAllocatedSceneRange(context, jsonProvisioner);
            }
            Provisioner provisioner = new Provisioner(provisionerUuid, unicastRanges, groupRanges, sceneRanges, meshUuid);
            provisioner.setProvisionerName(name);
            provisioners.add(provisioner);
        }
        return provisioners;
    }

    private JsonElement serializeProvisioners(@NonNull JsonSerializationContext context, @NonNull List<Provisioner> provisioners) {
        JsonArray jsonArray = new JsonArray();
        for (Provisioner provisioner : provisioners) {
            JsonObject provisionerJson = new JsonObject();
            provisionerJson.addProperty("provisionerName", provisioner.getProvisionerName());
            provisionerJson.addProperty("UUID", provisioner.getProvisionerUuid().toUpperCase(Locale.US));
            provisionerJson.add("allocatedUnicastRange", this.serializeAllocatedUnicastRanges(context, provisioner.allocatedUnicastRanges));
            provisionerJson.add("allocatedGroupRange", this.serializeAllocatedGroupRanges(context, provisioner.allocatedGroupRanges));
            provisionerJson.add("allocatedSceneRange", this.serializeAllocatedSceneRanges(context, provisioner.allocatedSceneRanges));
            jsonArray.add((JsonElement)provisionerJson);
        }
        return jsonArray;
    }

    private JsonElement serializeAllocatedUnicastRanges(@NonNull JsonSerializationContext context, @NonNull List<AllocatedUnicastRange> ranges) {
        Type allocatedUnicastRanges = new TypeToken<List<AllocatedUnicastRange>>(){}.getType();
        return context.serialize(ranges, allocatedUnicastRanges);
    }

    private List<AllocatedUnicastRange> deserializeAllocatedUnicastRange(@NonNull JsonDeserializationContext context, @NonNull JsonObject json) {
        Type unicastRangeList = new TypeToken<List<AllocatedUnicastRange>>(){}.getType();
        return (List)context.deserialize((JsonElement)json.get("allocatedUnicastRange").getAsJsonArray(), unicastRangeList);
    }

    private JsonElement serializeAllocatedGroupRanges(@NonNull JsonSerializationContext context, @NonNull List<AllocatedGroupRange> ranges) {
        Type allocatedGroupRanges = new TypeToken<List<AllocatedGroupRange>>(){}.getType();
        return context.serialize(ranges, allocatedGroupRanges);
    }

    private List<AllocatedGroupRange> deserializeAllocatedGroupRange(@NonNull JsonDeserializationContext context, @NonNull JsonObject json) {
        Type groupRangeList = new TypeToken<List<AllocatedGroupRange>>(){}.getType();
        return (List)context.deserialize((JsonElement)json.getAsJsonArray("allocatedGroupRange"), groupRangeList);
    }

    private JsonElement serializeAllocatedSceneRanges(@NonNull JsonSerializationContext context, @NonNull List<AllocatedSceneRange> ranges) {
        Type allocatedSceneRanges = new TypeToken<List<AllocatedSceneRange>>(){}.getType();
        return context.serialize(ranges, allocatedSceneRanges);
    }

    private List<AllocatedSceneRange> deserializeAllocatedSceneRange(@NonNull JsonDeserializationContext context, @NonNull JsonObject json) {
        Type sceneRangeList = new TypeToken<List<AllocatedSceneRange>>(){}.getType();
        return (List)context.deserialize((JsonElement)json.getAsJsonArray("allocatedSceneRange"), sceneRangeList);
    }

    private JsonElement serializeNodes(@NonNull JsonSerializationContext context, @NonNull List<ProvisionedMeshNode> nodes) {
        Type nodeList = new TypeToken<List<ProvisionedMeshNode>>(){}.getType();
        return context.serialize(nodes, nodeList);
    }

    private List<ProvisionedMeshNode> deserializeNodes(@NonNull JsonDeserializationContext context, @NonNull JsonArray json, String meshUuid) {
        Type nodeList = new TypeToken<List<ProvisionedMeshNode>>(){}.getType();
        List nodes = (List)context.deserialize((JsonElement)json, nodeList);
        for (ProvisionedMeshNode node : nodes) {
            node.setMeshUuid(meshUuid);
        }
        return nodes;
    }

    private JsonElement serializeGroups(@NonNull List<Group> groups) {
        JsonArray groupsArray = new JsonArray();
        for (Group group : groups) {
            JsonObject groupObj = new JsonObject();
            groupObj.addProperty("name", group.getName());
            if (group.getAddressLabel() == null) {
                groupObj.addProperty("address", MeshAddress.formatAddress(group.getAddress(), false));
            } else {
                groupObj.addProperty("address", MeshParserUtils.uuidToHex(group.getAddressLabel()));
            }
            if (group.getParentAddressLabel() == null) {
                groupObj.addProperty("parentAddress", MeshAddress.formatAddress(group.getParentAddress(), false));
            } else {
                groupObj.addProperty("parentAddress", MeshParserUtils.uuidToHex(group.getParentAddressLabel()));
            }
            groupsArray.add((JsonElement)groupObj);
        }
        return groupsArray;
    }

    private List<Group> deserializeGroups(@NonNull JsonObject jsonNetwork, @NonNull String meshUuid) {
        ArrayList<Group> groups = new ArrayList<Group>();
        if (!jsonNetwork.has("groups")) {
            return groups;
        }
        JsonArray jsonGroups = jsonNetwork.getAsJsonArray("groups");
        for (int i = 0; i < jsonGroups.size(); ++i) {
            try {
                JsonObject jsonGroup = jsonGroups.get(i).getAsJsonObject();
                String name = jsonGroup.get("name").getAsString();
                String address = jsonGroup.get("address").getAsString();
                String parentAddress = jsonGroup.get("parentAddress").getAsString();
                Group group = MeshParserUtils.isUuidPattern(address) && MeshParserUtils.isUuidPattern(parentAddress) ? new Group(UUID.fromString(MeshParserUtils.formatUuid(address)), UUID.fromString(MeshParserUtils.formatUuid(parentAddress)), meshUuid) : (MeshParserUtils.isUuidPattern(address) ? new Group(UUID.fromString(MeshParserUtils.formatUuid(address)), Integer.parseInt(parentAddress, 16), meshUuid) : (MeshParserUtils.isUuidPattern(parentAddress) ? new Group(Integer.parseInt(parentAddress, 16), UUID.fromString(MeshParserUtils.formatUuid(parentAddress)), meshUuid) : new Group(Integer.parseInt(address, 16), Integer.parseInt(parentAddress, 16), meshUuid)));
                group.setName(name);
                groups.add(group);
                continue;
            }
            catch (Exception ex) {
                MeshLogger.error(TAG, "Error while de-serializing groups: " + ex.getMessage());
            }
        }
        return groups;
    }

    private JsonElement serializeScenes(@NonNull List<Scene> scenes) {
        JsonArray scenesArray = new JsonArray();
        for (Scene scene : scenes) {
            JsonObject sceneObj = new JsonObject();
            sceneObj.addProperty("name", scene.getName());
            JsonArray array = new JsonArray();
            for (Integer address : scene.getAddresses()) {
                array.add(MeshAddress.formatAddress(address, false));
            }
            sceneObj.add("addresses", (JsonElement)array);
            sceneObj.addProperty("number", String.format(Locale.US, "%04X", scene.getNumber()));
            scenesArray.add((JsonElement)sceneObj);
        }
        return scenesArray;
    }

    private List<Scene> deserializeScenes(@NonNull JsonObject jsonNetwork, @NonNull String meshUuid) {
        ArrayList<Scene> scenes = new ArrayList<Scene>();
        try {
            if (!jsonNetwork.has("scenes")) {
                return scenes;
            }
            JsonArray jsonScenes = jsonNetwork.getAsJsonArray("scenes");
            for (int i = 0; i < jsonScenes.size(); ++i) {
                JsonObject jsonScene = jsonScenes.get(i).getAsJsonObject();
                String name = jsonScene.get("name").getAsString();
                ArrayList<Integer> addresses = new ArrayList<Integer>();
                if (jsonScene.has("addresses")) {
                    JsonArray addressesArray = jsonScene.get("addresses").getAsJsonArray();
                    for (int j = 0; j < addressesArray.size(); ++j) {
                        addresses.add(Integer.parseInt(addressesArray.get(j).getAsString(), 16));
                    }
                }
                int number = jsonScene.has("scene") ? Integer.parseInt(jsonScene.get("scene").getAsString(), 16) : Integer.parseInt(jsonScene.get("number").getAsString(), 16);
                Scene scene = new Scene(number, addresses, meshUuid);
                scene.setName(name);
                scenes.add(scene);
            }
        }
        catch (Exception ex) {
            MeshLogger.error(TAG, "Error while de-serializing scenes: " + ex.getMessage());
        }
        return scenes;
    }

    private JsonElement serializeExclusionList(@NonNull Map<Integer, List<Integer>> networkExclusions) {
        JsonArray exclusionList = new JsonArray();
        for (Map.Entry<Integer, List<Integer>> entry : networkExclusions.entrySet()) {
            JsonObject exclusion = new JsonObject();
            JsonArray array = new JsonArray();
            for (Integer address : entry.getValue()) {
                array.add(MeshAddress.formatAddress(address, false));
            }
            exclusion.addProperty("ivIndex", (Number)entry.getKey());
            exclusion.add("addresses", (JsonElement)array);
            exclusionList.add((JsonElement)exclusion);
        }
        return exclusionList;
    }

    private Map<Integer, List<Integer>> deserializeExclusionList(@NonNull JsonArray networkExclusions) {
        HashMap<Integer, List<Integer>> exclusionList = new HashMap<Integer, List<Integer>>();
        for (JsonElement element : networkExclusions) {
            ArrayList<Integer> addresses = new ArrayList<Integer>();
            JsonObject exclusion = element.getAsJsonObject();
            int ivIndex = exclusion.get("ivIndex").getAsInt();
            for (JsonElement address : exclusion.get("addresses").getAsJsonArray()) {
                addresses.add(Integer.parseInt(address.getAsString(), 16));
            }
            exclusionList.put(ivIndex, addresses);
        }
        return exclusionList;
    }

    private int getNextAvailableAddress(List<ProvisionedMeshNode> nodes) {
        int unicast = 1;
        if (nodes != null && !nodes.isEmpty()) {
            int index = nodes.size() - 1;
            ProvisionedMeshNode node = nodes.get(index);
            Map<Integer, Element> elements = node.getElements();
            unicast = elements != null && !elements.isEmpty() ? node.getUnicastAddress() + elements.size() : node.getUnicastAddress() + 1;
        }
        return unicast;
    }

    private void assignProvisionerAddresses(@NonNull MeshNetwork network) {
        for (Provisioner provisioner : network.provisioners) {
            for (ProvisionedMeshNode node : network.nodes) {
                if (!provisioner.getProvisionerUuid().equalsIgnoreCase(node.getUuid())) continue;
                provisioner.assignProvisionerAddress(node.getUnicastAddress());
                provisioner.setGlobalTtl(node.getTtl());
            }
        }
    }
}

