/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import java.util.Objects;

public class GenericTransitionTime {
    public static final int TRANSITION_TIME_BITS_LENGTH = 8;
    public final TransitionResolution resolution;
    public final TransitionStep transitionStep;

    public GenericTransitionTime(TransitionResolution transitionResolution, TransitionStep transitionSteps) {
        this.resolution = transitionResolution;
        this.transitionStep = transitionSteps;
    }

    public GenericTransitionTime(int value) {
        this.resolution = TransitionResolution.fromValue(value >> 6 & 3);
        this.transitionStep = TransitionStep.Specific(value & 0x3F);
    }

    public int getValue() {
        return this.resolution.value << 6 | this.transitionStep.value;
    }

    public long toMilliseconds() {
        switch (this.resolution) {
            case HUNDRED_MILLISECONDS: {
                return 100L * (long)this.transitionStep.value;
            }
            case SECOND: {
                return 1000L * (long)this.transitionStep.value;
            }
            case TEN_SECONDS: {
                return 10000L * (long)this.transitionStep.value;
            }
            case TEN_MINUTES: {
                return 600000L * (long)this.transitionStep.value;
            }
        }
        return -1L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericTransitionTime that = (GenericTransitionTime)o;
        return this.resolution == that.resolution && this.transitionStep.equals(that.transitionStep);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resolution, this.transitionStep});
    }

    public static enum TransitionResolution {
        HUNDRED_MILLISECONDS(0),
        SECOND(1),
        TEN_SECONDS(2),
        TEN_MINUTES(3);

        public static final int TRANSITION_STEP_RESOLUTION_BITS_LENGTH = 2;
        public int value;

        public static TransitionResolution fromValue(int value) {
            for (TransitionResolution resolution : TransitionResolution.values()) {
                if (resolution.value != value) continue;
                return resolution;
            }
            return SECOND;
        }

        private TransitionResolution(int value) {
            this.value = value;
        }
    }

    public static final class TransitionStep {
        public static final int TRANSITION_NUMBER_STEP_BITS_LENGTH = 6;
        public final int value;
        public static TransitionStep Immediate = new TransitionStep(0);
        public static TransitionStep Unknown = new TransitionStep(63);

        public static TransitionStep Specific(int numberOfSteps) {
            return new TransitionStep(numberOfSteps);
        }

        TransitionStep(int value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransitionStep that = (TransitionStep)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

