/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.logger;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

public final class MeshLogger {
    @Nullable
    private static LogHandler logHandler = null;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void verbose(String tag, String message) {
        MeshLogger.log(2, tag, message, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void debug(String tag, String message) {
        MeshLogger.log(3, tag, message, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void info(String tag, String message) {
        MeshLogger.log(4, tag, message, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void warn(String tag, String message) {
        MeshLogger.log(5, tag, message, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void error(String tag, String message) {
        MeshLogger.log(6, tag, message, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void error(String tag, String message, Throwable throwable) {
        MeshLogger.log(6, tag, message, throwable);
    }

    public static void setLogHandler(@Nullable LogHandler logHandler) {
        MeshLogger.logHandler = logHandler;
    }

    private static void log(int priority, String tag, String message, @Nullable Throwable throwable) {
        String fullMessage = message;
        if (throwable != null) {
            fullMessage = fullMessage + "\n" + Log.getStackTraceString((Throwable)throwable);
        }
        if (logHandler != null) {
            logHandler.log(priority, tag, fullMessage);
        } else {
            Log.println((int)priority, (String)tag, (String)fullMessage);
        }
    }

    public static interface LogHandler {
        public void log(int var1, String var2, String var3);
    }
}

