/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import java.text.DateFormat;
import java.util.Date;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class DateUtc
extends DevicePropertyCharacteristic<Date> {
    public DateUtc(@NonNull byte[] data, int offset) {
        super(data, offset);
        int tempDate = (data[offset + 2] & 0xFF) << 16 | (data[offset + 1] & 0xFF) << 8 | data[offset] & 0xFF;
        this.value = tempDate < 1 || tempDate > 0xFFFFFE ? null : new Date((long)tempDate * 86400000L);
    }

    public DateUtc(Date date) {
        this.value = date;
    }

    @NonNull
    public String toString() {
        return this.value == null ? null : DateFormat.getDateInstance().format((Date)this.value);
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public byte[] getBytes() {
        return MeshParserUtils.convertIntTo24Bits((int)(((Date)this.value).getTime() / 86400000L));
    }
}

