/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigModelSubscriptionStatus
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigModelSubscriptionStatus.class.getSimpleName();
    private static final int OP_CODE = 32799;
    private static final int CONFIG_MODEL_PUBLICATION_STATUS_SIG_MODEL_PDU_LENGTH = 7;
    private static final int CONFIG_MODEL_APP_BIND_STATUS_VENDOR_MODEL_PDU_LENGTH = 9;
    private int mElementAddress;
    private int mModelIdentifier;
    private int mSubscriptionAddress;
    private static final Parcelable.Creator<ConfigModelSubscriptionStatus> CREATOR = new Parcelable.Creator<ConfigModelSubscriptionStatus>(){

        public ConfigModelSubscriptionStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigModelSubscriptionStatus(message);
        }

        public ConfigModelSubscriptionStatus[] newArray(int size) {
            return new ConfigModelSubscriptionStatus[size];
        }
    };

    public ConfigModelSubscriptionStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        AccessMessage message = (AccessMessage)this.mMessage;
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        this.mElementAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        this.mSubscriptionAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[3], this.mParameters[4]);
        this.mModelIdentifier = this.mParameters.length == 7 ? MeshParserUtils.unsignedBytesToInt(this.mParameters[5], this.mParameters[6]) : MeshParserUtils.bytesToInt(new byte[]{this.mParameters[6], this.mParameters[5], this.mParameters[8], this.mParameters[7]});
        MeshLogger.verbose(TAG, "Status code: " + this.mStatusCode);
        MeshLogger.verbose(TAG, "Status message: " + this.mStatusCodeName);
        MeshLogger.verbose(TAG, "Element Address: " + MeshAddress.formatAddress(this.mElementAddress, true));
        MeshLogger.verbose(TAG, "Subscription Address: " + MeshAddress.formatAddress(this.mSubscriptionAddress, true));
        MeshLogger.verbose(TAG, "Model Identifier: " + Integer.toHexString(this.mModelIdentifier));
    }

    @Override
    public int getOpCode() {
        return 32799;
    }

    public int getElementAddress() {
        return this.mElementAddress;
    }

    public int getSubscriptionAddress() {
        return this.mSubscriptionAddress;
    }

    public final int getModelIdentifier() {
        return this.mModelIdentifier;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

