/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigNetKeyUpdate
extends ConfigMessage {
    private static final String TAG = ConfigNetKeyUpdate.class.getSimpleName();
    private static final int OP_CODE = 32837;
    private final NetworkKey mNetKey;

    public ConfigNetKeyUpdate(@NonNull NetworkKey networkKey) throws IllegalArgumentException {
        if (networkKey.getKey().length != 16) {
            throw new IllegalArgumentException("Network key must be 16 bytes");
        }
        this.mNetKey = networkKey;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32837;
    }

    @Override
    void assembleMessageParameters() {
        MeshLogger.verbose(TAG, "NetKeyIndex: " + this.mNetKey.getKeyIndex());
        byte[] netKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mNetKey.getKeyIndex());
        ByteBuffer paramsBuffer = ByteBuffer.allocate(18).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.put(netKeyIndex[0]);
        paramsBuffer.put(netKeyIndex[1]);
        paramsBuffer.put(this.mNetKey.getKey());
        this.mParameters = paramsBuffer.array();
    }
}

