/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigVendorModelSubscriptionList
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigVendorModelSubscriptionList.class.getSimpleName();
    private static final int OP_CODE = 32812;
    private int mElementAddress;
    private int mModelIdentifier;
    private final List<Integer> mSubscriptionAddresses = new ArrayList<Integer>();
    private static final Parcelable.Creator<ConfigVendorModelSubscriptionList> CREATOR = new Parcelable.Creator<ConfigVendorModelSubscriptionList>(){

        public ConfigVendorModelSubscriptionList createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigVendorModelSubscriptionList(message);
        }

        public ConfigVendorModelSubscriptionList[] newArray(int size) {
            return new ConfigVendorModelSubscriptionList[size];
        }
    };

    public ConfigVendorModelSubscriptionList(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        AccessMessage message = (AccessMessage)this.mMessage;
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        this.mElementAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        this.mModelIdentifier = MeshParserUtils.bytesToInt(new byte[]{this.mParameters[4], this.mParameters[3], this.mParameters[6], this.mParameters[5]});
        MeshLogger.verbose(TAG, "Status code: " + this.mStatusCode);
        MeshLogger.verbose(TAG, "Status message: " + this.mStatusCodeName);
        MeshLogger.verbose(TAG, "Element Address: " + MeshAddress.formatAddress(this.mElementAddress, true));
        MeshLogger.verbose(TAG, "Model Identifier: " + Integer.toHexString(this.mModelIdentifier));
        for (int i = 7; i < this.mParameters.length; i += 2) {
            int address = MeshParserUtils.unsignedBytesToInt(this.mParameters[i], this.mParameters[i + 1]);
            this.mSubscriptionAddresses.add(address);
            MeshLogger.verbose(TAG, "Subscription Address: " + MeshAddress.formatAddress(address, false));
        }
    }

    @Override
    public int getOpCode() {
        return 32812;
    }

    public int getElementAddress() {
        return this.mElementAddress;
    }

    public List<Integer> getSubscriptionAddresses() {
        return this.mSubscriptionAddresses;
    }

    public final int getModelIdentifier() {
        return this.mModelIdentifier;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

