/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class GenericOnOffSetUnacknowledged
extends ApplicationMessage {
    private static final String TAG = GenericOnOffSetUnacknowledged.class.getSimpleName();
    private static final int OP_CODE = 33283;
    private static final int GENERIC_ON_OFF_SET_TRANSITION_PARAMS_LENGTH = 4;
    private static final int GENERIC_ON_OFF_SET_PARAMS_LENGTH = 2;
    private final Integer mTransitionSteps;
    private final Integer mTransitionResolution;
    private final Integer mDelay;
    private final boolean mState;
    private final int tId;

    public GenericOnOffSetUnacknowledged(@NonNull ApplicationKey appKey, boolean state, int tId) throws IllegalArgumentException {
        this(appKey, state, tId, null, null, null);
    }

    public GenericOnOffSetUnacknowledged(@NonNull ApplicationKey appKey, boolean state, int tId, @Nullable Integer transitionSteps, @Nullable Integer transitionResolution, @Nullable Integer delay) {
        super(appKey);
        this.mTransitionSteps = transitionSteps;
        this.mTransitionResolution = transitionResolution;
        this.mDelay = delay;
        this.mState = state;
        this.tId = tId;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33283;
    }

    @Override
    void assembleMessageParameters() {
        ByteBuffer paramsBuffer;
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        MeshLogger.verbose(TAG, "State: " + (this.mState ? "ON" : "OFF"));
        if (this.mTransitionSteps == null || this.mTransitionResolution == null || this.mDelay == null) {
            paramsBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put((byte)(this.mState ? 1 : 0));
            paramsBuffer.put((byte)this.tId);
        } else {
            MeshLogger.verbose(TAG, "Transition steps: " + this.mTransitionSteps);
            MeshLogger.verbose(TAG, "Transition step resolution: " + this.mTransitionResolution);
            paramsBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put((byte)(this.mState ? 1 : 0));
            paramsBuffer.put((byte)this.tId);
            paramsBuffer.put((byte)(this.mTransitionResolution << 6 | this.mTransitionSteps));
            int delay = this.mDelay;
            paramsBuffer.put((byte)delay);
        }
        this.mParameters = paramsBuffer.array();
    }
}

