/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public final class LightLCOccupancyModeStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = LightLCOccupancyModeStatus.class.getSimpleName();
    private static final int OP_CODE = 33428;
    private boolean status;
    private static final Parcelable.Creator<LightLCOccupancyModeStatus> CREATOR = new Parcelable.Creator<LightLCOccupancyModeStatus>(){

        public LightLCOccupancyModeStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new LightLCOccupancyModeStatus(message);
        }

        public LightLCOccupancyModeStatus[] newArray(int size) {
            return new LightLCOccupancyModeStatus[size];
        }
    };

    public LightLCOccupancyModeStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        MeshLogger.verbose(TAG, "Received light lc occupancy mode status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        this.status = (this.mParameters[0] & 0xFF) == 1;
    }

    @Override
    public int getOpCode() {
        return 33428;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public boolean getStatus() {
        return this.status;
    }
}

