/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public final class LightLCPropertyStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = LightLCPropertyStatus.class.getSimpleName();
    private static final int OP_CODE = 100;
    private DeviceProperty property;
    private DevicePropertyCharacteristic<?> characteristic;
    private static final Parcelable.Creator<LightLCPropertyStatus> CREATOR = new Parcelable.Creator<LightLCPropertyStatus>(){

        public LightLCPropertyStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new LightLCPropertyStatus(message);
        }

        public LightLCPropertyStatus[] newArray(int size) {
            return new LightLCPropertyStatus[size];
        }
    };

    public LightLCPropertyStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        MeshLogger.verbose(TAG, "Received light lc mode status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.property = DeviceProperty.from(buffer.getShort());
        byte[] value = new byte[this.mParameters.length - 2];
        buffer.get(value, 2, value.length);
        this.characteristic = DeviceProperty.getCharacteristic(this.property, value, 0, value.length);
    }

    @Override
    public int getOpCode() {
        return 100;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public DeviceProperty getProperty() {
        return this.property;
    }

    public DevicePropertyCharacteristic<?> getValue() {
        return this.characteristic;
    }
}

