/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ControlMessage;
import no.nordicsemi.android.mesh.transport.ProxyConfigStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.ProxyFilterType;

public class ProxyConfigFilterStatus
extends ProxyConfigStatusMessage {
    private static final String TAG = ProxyConfigFilterStatus.class.getSimpleName();
    private ProxyFilterType mFilterType;
    private int mAddressListSize;

    public ProxyConfigFilterStatus(@NonNull ControlMessage controlMessage) {
        super(controlMessage);
        this.mParameters = controlMessage.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public int getOpCode() {
        return 3;
    }

    @Override
    byte[] getParameters() {
        return this.mParameters;
    }

    @Override
    void parseStatusParameters() {
        this.mFilterType = new ProxyFilterType(MeshParserUtils.unsignedByteToInt(this.mParameters[0]));
        this.mAddressListSize = MeshParserUtils.unsignedBytesToInt(this.mParameters[2], this.mParameters[1]);
        MeshLogger.debug(TAG, "Filter type: " + this.mFilterType.getFilterTypeName());
        MeshLogger.debug(TAG, "Filter size: " + this.mAddressListSize);
    }

    public ProxyFilterType getFilterType() {
        return this.mFilterType;
    }

    public int getListSize() {
        return this.mAddressListSize;
    }
}

