/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.data.TimeZoneOffset;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public final class TimeZoneSet
extends ApplicationMessage {
    private static final String TAG = TimeZoneSet.class.getSimpleName();
    private static final int OP_CODE = 33340;
    private static final int TIME_ZONE_SET_LENGTH = 6;
    private TimeZoneOffset newTimeZoneOffset;
    private long timeOfChange;

    public TimeZoneSet(@NonNull ApplicationKey appKey, @NonNull TimeZoneOffset newTimeZoneOffset, @NonNull long timeOfChange) {
        super(appKey);
        this.newTimeZoneOffset = newTimeZoneOffset;
        this.timeOfChange = timeOfChange;
        this.assembleMessageParameters();
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        ByteBuffer buffer = ByteBuffer.allocate(6).order(ByteOrder.LITTLE_ENDIAN);
        MeshLogger.verbose(TAG, "Creating message");
        MeshLogger.verbose(TAG, this.newTimeZoneOffset.toString());
        MeshLogger.verbose(TAG, "time of change:" + this.timeOfChange);
        buffer.put(this.newTimeZoneOffset.getEncodedValue());
        buffer.putInt((int)this.timeOfChange);
        buffer.put((byte)(this.timeOfChange >> 32));
        this.mParameters = buffer.array();
    }

    @Override
    public int getOpCode() {
        return 33340;
    }

    @NonNull
    public TimeZoneOffset getNewTimeZoneOffset() {
        return this.newTimeZoneOffset;
    }

    public long getTimeOfChange() {
        return this.timeOfChange;
    }
}

