/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import android.os.Parcel;
import android.os.Parcelable;

public class NetworkTransmitSettings
implements Parcelable {
    public static final int MIN_TRANSMIT_COUNT = 0;
    public static final int MAX_TRANSMIT_COUNT = 7;
    public static final int MIN_TRANSMISSIONS = 1;
    public static final int MAX_TRANSMISSIONS = 8;
    public static final int MIN_TRANSMISSION_INTERVAL_STEPS = 0;
    public static final int MAX_TRANSMISSION_INTERVAL_STEPS = 31;
    public static final int MIN_TRANSMISSION_INTERVAL = 10;
    public static final int MAX_TRANSMISSION_INTERVAL = 320;
    private final int networkTransmitCount;
    private final int networkIntervalSteps;
    public static final Parcelable.Creator<NetworkTransmitSettings> CREATOR = new Parcelable.Creator<NetworkTransmitSettings>(){

        public NetworkTransmitSettings createFromParcel(Parcel in) {
            return new NetworkTransmitSettings(in);
        }

        public NetworkTransmitSettings[] newArray(int size) {
            return new NetworkTransmitSettings[size];
        }
    };

    public NetworkTransmitSettings(int networkTransmitCount, int networkIntervalSteps) {
        if (networkTransmitCount < 0 || networkTransmitCount > 7) {
            throw new IllegalArgumentException("Network Transmit count must be in range 0-7.");
        }
        if (networkIntervalSteps < 0 || networkIntervalSteps > 31) {
            throw new IllegalArgumentException("Network Transmit Interval steps must be in range 0-31.");
        }
        this.networkTransmitCount = networkTransmitCount;
        this.networkIntervalSteps = networkIntervalSteps;
    }

    protected NetworkTransmitSettings(Parcel in) {
        this.networkTransmitCount = in.readInt();
        this.networkIntervalSteps = in.readInt();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.networkTransmitCount);
        dest.writeInt(this.networkIntervalSteps);
    }

    public int describeContents() {
        return 0;
    }

    public int getNetworkTransmitCount() {
        return this.networkTransmitCount;
    }

    public int getTransmissionCount() {
        return this.networkTransmitCount;
    }

    public int getTransmissions() {
        return this.networkTransmitCount + 1;
    }

    public int getNetworkIntervalSteps() {
        return this.networkIntervalSteps;
    }

    public int getNetworkTransmissionInterval() {
        return (this.networkIntervalSteps + 1) * 10;
    }

    public static int decodeNetworkTransmissionInterval(int interval) {
        if (interval >= 10 && interval <= 320 && interval % 10 != 0) {
            throw new IllegalArgumentException("Network Transmission Interval must be 10-320 ms with a step of 10 ms");
        }
        return interval / 10 - 1;
    }

    public static int getNetworkTransmissionInterval(int networkIntervalSteps) {
        return (networkIntervalSteps + 1) * 10;
    }

    public static int getTransmissionCount(int transmissions) {
        if (transmissions < 1 || transmissions > 8) {
            throw new IllegalArgumentException("Network Transmissions must be in range 1-8.");
        }
        return transmissions - 1;
    }
}

