/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import androidx.annotation.NonNull;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.KeyAgreement;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.MeshProvisioningStatusCallbacks;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningState;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedMeshNode;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import org.spongycastle.jce.ECNamedCurveTable;
import org.spongycastle.jce.interfaces.ECPrivateKey;
import org.spongycastle.jce.interfaces.ECPublicKey;
import org.spongycastle.jce.spec.ECNamedCurveParameterSpec;
import org.spongycastle.jce.spec.ECParameterSpec;
import org.spongycastle.jce.spec.ECPublicKeySpec;
import org.spongycastle.math.ec.ECCurve;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.util.BigIntegers;

public class ProvisioningPublicKeyState
extends ProvisioningState {
    private static final int PROVISIONING_PUBLIC_KEY_XY_PDU_LENGTH = 69;
    private final String TAG = ProvisioningPublicKeyState.class.getSimpleName();
    private final MeshProvisioningStatusCallbacks provisioningStatusCallbacks;
    private final UnprovisionedMeshNode node;
    private final InternalTransportCallbacks internalTransportCallbacks;
    private PrivateKey mProvisionerPrivateKey;

    public ProvisioningPublicKeyState(UnprovisionedMeshNode node, InternalTransportCallbacks internalTransportCallbacks, MeshProvisioningStatusCallbacks provisioningStatusCallbacks) {
        this.node = node;
        this.provisioningStatusCallbacks = provisioningStatusCallbacks;
        this.internalTransportCallbacks = internalTransportCallbacks;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_PUBLIC_KEY;
    }

    @Override
    public void executeSend() {
        this.generateKeyPairs();
        byte[] pdu = this.generatePublicKeyXYPDU();
        this.provisioningStatusCallbacks.onProvisioningStateChanged(this.node, ProvisioningState.States.PROVISIONING_PUBLIC_KEY_SENT, pdu);
        this.internalTransportCallbacks.sendProvisioningPdu(this.node, pdu);
    }

    @Override
    public boolean parseData(@NonNull byte[] data) {
        if (this.node.getProvisioneePublicKeyXY() == null) {
            this.provisioningStatusCallbacks.onProvisioningStateChanged(this.node, ProvisioningState.States.PROVISIONING_PUBLIC_KEY_RECEIVED, data);
        }
        this.generateSharedECDHSecret(data);
        return true;
    }

    private void generateKeyPairs() {
        try {
            ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "SC");
            keyPairGenerator.initialize((AlgorithmParameterSpec)parameterSpec);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
            this.mProvisionerPrivateKey = (ECPrivateKey)keyPair.getPrivate();
            ECPoint point = publicKey.getQ();
            BigInteger x = point.getXCoord().toBigInteger();
            BigInteger y = point.getYCoord().toBigInteger();
            byte[] tempX = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)x);
            byte[] tempY = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)y);
            MeshLogger.verbose(this.TAG, "X: length: " + tempX.length + " " + MeshParserUtils.bytesToHex(tempX, false));
            MeshLogger.verbose(this.TAG, "Y: length: " + tempY.length + " " + MeshParserUtils.bytesToHex(tempY, false));
            byte[] tempXY = new byte[64];
            System.arraycopy(tempX, 0, tempXY, 0, tempX.length);
            System.arraycopy(tempY, 0, tempXY, tempY.length, tempY.length);
            this.node.setProvisionerPublicKeyXY(tempXY);
            MeshLogger.verbose(this.TAG, "XY: " + MeshParserUtils.bytesToHex(tempXY, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] generatePublicKeyXYPDU() {
        byte[] tempXY = this.node.getProvisionerPublicKeyXY();
        ByteBuffer buffer = ByteBuffer.allocate(tempXY.length + 2);
        buffer.put((byte)3);
        buffer.put((byte)3);
        buffer.put(tempXY);
        return buffer.array();
    }

    private void generateSharedECDHSecret(byte[] xy) {
        if (this.node.getProvisioneePublicKeyXY() == null) {
            this.node.setProvisioneePublicKeyXY(xy);
        } else {
            this.node.markAsSecure();
        }
        byte[] xComponent = new byte[32];
        System.arraycopy(xy, 0, xComponent, 0, xComponent.length);
        byte[] yComponent = new byte[32];
        System.arraycopy(xy, 32, yComponent, 0, xComponent.length);
        MeshLogger.verbose(this.TAG, "Provisionee X: " + MeshParserUtils.bytesToHex(yComponent, false));
        MeshLogger.verbose(this.TAG, "Provisionee Y: " + MeshParserUtils.bytesToHex(xComponent, false));
        BigInteger x = BigIntegers.fromUnsignedByteArray((byte[])xy, (int)0, (int)32);
        BigInteger y = BigIntegers.fromUnsignedByteArray((byte[])xy, (int)32, (int)32);
        ECNamedCurveParameterSpec ecParameters = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
        ECCurve curve = ecParameters.getCurve();
        ECPoint ecPoint = curve.validatePoint(x, y);
        ECPublicKeySpec keySpec = new ECPublicKeySpec(ecPoint, (ECParameterSpec)ecParameters);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("ECDH", "SC");
            ECPublicKey publicKey = (ECPublicKey)keyFactory.generatePublic((KeySpec)keySpec);
            KeyAgreement a = KeyAgreement.getInstance("ECDH", "SC");
            a.init(this.mProvisionerPrivateKey);
            a.doPhase((Key)publicKey, true);
            byte[] sharedECDHSecret = a.generateSecret();
            this.node.setSharedECDHSecret(sharedECDHSecret);
            MeshLogger.verbose(this.TAG, "ECDH Secret: " + MeshParserUtils.bytesToHex(sharedECDHSecret, false));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
    }
}

