/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;

public class ConfigAppKeyList
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigAppKeyList.class.getSimpleName();
    private static final int OP_CODE = 32770;
    private int mNetKeyIndex;
    private final List<Integer> mKeyIndexes = new ArrayList<Integer>();
    public static final Parcelable.Creator<ConfigAppKeyList> CREATOR = new Parcelable.Creator<ConfigAppKeyList>(){

        public ConfigAppKeyList createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigAppKeyList(message);
        }

        public ConfigAppKeyList[] newArray(int size) {
            return new ConfigAppKeyList[size];
        }
    };

    public ConfigAppKeyList(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        this.mNetKeyIndex = this.decode(3, 1).get(0);
        MeshLogger.verbose(TAG, "NetKey Index: " + Integer.toHexString(this.mNetKeyIndex));
        this.mKeyIndexes.addAll(this.decode(this.mParameters.length, 3));
        for (Integer keyIndex : this.mKeyIndexes) {
            MeshLogger.verbose(TAG, "AppKey Index: " + Integer.toHexString(keyIndex));
        }
    }

    @Override
    public final int getOpCode() {
        return 32770;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public int getNetKeyIndex() {
        return this.mNetKeyIndex;
    }

    public List<Integer> getKeyIndexes() {
        return this.mKeyIndexes;
    }
}

