/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;

public class ConfigAppKeyStatus
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigAppKeyStatus.class.getSimpleName();
    private static final int OP_CODE = 32771;
    private int mNetKeyIndex;
    private int mAppKeyIndex;
    public static final Parcelable.Creator<ConfigAppKeyStatus> CREATOR = new Parcelable.Creator<ConfigAppKeyStatus>(){

        public ConfigAppKeyStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigAppKeyStatus(message);
        }

        public ConfigAppKeyStatus[] newArray(int size) {
            return new ConfigAppKeyStatus[size];
        }
    };

    public ConfigAppKeyStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        ArrayList<Integer> keyIndexes = this.decode(this.mParameters.length, 1);
        this.mNetKeyIndex = keyIndexes.get(0);
        this.mAppKeyIndex = keyIndexes.get(1);
        MeshLogger.verbose(TAG, "Status code: " + this.mStatusCode);
        MeshLogger.verbose(TAG, "Status message: " + this.mStatusCodeName);
        MeshLogger.verbose(TAG, "Net key index: " + Integer.toHexString(this.mNetKeyIndex));
        MeshLogger.verbose(TAG, "App key index: " + Integer.toHexString(this.mAppKeyIndex));
    }

    @Override
    public final int getOpCode() {
        return 32771;
    }

    public final int getNetKeyIndex() {
        return this.mNetKeyIndex;
    }

    public final int getAppKeyIndex() {
        return this.mAppKeyIndex;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

