/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigModelPublicationVirtualAddressSet
extends ConfigMessage {
    private static final String TAG = ConfigModelPublicationVirtualAddressSet.class.getSimpleName();
    private static final int OP_CODE = 32794;
    private static final int SIG_MODEL_PUBLISH_SET_PARAMS_LENGTH = 25;
    private static final int VENDOR_MODEL_PUBLISH_SET_PARAMS_LENGTH = 27;
    private final int elementAddress;
    private final UUID labelUuid;
    private final int appKeyIndex;
    private final boolean credentialFlag;
    private final int publishTtl;
    private final int publicationSteps;
    private final int publicationResolution;
    private final int publishRetransmitCount;
    private final int publishRetransmitIntervalSteps;
    private final int modelIdentifier;

    public ConfigModelPublicationVirtualAddressSet(int elementAddress, @NonNull UUID labelUuid, int appKeyIndex, boolean credentialFlag, int publishTtl, int publicationSteps, int publicationResolution, int retransmitCount, int retransmitIntervalSteps, int modelIdentifier) throws IllegalArgumentException {
        if (!MeshAddress.isValidUnicastAddress(elementAddress)) {
            throw new IllegalArgumentException("Invalid unicast address, unicast address must be a 16-bit value, and must range from 0x0001 to 0x7FFF");
        }
        this.elementAddress = elementAddress;
        this.labelUuid = labelUuid;
        this.credentialFlag = credentialFlag;
        this.publishTtl = publishTtl;
        this.publicationSteps = publicationSteps;
        this.publicationResolution = publicationResolution;
        this.publishRetransmitCount = retransmitCount;
        this.publishRetransmitIntervalSteps = retransmitIntervalSteps;
        this.modelIdentifier = modelIdentifier;
        this.appKeyIndex = appKeyIndex;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32794;
    }

    @Override
    void assembleMessageParameters() {
        ByteBuffer paramsBuffer;
        byte[] applicationKeyIndex = MeshParserUtils.addKeyIndexPadding(this.appKeyIndex);
        MeshLogger.verbose(TAG, "AppKeyIndex: " + this.appKeyIndex);
        MeshLogger.verbose(TAG, "Element address: " + MeshAddress.formatAddress(this.elementAddress, true));
        MeshLogger.verbose(TAG, "Label UUID: " + this.labelUuid.toString());
        MeshLogger.verbose(TAG, "Publish ttl: " + this.publishTtl);
        MeshLogger.verbose(TAG, "Publish steps: " + this.publicationSteps);
        MeshLogger.verbose(TAG, "Publish resolution: " + this.publicationResolution);
        MeshLogger.verbose(TAG, "Retransmission count: " + this.publishRetransmitCount);
        MeshLogger.verbose(TAG, "Retransmission interval: " + this.publishRetransmitIntervalSteps);
        MeshLogger.verbose(TAG, "Model: " + MeshParserUtils.bytesToHex(MeshAddress.addressIntToBytes(this.modelIdentifier), false));
        byte[] publishAddress = MeshParserUtils.uuidToBytes(this.labelUuid);
        boolean rfu = false;
        int octet5 = applicationKeyIndex[0] | (this.credentialFlag ? 1 : 0) << 4;
        byte publishPeriod = (byte)(this.publicationResolution << 6 | this.publicationSteps & 0x3F);
        int octet8 = this.publishRetransmitIntervalSteps << 3 | this.publishRetransmitCount & 7;
        if (!MeshParserUtils.isVendorModel(this.modelIdentifier)) {
            paramsBuffer = ByteBuffer.allocate(25).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.elementAddress);
            paramsBuffer.put(publishAddress);
            paramsBuffer.put(applicationKeyIndex[1]);
            paramsBuffer.put((byte)octet5);
            paramsBuffer.put((byte)this.publishTtl);
            paramsBuffer.put(publishPeriod);
            paramsBuffer.put((byte)octet8);
            paramsBuffer.putShort((short)this.modelIdentifier);
        } else {
            paramsBuffer = ByteBuffer.allocate(27).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.elementAddress);
            paramsBuffer.put(publishAddress);
            paramsBuffer.put(applicationKeyIndex[1]);
            paramsBuffer.put((byte)octet5);
            paramsBuffer.put((byte)this.publishTtl);
            paramsBuffer.put(publishPeriod);
            paramsBuffer.put((byte)octet8);
            byte[] modelIdentifier = new byte[]{(byte)(this.modelIdentifier >> 24 & 0xFF), (byte)(this.modelIdentifier >> 16 & 0xFF), (byte)(this.modelIdentifier >> 8 & 0xFF), (byte)(this.modelIdentifier & 0xFF)};
            paramsBuffer.put(modelIdentifier[1]);
            paramsBuffer.put(modelIdentifier[0]);
            paramsBuffer.put(modelIdentifier[3]);
            paramsBuffer.put(modelIdentifier[2]);
        }
        this.mParameters = paramsBuffer.array();
        MeshLogger.verbose(TAG, "Publication set: " + MeshParserUtils.bytesToHex(this.mParameters, false));
    }

    public int getElementAddress() {
        return this.elementAddress;
    }

    public UUID getLabelUuid() {
        return this.labelUuid;
    }

    public int getAppKeyIndex() {
        return this.appKeyIndex;
    }

    public boolean getCredentialFlag() {
        return this.credentialFlag;
    }

    public int getPublishTtl() {
        return this.publishTtl;
    }

    public int getPublicationSteps() {
        return this.publicationSteps;
    }

    public int getPublicationResolution() {
        return this.publicationResolution;
    }

    public int getPublishRetransmitCount() {
        return this.publishRetransmitCount;
    }

    public int getPublishRetransmitIntervalSteps() {
        return this.publishRetransmitIntervalSteps;
    }

    public int getModelIdentifier() {
        return this.modelIdentifier;
    }
}

