/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigNodeIdentityStatus
extends ConfigStatusMessage {
    private static final String TAG = ConfigNodeIdentityStatus.class.getSimpleName();
    private static final int OP_CODE = 32779;
    private int netKeyIndex;
    private int nodeIdentityState;

    public ConfigNodeIdentityStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        this.mStatusCode = this.mParameters[0];
        byte[] netKeyIndex = new byte[]{(byte)(this.mParameters[2] & 0xF), this.mParameters[1]};
        this.netKeyIndex = ByteBuffer.wrap(netKeyIndex).order(ByteOrder.BIG_ENDIAN).getShort();
        this.nodeIdentityState = MeshParserUtils.unsignedByteToInt(this.mParameters[3]);
    }

    @Override
    public int getOpCode() {
        return 32779;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public int getNodeIdentityState() {
        return this.nodeIdentityState;
    }

    public int getNetKeyIndex() {
        return this.netKeyIndex;
    }
}

