/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class ElementDbMigrator
implements JsonDeserializer<Element>,
Type {
    public Element deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonElement = json.getAsJsonObject();
        if (jsonElement.get("elementAddress").isJsonArray()) {
            JsonArray elementAddress = jsonElement.get("elementAddress").getAsJsonArray();
            if (elementAddress != null) {
                int address = MeshParserUtils.unsignedBytesToInt(elementAddress.get(1).getAsByte(), elementAddress.get(0).getAsByte());
                int location = Integer.parseInt(jsonElement.get("locationDescriptor").getAsString(), 16);
                return new Element(address, location, this.deserializeModels(context, jsonElement));
            }
        } else {
            int address = jsonElement.get("elementAddress").getAsInt();
            int location = jsonElement.get("locationDescriptor").getAsInt();
            String name = jsonElement.has("name") ? jsonElement.get("name").getAsString() : "Element: " + MeshAddress.formatAddress(address, true);
            return new Element(address, location, this.deserializeModels(context, jsonElement), name);
        }
        return null;
    }

    private LinkedHashMap<Integer, MeshModel> deserializeModels(JsonDeserializationContext context, JsonObject json) {
        Type models = new TypeToken<LinkedHashMap<Integer, MeshModel>>(){}.getType();
        return (LinkedHashMap)context.deserialize((JsonElement)json.getAsJsonObject("meshModels"), models);
    }
}

