/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public class GenericBatteryStatus
extends ApplicationStatusMessage {
    private static final String TAG = GenericBatteryStatus.class.getSimpleName();
    private static final int GENERIC_BATTERY_STATUS_MANDATORY_LENGTH = 8;
    private static final int OP_CODE = 33316;
    private int mBatteryLevel;
    private int mTimeToDischarge;
    private int mTimeToCharge;
    private int mFlags;

    public GenericBatteryStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        MeshLogger.verbose(TAG, "Received generic battery status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        this.mBatteryLevel = this.mParameters[0] & 0xFF;
        MeshLogger.verbose(TAG, "Battery level: " + this.mBatteryLevel);
        if (this.mParameters.length >= 8) {
            this.mTimeToDischarge = this.mParameters[1] & 0xFF | (this.mParameters[2] & 0xFF) << 8 | (this.mParameters[3] & 0xFF) << 16;
            this.mTimeToCharge = this.mParameters[4] & 0xFF | (this.mParameters[5] & 0xFF) << 8 | (this.mParameters[6] & 0xFF) << 16;
            this.mFlags = this.mParameters[7] & 0xFF;
            MeshLogger.verbose(TAG, "Time to discharge: " + this.mTimeToDischarge);
            MeshLogger.verbose(TAG, "Time to charge: " + this.mTimeToCharge);
            MeshLogger.verbose(TAG, "Flags: " + this.mFlags);
        }
    }

    @Override
    public int getOpCode() {
        return 33316;
    }

    public int getBatteryLevel() {
        return this.mBatteryLevel;
    }

    public int getTimeToDischarge() {
        return this.mTimeToDischarge;
    }

    public int getTimeToCharge() {
        return this.mTimeToCharge;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public BatteryPresence getBatteryPresence() {
        return BatteryPresence.getBatteryPresence(this.mFlags & 3);
    }

    public BatteryIndicator getBatteryIndicator() {
        return BatteryIndicator.getBatteryIndicator(this.mFlags >> 2 & 3);
    }

    public BatteryChargingState getBatteryChargingState() {
        return BatteryChargingState.getBatteryChargingState(this.mFlags >> 4 & 3);
    }

    public BatteryServiceability batteryServiceability() {
        return BatteryServiceability.getBatteryServiceability(this.mFlags >> 6 & 3);
    }

    public static enum BatteryServiceability {
        RESERVED(0),
        SERVICE_NOT_REQUIRED(1),
        SERVICE_REQUIRED(2),
        UNKNOWN(3);

        private final int flag;

        private BatteryServiceability(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        public static BatteryServiceability getBatteryServiceability(int flag) {
            for (BatteryServiceability bs : BatteryServiceability.values()) {
                if (bs.flag != flag) continue;
                return bs;
            }
            throw new IllegalArgumentException("BatteryServiceability flag not found");
        }
    }

    public static enum BatteryChargingState {
        NOT_CHARGEABLE(0),
        NOT_CHARGING(1),
        CHARGING(2),
        UNKNOWN(3);

        private final int flag;

        private BatteryChargingState(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        public static BatteryChargingState getBatteryChargingState(int flag) {
            for (BatteryChargingState bcs : BatteryChargingState.values()) {
                if (bcs.flag != flag) continue;
                return bcs;
            }
            throw new IllegalArgumentException("BatteryChargingState flag not found");
        }
    }

    public static enum BatteryIndicator {
        CRITICALLY_LOW(0),
        LOW(1),
        GOOD(2),
        UNKNOWN(3);

        private final int flag;

        private BatteryIndicator(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        public static BatteryIndicator getBatteryIndicator(int flag) {
            for (BatteryIndicator bi : BatteryIndicator.values()) {
                if (bi.flag != flag) continue;
                return bi;
            }
            throw new IllegalArgumentException("BatteryIndicator flag not found");
        }
    }

    public static enum BatteryPresence {
        NOT_PRESENT(0),
        REMOVABLE(1),
        NOT_REMOVABLE(2),
        UNKNOWN(3);

        private final int flag;

        private BatteryPresence(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        public static BatteryPresence getBatteryPresence(int flag) {
            for (BatteryPresence bp : BatteryPresence.values()) {
                if (bp.flag != flag) continue;
                return bp;
            }
            throw new IllegalArgumentException("BatteryPresence flag not found");
        }
    }
}

