/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.NetworkKey;

abstract class Message
implements Parcelable {
    protected int ctl;
    protected SparseArray<byte[]> networkLayerPdu;
    private int pduType;
    private int ttl = 100;
    private int src;
    private int dst;
    private byte[] mSequenceNumber;
    private byte[] deviceKey;
    private ApplicationKey applicationKey;
    private NetworkKey networkKey;
    private byte[] encryptionKey;
    private byte[] privacyKey;
    private int akf;
    private int aid;
    private int aszmic;
    private int opCode;
    private byte[] parameters;
    private int companyIdentifier;
    private byte[] ivIndex;
    private boolean segmented;

    Message() {
    }

    protected Message(Parcel source) {
        this.ctl = source.readInt();
        this.networkLayerPdu = this.readSparseArrayToParcelable(source);
        this.pduType = source.readInt();
        this.ttl = source.readInt();
        this.src = source.readInt();
        this.dst = source.readInt();
        this.mSequenceNumber = source.createByteArray();
        this.deviceKey = source.createByteArray();
        this.applicationKey = (ApplicationKey)source.readValue(ApplicationKey.class.getClassLoader());
        this.networkKey = (NetworkKey)source.readValue(NetworkKey.class.getClassLoader());
        this.encryptionKey = source.createByteArray();
        this.privacyKey = source.createByteArray();
        this.akf = source.readInt();
        this.aid = source.readInt();
        this.aszmic = source.readInt();
        this.opCode = source.readInt();
        this.parameters = source.createByteArray();
        this.companyIdentifier = source.readInt();
        this.ivIndex = source.createByteArray();
        this.segmented = source.readInt() == 1;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.ctl);
        this.writeSparseArrayToParcelable(dest, this.networkLayerPdu);
        dest.writeInt(this.pduType);
        dest.writeInt(this.ttl);
        dest.writeInt(this.src);
        dest.writeInt(this.dst);
        dest.writeByteArray(this.mSequenceNumber);
        dest.writeByteArray(this.deviceKey);
        dest.writeValue((Object)this.applicationKey);
        dest.writeValue((Object)this.networkKey);
        dest.writeByteArray(this.encryptionKey);
        dest.writeByteArray(this.privacyKey);
        dest.writeInt(this.akf);
        dest.writeInt(this.aid);
        dest.writeInt(this.aszmic);
        dest.writeInt(this.opCode);
        dest.writeByteArray(this.parameters);
        dest.writeInt(this.companyIdentifier);
        dest.writeByteArray(this.ivIndex);
        dest.writeInt(this.segmented ? 1 : 0);
    }

    public abstract int getCtl();

    int getPduType() {
        return this.pduType;
    }

    void setPduType(int pduType) {
        this.pduType = pduType;
    }

    public final int getTtl() {
        return this.ttl;
    }

    public final void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public final int getSrc() {
        return this.src;
    }

    public final void setSrc(int src) {
        this.src = src;
    }

    public final int getDst() {
        return this.dst;
    }

    public final void setDst(int dst) {
        this.dst = dst;
    }

    public final byte[] getSequenceNumber() {
        return this.mSequenceNumber;
    }

    public final void setSequenceNumber(byte[] sequenceNumber) {
        this.mSequenceNumber = sequenceNumber;
    }

    public final byte[] getDeviceKey() {
        return this.deviceKey;
    }

    public final void setDeviceKey(byte[] deviceKey) {
        this.deviceKey = deviceKey;
    }

    public final ApplicationKey getApplicationKey() {
        return this.applicationKey;
    }

    public final void setApplicationKey(ApplicationKey key) {
        this.applicationKey = key;
    }

    public NetworkKey getNetworkKey() {
        return this.networkKey;
    }

    public void setNetworkKey(NetworkKey networkKey) {
        this.networkKey = networkKey;
    }

    public final byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    public final void setEncryptionKey(byte[] encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public final byte[] getPrivacyKey() {
        return this.privacyKey;
    }

    public final void setPrivacyKey(byte[] privacyKey) {
        this.privacyKey = privacyKey;
    }

    public final int getAkf() {
        return this.akf;
    }

    public final void setAkf(int akf) {
        this.akf = akf;
    }

    public final int getAid() {
        return this.aid;
    }

    public final void setAid(int aid) {
        this.aid = aid;
    }

    public final int getAszmic() {
        return this.aszmic;
    }

    public final void setAszmic(int aszmic) {
        this.aszmic = aszmic;
    }

    public final int getOpCode() {
        return this.opCode;
    }

    public final void setOpCode(int opCode) {
        this.opCode = opCode;
    }

    public final byte[] getParameters() {
        return this.parameters;
    }

    public final void setParameters(byte[] parameters) {
        this.parameters = parameters;
    }

    public final int getCompanyIdentifier() {
        return this.companyIdentifier;
    }

    public final void setCompanyIdentifier(int companyIdentifier) {
        this.companyIdentifier = companyIdentifier;
    }

    public final byte[] getIvIndex() {
        return this.ivIndex;
    }

    public final void setIvIndex(byte[] ivIndex) {
        this.ivIndex = ivIndex;
    }

    public final boolean isSegmented() {
        return this.segmented;
    }

    final void setSegmented(boolean segmented) {
        this.segmented = segmented;
    }

    public final SparseArray<byte[]> getNetworkLayerPdu() {
        return this.networkLayerPdu;
    }

    final void setNetworkLayerPdu(SparseArray<byte[]> pdu) {
        this.networkLayerPdu = pdu;
    }

    protected final void writeSparseArrayToParcelable(Parcel dest, SparseArray<byte[]> array) {
        int size = array.size();
        dest.writeInt(size);
        for (int i = 0; i < size; ++i) {
            dest.writeByteArray((byte[])array.valueAt(i));
        }
    }

    protected final SparseArray<byte[]> readSparseArrayToParcelable(Parcel src) {
        SparseArray array = new SparseArray();
        int size = src.readInt();
        for (int i = 0; i < size; ++i) {
            array.put(i, (Object)src.createByteArray());
        }
        return array;
    }
}

