/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.Scene;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class SceneDelete
extends ApplicationMessage {
    private static final String TAG = SceneDelete.class.getSimpleName();
    private static final int OP_CODE = 33438;
    private static final int SCENE_DELETE_PARAMS_LENGTH = 2;
    private int sceneNumber;

    public SceneDelete(@NonNull ApplicationKey appKey, int sceneNumber) {
        super(appKey);
        if (Scene.isValidSceneNumber(sceneNumber)) {
            this.sceneNumber = sceneNumber;
        }
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33438;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        MeshLogger.verbose(TAG, "Scene Number: " + this.sceneNumber);
        ByteBuffer paramsBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.putShort((short)this.sceneNumber);
        this.mParameters = paramsBuffer.array();
    }

    public int getSceneNumber() {
        return this.sceneNumber;
    }
}

