/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.Scene;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class SceneStoreUnacknowledged
extends ApplicationMessage {
    private static final String TAG = SceneStoreUnacknowledged.class.getSimpleName();
    private static final int OP_CODE = 33351;
    private static final int SCENE_STORE_PARAMS_LENGTH = 2;
    private int mSceneNumber;

    public SceneStoreUnacknowledged(@NonNull ApplicationKey appKey, int sceneNumber) {
        super(appKey);
        if (Scene.isValidSceneNumber(sceneNumber)) {
            this.mSceneNumber = sceneNumber;
        }
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33351;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        MeshLogger.verbose(TAG, "Scenes Number: " + this.mSceneNumber);
        ByteBuffer paramsBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.putShort((short)this.mSceneNumber);
        this.mParameters = paramsBuffer.array();
    }
}

