/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

public enum AuthenticationOOBMethods {
    NO_OOB_AUTHENTICATION(0),
    STATIC_OOB_AUTHENTICATION(1),
    OUTPUT_OOB_AUTHENTICATION(2),
    INPUT_OOB_AUTHENTICATION(3);

    private short authenticationMethod;

    private AuthenticationOOBMethods(short authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public short getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public static AuthenticationOOBMethods fromValue(int method) {
        switch (method) {
            case 0: {
                return NO_OOB_AUTHENTICATION;
            }
            case 1: {
                return STATIC_OOB_AUTHENTICATION;
            }
            case 2: {
                return OUTPUT_OOB_AUTHENTICATION;
            }
            case 3: {
                return INPUT_OOB_AUTHENTICATION;
            }
        }
        return null;
    }

    public static String getAuthenticationMethodName(AuthenticationOOBMethods type) {
        switch (type) {
            case NO_OOB_AUTHENTICATION: {
                return "No OOB";
            }
            case STATIC_OOB_AUTHENTICATION: {
                return "Static OOB";
            }
            case OUTPUT_OOB_AUTHENTICATION: {
                return "Output OOB";
            }
            case INPUT_OOB_AUTHENTICATION: {
                return "Input OOB";
            }
        }
        return "Prohibited";
    }
}

