/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import java.util.Arrays;

public class BitReader {
    private static final int[] BACK_MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127};
    private static final int[] FRONT_MASK = new int[]{0, 128, 192, 224, 240, 248, 252, 254};
    private byte[] byteBuffer;
    private int currentByte;
    private int currentBit;
    private int eofByte;
    private boolean eofFlag;

    public BitReader(byte[] byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.currentByte = 0;
        this.currentBit = 0;
        this.eofByte = byteBuffer.length;
    }

    public int bitsLeft() {
        return this.byteBuffer.length * 8 - this.currentBit;
    }

    public byte[] getRemainingBytes() {
        return Arrays.copyOfRange(this.byteBuffer, this.currentByte, this.byteBuffer.length);
    }

    public int getBits(int bitsToRead) {
        if (bitsToRead < 0) {
            throw new IllegalArgumentException("Bits to read may not be negative");
        }
        if (bitsToRead == 0) {
            return 0;
        }
        if (this.eofFlag) {
            return -1;
        }
        int toStore = 0;
        while (bitsToRead != 0 && !this.eofFlag) {
            int cb;
            if (this.currentBit < 0 || this.currentBit > 7) {
                throw new IllegalStateException("byte=" + this.currentByte + ", bit = " + this.currentBit);
            }
            int bitsLeft = 8 - this.currentBit;
            if (bitsToRead >= bitsLeft) {
                toStore <<= bitsLeft;
                bitsToRead -= bitsLeft;
                cb = this.byteBuffer[this.currentByte];
                if (this.currentBit == 0) {
                    toStore += cb & 0xFF;
                } else {
                    toStore += cb & BACK_MASK[bitsLeft];
                    this.currentBit = 0;
                }
                ++this.currentByte;
            } else {
                toStore <<= bitsToRead;
                cb = this.byteBuffer[this.currentByte] & 0xFF;
                toStore += (cb & 255 - FRONT_MASK[this.currentBit]) >> bitsLeft - bitsToRead;
                this.currentBit += bitsToRead;
                bitsToRead = 0;
            }
            if (this.currentByte != this.eofByte) continue;
            this.eofFlag = true;
            return toStore;
        }
        return toStore;
    }
}

