/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.logger.MeshLogger;

final class AllocatedSceneRangeDeserializer
implements JsonSerializer<List<AllocatedSceneRange>>,
JsonDeserializer<List<AllocatedSceneRange>> {
    private static final String TAG = AllocatedSceneRangeDeserializer.class.getSimpleName();

    AllocatedSceneRangeDeserializer() {
    }

    public List<AllocatedSceneRange> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<AllocatedSceneRange> sceneRanges = new ArrayList<AllocatedSceneRange>();
        try {
            JsonArray jsonObject = json.getAsJsonArray();
            for (int i = 0; i < jsonObject.size(); ++i) {
                JsonObject unicastRangeJson = jsonObject.get(i).getAsJsonObject();
                int firstScene = Integer.parseInt(unicastRangeJson.get("firstScene").getAsString(), 16);
                int lastScene = Integer.parseInt(unicastRangeJson.get("lastScene").getAsString(), 16);
                sceneRanges.add(new AllocatedSceneRange(firstScene, lastScene));
            }
        }
        catch (Exception ex) {
            MeshLogger.error(TAG, "Error while de-serializing allocated scene range: " + ex.getMessage());
        }
        return sceneRanges;
    }

    public JsonElement serialize(List<AllocatedSceneRange> ranges, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        for (AllocatedSceneRange range : ranges) {
            JsonObject rangeJson = new JsonObject();
            rangeJson.addProperty("firstScene", String.format(Locale.US, "%04X", range.getFirstScene()));
            rangeJson.addProperty("lastScene", String.format(Locale.US, "%04X", range.getLastScene()));
            jsonArray.add((JsonElement)rangeJson);
        }
        return jsonArray;
    }
}

