/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.nio.ByteBuffer;
import no.nordicsemi.android.mesh.InternalProvisioningCallbacks;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.MeshProvisioningStatusCallbacks;
import no.nordicsemi.android.mesh.logger.MeshLogger;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningState;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedMeshNode;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class ProvisioningDataState
extends ProvisioningState {
    private final String TAG = ProvisioningDataState.class.getSimpleName();
    private final UnprovisionedMeshNode mUnprovisionedMeshNode;
    private final MeshProvisioningStatusCallbacks mStatusCallbacks;
    private final InternalProvisioningCallbacks provisioningCallbacks;
    private final InternalTransportCallbacks mInternalTransportCallbacks;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ProvisioningDataState(@NonNull UnprovisionedMeshNode node, @NonNull InternalProvisioningCallbacks callbacks, @NonNull InternalTransportCallbacks internalTransportCallbacks, @NonNull MeshProvisioningStatusCallbacks meshProvisioningStatusCallbacks) {
        this.provisioningCallbacks = callbacks;
        this.mUnprovisionedMeshNode = node;
        this.mInternalTransportCallbacks = internalTransportCallbacks;
        this.mStatusCallbacks = meshProvisioningStatusCallbacks;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_DATA;
    }

    @Override
    public void executeSend() {
        this.sendProvisioningData();
    }

    @Override
    public boolean parseData(@NonNull byte[] data) {
        return true;
    }

    private void sendProvisioningData() {
        byte[] provisioningDataPDU = this.createProvisioningDataPDU();
        this.mStatusCallbacks.onProvisioningStateChanged(this.mUnprovisionedMeshNode, ProvisioningState.States.PROVISIONING_DATA_SENT, provisioningDataPDU);
        this.mInternalTransportCallbacks.sendProvisioningPdu(this.mUnprovisionedMeshNode, provisioningDataPDU);
    }

    private byte[] createProvisioningDataPDU() {
        byte[] provisioningSalt = this.generateProvisioningSalt();
        MeshLogger.verbose(this.TAG, "Provisioning salt: " + MeshParserUtils.bytesToHex(provisioningSalt, false));
        byte[] ecdh = this.mUnprovisionedMeshNode.getSharedECDHSecret();
        byte[] t = SecureUtils.calculateCMAC(ecdh, provisioningSalt);
        byte[] sessionKey = SecureUtils.calculateCMAC(SecureUtils.PRSK, t);
        MeshLogger.verbose(this.TAG, "Session key: " + MeshParserUtils.bytesToHex(sessionKey, false));
        byte[] sessionNonce = this.generateSessionNonce(ecdh, provisioningSalt);
        MeshLogger.verbose(this.TAG, "Session nonce: " + MeshParserUtils.bytesToHex(sessionNonce, false));
        byte[] deviceKey = SecureUtils.calculateCMAC(SecureUtils.PRDK, t);
        MeshLogger.verbose(this.TAG, "Device key: " + MeshParserUtils.bytesToHex(deviceKey, false));
        this.mUnprovisionedMeshNode.setDeviceKey(deviceKey);
        byte[] networkKey = this.mUnprovisionedMeshNode.getNetworkKey();
        MeshLogger.verbose(this.TAG, "Network key: " + MeshParserUtils.bytesToHex(networkKey, false));
        byte[] keyIndex = MeshParserUtils.addKeyIndexPadding(this.mUnprovisionedMeshNode.getKeyIndex());
        MeshLogger.verbose(this.TAG, "Key index: " + MeshParserUtils.bytesToHex(keyIndex, false));
        byte[] flags = this.mUnprovisionedMeshNode.getFlags();
        MeshLogger.verbose(this.TAG, "Flags: " + MeshParserUtils.bytesToHex(flags, false));
        byte[] ivIndex = this.mUnprovisionedMeshNode.getIvIndex();
        MeshLogger.verbose(this.TAG, "IV index: " + MeshParserUtils.bytesToHex(ivIndex, false));
        byte[] unicastAddress = MeshAddress.addressIntToBytes(this.mUnprovisionedMeshNode.getUnicastAddress());
        MeshLogger.verbose(this.TAG, "Unicast address: " + MeshParserUtils.bytesToHex(unicastAddress, false));
        ByteBuffer buffer = ByteBuffer.allocate(networkKey.length + keyIndex.length + flags.length + ivIndex.length + unicastAddress.length);
        buffer.put(networkKey);
        buffer.put(keyIndex);
        buffer.put(flags);
        buffer.put(ivIndex);
        buffer.put(unicastAddress);
        byte[] provisioningData = buffer.array();
        MeshLogger.verbose(this.TAG, "Provisioning data: " + MeshParserUtils.bytesToHex(provisioningData, false));
        byte[] encryptedProvisioningData = SecureUtils.encryptCCM(provisioningData, sessionKey, sessionNonce, 8);
        if (encryptedProvisioningData == null) {
            throw new IllegalArgumentException("Failed to encrypt provisioning data!");
        }
        buffer = ByteBuffer.allocate(2 + encryptedProvisioningData.length);
        MeshLogger.verbose(this.TAG, "Encrypted provisioning data: " + MeshParserUtils.bytesToHex(encryptedProvisioningData, false));
        buffer.put((byte)3);
        buffer.put((byte)7);
        buffer.put(encryptedProvisioningData);
        byte[] provisioningPDU = buffer.array();
        MeshLogger.verbose(this.TAG, "Prov Data: " + MeshParserUtils.bytesToHex(provisioningPDU, false));
        return provisioningPDU;
    }

    private byte[] generateProvisioningSalt() {
        byte[] confirmationSalt = SecureUtils.calculateSalt(this.provisioningCallbacks.generateConfirmationInputs(this.mUnprovisionedMeshNode.getProvisionerPublicKeyXY(), this.mUnprovisionedMeshNode.getProvisioneePublicKeyXY()));
        byte[] provisionerRandom = this.mUnprovisionedMeshNode.getProvisionerRandom();
        byte[] provisioneeRandom = this.mUnprovisionedMeshNode.getProvisioneeRandom();
        ByteBuffer buffer = ByteBuffer.allocate(confirmationSalt.length + provisionerRandom.length + provisioneeRandom.length);
        buffer.put(confirmationSalt);
        buffer.put(provisionerRandom);
        buffer.put(provisioneeRandom);
        return SecureUtils.calculateSalt(buffer.array());
    }

    private byte[] generateSessionNonce(byte[] ecdh, byte[] provisioningSalt) {
        byte[] nonce = SecureUtils.calculateK1(ecdh, provisioningSalt, SecureUtils.PRSN);
        ByteBuffer buffer = ByteBuffer.allocate(nonce.length - 3);
        buffer.put(nonce, 3, buffer.limit());
        return buffer.array();
    }
}

