/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;

public class Coefficient
extends DevicePropertyCharacteristic<Float> {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Coefficient(@NonNull byte[] data, int offset) {
        super(data, offset);
        this.value = Float.valueOf(ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getFloat(offset));
    }

    public Coefficient(float coefficient) {
        this.value = Float.valueOf(coefficient);
    }

    @NonNull
    public String toString() {
        return String.format(Locale.US, "%.2f", this.value);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public byte[] getBytes() {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(((Float)this.value).floatValue()).array();
    }
}

