/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;

public abstract class StatusTriggerDelta<T> {
    private final T up;
    private final T down;

    public StatusTriggerDelta(T down, T up) {
        this.up = up;
        this.down = down;
    }

    public T getUp() {
        return this.up;
    }

    public T getDown() {
        return this.down;
    }

    public abstract int getLength();

    public static class Percent
    extends StatusTriggerDelta<Float> {
        public Percent(float down, float up) {
            super(Float.valueOf(down), Float.valueOf(up));
        }

        @Override
        public int getLength() {
            return 4;
        }
    }

    public static class Characteristic<T>
    extends StatusTriggerDelta<DevicePropertyCharacteristic<T>> {
        public Characteristic(DevicePropertyCharacteristic<T> down, DevicePropertyCharacteristic<T> up) {
            super(down, up);
        }

        @Override
        public int getLength() {
            return ((DevicePropertyCharacteristic)this.getDown()).getLength() + ((DevicePropertyCharacteristic)this.getUp()).getLength();
        }
    }
}

